/*
 * Decompiled with CFR 0.152.
 */
package zepsizola.me.zPvPToggle.indicator;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Vibration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zepsizola.me.zPvPToggle.ZPvPToggle;
import zepsizola.me.zPvPToggle.indicator.ParticleRingSettings;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eJ\u0006\u0010\u000f\u001a\u00020\tJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0006J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lzepsizola/me/zPvPToggle/indicator/ParticleRingManager;", "", "plugin", "Lzepsizola/me/zPvPToggle/ZPvPToggle;", "(Lzepsizola/me/zPvPToggle/ZPvPToggle;)V", "defaultRingId", "", "rings", "Ljava/util/concurrent/ConcurrentHashMap;", "Lzepsizola/me/zPvPToggle/indicator/ParticleRingSettings;", "colorFromString", "Lorg/bukkit/Color;", "name", "getAllRings", "", "getDefaultRing", "getExtra", "particleType", "Lorg/bukkit/Particle;", "section", "Lorg/bukkit/configuration/ConfigurationSection;", "getRing", "id", "loadRingFromConfig", "loadRings", "", "ZPvPToggle"})
public final class ParticleRingManager {
    @NotNull
    private final ZPvPToggle plugin;
    @NotNull
    private final ConcurrentHashMap<String, ParticleRingSettings> rings;
    @NotNull
    private String defaultRingId;

    public ParticleRingManager(@NotNull ZPvPToggle plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
        this.rings = new ConcurrentHashMap();
        this.defaultRingId = "default";
    }

    public final void loadRings() {
        String string;
        this.rings.clear();
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection("particle-indicator.indicators");
        if (section == null) {
            ((Map)this.rings).put("default", ParticleRingSettings.Companion.createDefault("default"));
            return;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection ringSection = section.getConfigurationSection(key);
            if (ringSection == null) continue;
            Intrinsics.checkNotNull((Object)key);
            ParticleRingSettings ring = this.loadRingFromConfig(key, ringSection);
            ((Map)this.rings).put(key, ring);
        }
        if (this.rings.isEmpty()) {
            ((Map)this.rings).put("default", ParticleRingSettings.Companion.createDefault("default"));
        }
        if ((string = this.plugin.getConfig().getString("particle-indicator.default-indicator", "default")) == null) {
            string = this.defaultRingId = "default";
        }
        if (!this.rings.containsKey(this.defaultRingId)) {
            Set set = this.rings.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
            Object object = CollectionsKt.first((Iterable)set);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            this.defaultRingId = (String)object;
        }
    }

    private final ParticleRingSettings loadRingFromConfig(String id, ConfigurationSection section) {
        Particle particle;
        String string = section.getString("type");
        if (string == null) {
            string = "DUST";
        }
        String typeName = string;
        try {
            particle = Particle.valueOf((String)typeName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.plugin.getLogger().warning("Invalid particle type: " + typeName + ", using REDSTONE instead");
            particle = Particle.DUST;
        }
        Particle particleType = particle;
        int n = section.getInt("points", 32);
        double d = section.getDouble("radius", 0.7);
        long l = section.getInt("interval", 5);
        boolean bl = section.getBoolean("random-particle-positions", false);
        double d2 = section.getDouble("y-offset", 0.1);
        double d3 = section.getDouble("random-offset-vertical", 0.0);
        double d4 = section.getDouble("random-offset-horizontal", 0.0);
        double d5 = section.getDouble("speed", 0.0);
        Object object = this.getExtra(particleType, section);
        return new ParticleRingSettings(id, particleType, n, d, d2, d3, d4, l, bl, d5, object);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object getExtra(@NotNull Particle particleType, @NotNull ConfigurationSection section) {
        Intrinsics.checkNotNullParameter((Object)particleType, (String)"particleType");
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        switch (WhenMappings.$EnumSwitchMapping$0[particleType.ordinal()]) {
            case 1: {
                v0 = section.getString("color", "RED");
                if (v0 == null) {
                    v0 = "RED";
                }
                color = this.colorFromString(v0);
                dustSize = (float)section.getDouble("dust-size", 1.0);
                v1 /* !! */  = new Particle.DustOptions(color, dustSize);
                break;
            }
            case 2: {
                v2 = section.getString("from-color", "RED");
                if (v2 == null) {
                    v2 = "RED";
                }
                fromColor = this.colorFromString(v2);
                v3 = section.getString("to-color", "BLUE");
                if (v3 == null) {
                    v3 = "BLUE";
                }
                toColor = this.colorFromString(v3);
                v1 /* !! */  = new Particle.DustTransition(fromColor, toColor, (float)section.getDouble("dust-size", 1.0));
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                v4 = section.getString("block-data", "STONE");
                if (v4 == null) {
                    v4 = "STONE";
                }
                if ((v5 = Material.getMaterial((String)(blockData = v4))) == null) {
                    v5 = Material.STONE;
                }
                var5_17 = v5;
                Intrinsics.checkNotNull((Object)var5_17);
                blockType = var5_17;
                v1 /* !! */  = blockType.createBlockData();
                break;
            }
            case 7: {
                v6 = section.getString("item-data", "EMERALD");
                if (v6 == null) {
                    v6 = "EMERALD";
                }
                if ((v7 = Material.getMaterial((String)(itemString = v6))) == null) {
                    v7 = Material.EMERALD;
                }
                itemStack = new ItemStack(v7);
                v1 /* !! */  = itemStack;
                break;
            }
            case 8: {
                v8 = section.getString("color", "RED");
                if (v8 == null) ** GOTO lbl50
                v9 = v8.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"toUpperCase(...)");
                v8 = v9;
                if (v9 != null) ** GOTO lbl51
lbl50:
                // 2 sources

                v8 = "RED";
lbl51:
                // 2 sources

                colorName = v8;
                color = this.colorFromString(colorName);
                v1 /* !! */  = color;
                break;
            }
            case 9: {
                sculkCharge = (float)section.getDouble("sculk-charge", 1.0);
                v1 /* !! */  = Float.valueOf(sculkCharge);
                break;
            }
            case 10: {
                sculkShriek = section.getInt("sculk-shriek", 1);
                v1 /* !! */  = sculkShriek;
                break;
            }
            case 11: {
                arrivalTime = section.getInt("arrival-time", 20);
                v10 = section.getLocation("destination", new Location(null, 0.0, 0.0, 0.0));
                if (v10 == null) {
                    v10 = new Location(null, 0.0, 0.0, 0.0);
                }
                destination = new Vibration.Destination.BlockDestination(v10);
                v1 /* !! */  = new Vibration((Vibration.Destination)destination, arrivalTime);
                break;
            }
            default: {
                v1 /* !! */  = null;
            }
        }
        return v1 /* !! */ ;
    }

    @NotNull
    public final ParticleRingSettings getRing(@NotNull String id) {
        ParticleRingSettings particleRingSettings;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ParticleRingSettings particleRingSettings2 = this.rings.get(id);
        if (particleRingSettings2 == null) {
            particleRingSettings2 = particleRingSettings = this.rings.get(this.defaultRingId);
        }
        if (particleRingSettings2 == null) {
            particleRingSettings = ParticleRingSettings.Companion.createDefault("default");
        }
        return particleRingSettings;
    }

    @NotNull
    public final ParticleRingSettings getDefaultRing() {
        ParticleRingSettings particleRingSettings = this.rings.get(this.defaultRingId);
        if (particleRingSettings == null) {
            particleRingSettings = ParticleRingSettings.Companion.createDefault("default");
        }
        return particleRingSettings;
    }

    @NotNull
    public final Collection<ParticleRingSettings> getAllRings() {
        Collection<ParticleRingSettings> collection = this.rings.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    @NotNull
    public final Color colorFromString(@NotNull String name) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        switch (name) {
            case "WHITE": {
                Color color2 = Color.WHITE;
                color = color2;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"WHITE");
                break;
            }
            case "SILVER": {
                Color color3 = Color.SILVER;
                color = color3;
                Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"SILVER");
                break;
            }
            case "GRAY": {
                Color color4 = Color.GRAY;
                color = color4;
                Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"GRAY");
                break;
            }
            case "BLACK": {
                Color color5 = Color.BLACK;
                color = color5;
                Intrinsics.checkNotNullExpressionValue((Object)color5, (String)"BLACK");
                break;
            }
            case "RED": {
                Color color6 = Color.RED;
                color = color6;
                Intrinsics.checkNotNullExpressionValue((Object)color6, (String)"RED");
                break;
            }
            case "MAROON": {
                Color color7 = Color.MAROON;
                color = color7;
                Intrinsics.checkNotNullExpressionValue((Object)color7, (String)"MAROON");
                break;
            }
            case "YELLOW": {
                Color color8 = Color.YELLOW;
                color = color8;
                Intrinsics.checkNotNullExpressionValue((Object)color8, (String)"YELLOW");
                break;
            }
            case "OLIVE": {
                Color color9 = Color.OLIVE;
                color = color9;
                Intrinsics.checkNotNullExpressionValue((Object)color9, (String)"OLIVE");
                break;
            }
            case "LIME": {
                Color color10 = Color.LIME;
                color = color10;
                Intrinsics.checkNotNullExpressionValue((Object)color10, (String)"LIME");
                break;
            }
            case "GREEN": {
                Color color11 = Color.GREEN;
                color = color11;
                Intrinsics.checkNotNullExpressionValue((Object)color11, (String)"GREEN");
                break;
            }
            case "AQUA": {
                Color color12 = Color.AQUA;
                color = color12;
                Intrinsics.checkNotNullExpressionValue((Object)color12, (String)"AQUA");
                break;
            }
            case "TEAL": {
                Color color13 = Color.TEAL;
                color = color13;
                Intrinsics.checkNotNullExpressionValue((Object)color13, (String)"TEAL");
                break;
            }
            case "BLUE": {
                Color color14 = Color.BLUE;
                color = color14;
                Intrinsics.checkNotNullExpressionValue((Object)color14, (String)"BLUE");
                break;
            }
            case "NAVY": {
                Color color15 = Color.NAVY;
                color = color15;
                Intrinsics.checkNotNullExpressionValue((Object)color15, (String)"NAVY");
                break;
            }
            case "FUCHSIA": {
                Color color16 = Color.FUCHSIA;
                color = color16;
                Intrinsics.checkNotNullExpressionValue((Object)color16, (String)"FUCHSIA");
                break;
            }
            case "PURPLE": {
                Color color17 = Color.PURPLE;
                color = color17;
                Intrinsics.checkNotNullExpressionValue((Object)color17, (String)"PURPLE");
                break;
            }
            case "ORANGE": {
                Color color18 = Color.ORANGE;
                color = color18;
                Intrinsics.checkNotNullExpressionValue((Object)color18, (String)"ORANGE");
                break;
            }
            default: {
                if (StringsKt.startsWith$default((String)name, (String)"#", (boolean)false, (int)2, null) && name.length() == 7) {
                    String string = name.substring(1, 3);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    int r = Integer.parseInt(string, 16);
                    String string2 = name.substring(3, 5);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    int g = Integer.parseInt(string2, 16);
                    String string3 = name.substring(5, 7);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    int b = Integer.parseInt(string3, 16);
                    Color color19 = Color.fromRGB((int)r, (int)g, (int)b);
                    Intrinsics.checkNotNullExpressionValue((Object)color19, (String)"fromRGB(...)");
                    return color19;
                }
                Color color20 = Color.GRAY;
                Intrinsics.checkNotNull((Object)color20);
                color = color20;
            }
        }
        return color;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Particle.values().length];
            try {
                nArray[Particle.DUST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Particle.DUST_COLOR_TRANSITION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Particle.BLOCK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Particle.BLOCK_MARKER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Particle.DUST_PILLAR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Particle.FALLING_DUST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Particle.ITEM.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Particle.ENTITY_EFFECT.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Particle.SCULK_CHARGE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Particle.SHRIEK.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Particle.VIBRATION.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

