/*
 * Decompiled with CFR 0.152.
 */
package zepsizola.me.zPvPToggle.managers;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import zepsizola.me.zPvPToggle.ZPvPToggle;
import zepsizola.me.zPvPToggle.data.DatabaseManagerImpl;
import zepsizola.me.zPvPToggle.managers.PlayerState;
import zepsizola.me.zPvPToggle.managers.PvpManager;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0010J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u001bJ\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\rJ\u0018\u0010&\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00102\b\b\u0002\u0010'\u001a\u00020(J\u0016\u0010)\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u0016J\u0016\u0010+\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0012J\u0006\u0010-\u001a\u00020!J\u000e\u0010.\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010/\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u00100\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J\u0018\u00101\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u0012H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lzepsizola/me/zPvPToggle/managers/PvpManager;", "", "plugin", "Lzepsizola/me/zPvPToggle/ZPvPToggle;", "(Lzepsizola/me/zPvPToggle/ZPvPToggle;)V", "databaseManager", "Lzepsizola/me/zPvPToggle/data/DatabaseManagerImpl;", "getDatabaseManager", "()Lzepsizola/me/zPvPToggle/data/DatabaseManagerImpl;", "setDatabaseManager", "(Lzepsizola/me/zPvPToggle/data/DatabaseManagerImpl;)V", "playerStates", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lzepsizola/me/zPvPToggle/managers/PlayerState;", "pvpEnabledPlayers", "Lorg/bukkit/entity/Player;", "canSeeIndicators", "", "player", "canSeeOwnIndicator", "formatCooldownTime", "", "timeMillis", "", "getIndicatorRingId", "getPvpEnabledPlayers", "", "getRemainingCooldown", "getRemainingCooldownString", "getState", "hasCooldown", "initializePvpEnabledCache", "", "isFirstToggleOnThisSession", "isPvpEnabled", "removePlayerData", "uuid", "setCooldown", "durationSeconds", "", "setIndicatorRing", "indicatorId", "setPvp", "enabled", "stop", "toggleIndicators", "toggleOwnIndicator", "togglePvp", "updatePvpEnabledCache", "pvpEnabled", "ZPvPToggle"})
public final class PvpManager {
    @NotNull
    private final ZPvPToggle plugin;
    @NotNull
    private final ConcurrentHashMap<UUID, PlayerState> playerStates;
    @NotNull
    private final ConcurrentHashMap<UUID, Player> pvpEnabledPlayers;
    public DatabaseManagerImpl databaseManager;

    public PvpManager(@NotNull ZPvPToggle plugin) {
        Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
        this.plugin = plugin;
        this.playerStates = new ConcurrentHashMap();
        this.pvpEnabledPlayers = new ConcurrentHashMap();
        this.plugin.getServer().getPluginManager().registerEvents(new Listener(){

            @EventHandler
            public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Player player = event.getPlayer();
                Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
                Player player2 = player;
                DatabaseManagerImpl databaseManagerImpl = this.getDatabaseManager();
                Player player3 = event.getPlayer();
                Intrinsics.checkNotNullExpressionValue((Object)player3, (String)"getPlayer(...)");
                databaseManagerImpl.loadPlayerData(player3);
                PlayerState state = this.getState(player2);
                if (!player2.hasPermission("zpvptoggle.indicator." + state.getIndicatorRingId())) {
                    state.setIndicatorRingId("default");
                }
                if (state.getPvpEnabled()) {
                    Map map = pvpEnabledPlayers;
                    UUID uUID = player2.getUniqueId();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
                    map.put(uUID, player2);
                }
            }

            @EventHandler
            public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                pvpEnabledPlayers.remove(event.getPlayer().getUniqueId());
                UUID uUID = event.getPlayer().getUniqueId();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
                this.removePlayerData(uUID);
            }
        }, (Plugin)this.plugin);
        this.setDatabaseManager(new DatabaseManagerImpl(this.plugin));
    }

    @NotNull
    public final DatabaseManagerImpl getDatabaseManager() {
        DatabaseManagerImpl databaseManagerImpl = this.databaseManager;
        if (databaseManagerImpl != null) {
            return databaseManagerImpl;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"databaseManager");
        return null;
    }

    public final void setDatabaseManager(@NotNull DatabaseManagerImpl databaseManagerImpl) {
        Intrinsics.checkNotNullParameter((Object)databaseManagerImpl, (String)"<set-?>");
        this.databaseManager = databaseManagerImpl;
    }

    @NotNull
    public final PlayerState getState(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerState playerState = this.playerStates.computeIfAbsent(player.getUniqueId(), arg_0 -> PvpManager.getState$lambda$0(getState.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)playerState, (String)"computeIfAbsent(...)");
        return playerState;
    }

    public final boolean togglePvp(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerState state = this.getState(player);
        this.setPvp(player, !state.getPvpEnabled());
        return state.getPvpEnabled();
    }

    public final void setPvp(@NotNull Player player, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerState state = this.getState(player);
        state.setPvpEnabled(enabled);
        this.updatePvpEnabledCache(player, enabled);
    }

    public final boolean isPvpEnabled(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.getState(player).getPvpEnabled();
    }

    public final boolean toggleIndicators(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerState state = this.getState(player);
        state.setCanSeeIndicators(!state.getCanSeeIndicators());
        this.getDatabaseManager().savePlayerIndicatorVisibility(player, state.getCanSeeIndicators());
        return state.getCanSeeIndicators();
    }

    public final boolean canSeeIndicators(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerState state = this.getState(player);
        return state.getCanSeeIndicators();
    }

    public final boolean toggleOwnIndicator(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerState state = this.getState(player);
        state.setCanSeeOwnIndicator(!state.getCanSeeOwnIndicator());
        this.getDatabaseManager().savePlayerOwnIndicatorVisibility(player, state.getCanSeeOwnIndicator());
        return state.getCanSeeOwnIndicator();
    }

    public final boolean canSeeOwnIndicator(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerState state = this.getState(player);
        return state.getCanSeeOwnIndicator();
    }

    public final void setIndicatorRing(@NotNull Player player, @NotNull String indicatorId) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)indicatorId, (String)"indicatorId");
        PlayerState state = this.getState(player);
        this.getDatabaseManager().savePlayerIndicator(player, indicatorId);
        state.setIndicatorRingId(indicatorId);
    }

    @NotNull
    public final String getIndicatorRingId(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.getState(player).getIndicatorRingId();
    }

    public final boolean isFirstToggleOnThisSession(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerState state = this.getState(player);
        boolean first = state.getFirstToggleOnThisSession();
        if (first) {
            state.setFirstToggleOnThisSession(false);
        }
        return first;
    }

    public final void removePlayerData(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.playerStates.remove(uuid);
        this.pvpEnabledPlayers.remove(uuid);
    }

    private final void updatePvpEnabledCache(Player player, boolean pvpEnabled) {
        if (pvpEnabled) {
            Map map = this.pvpEnabledPlayers;
            UUID uUID = player.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
            map.put(uUID, player);
        } else {
            this.pvpEnabledPlayers.remove(player.getUniqueId());
        }
    }

    @NotNull
    public final Collection<Player> getPvpEnabledPlayers() {
        Collection<Player> collection = this.pvpEnabledPlayers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return collection;
    }

    public final void initializePvpEnabledCache() {
        this.pvpEnabledPlayers.clear();
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            UUID uUID;
            Intrinsics.checkNotNull((Object)player);
            if (!this.getState(player).getPvpEnabled()) continue;
            Map map = this.pvpEnabledPlayers;
            Intrinsics.checkNotNullExpressionValue((Object)player.getUniqueId(), (String)"getUniqueId(...)");
            Player player2 = player;
            map.put(uUID, player2);
        }
    }

    public final void stop() {
        this.getDatabaseManager().close();
    }

    public final void setCooldown(@NotNull Player player, double durationSeconds) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (durationSeconds <= 0.0) {
            return;
        }
        PlayerState state = this.getState(player);
        state.setPvpCooldown(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis((long)durationSeconds));
    }

    public static /* synthetic */ void setCooldown$default(PvpManager pvpManager, Player player, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = pvpManager.plugin.getPvpCooldown();
        }
        pvpManager.setCooldown(player, d);
    }

    public final boolean hasCooldown(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (player.hasPermission("zpvptoggle.cooldown.bypass")) {
            return false;
        }
        PlayerState state = this.getState(player);
        return state.getPvpCooldown() > System.currentTimeMillis();
    }

    public final long getRemainingCooldown(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        PlayerState state = this.getState(player);
        long remaining = state.getPvpCooldown() - System.currentTimeMillis();
        return remaining > 0L ? remaining : 0L;
    }

    @NotNull
    public final String getRemainingCooldownString(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.formatCooldownTime(this.getRemainingCooldown(player));
    }

    @NotNull
    public final String formatCooldownTime(long timeMillis) {
        long seconds = timeMillis / (long)1000;
        if (seconds < 60L) {
            return seconds + "s";
        }
        long minutes = seconds / (long)60;
        long remainingSeconds = seconds % (long)60;
        if (minutes < 60L) {
            return remainingSeconds > 0L ? minutes + "m " + remainingSeconds + "s" : minutes + "m";
        }
        long hours = minutes / (long)60;
        long remainingMinutes = minutes % (long)60;
        return remainingMinutes > 0L ? hours + "h " + remainingMinutes + "m" : hours + "h";
    }

    private static final PlayerState getState$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (PlayerState)$tmp0.invoke(p0);
    }
}

