/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.plant;

import com.agricraft.agricraft.api.codecs.AgriParticleEffect;
import com.agricraft.agricraft.api.codecs.AgriProduct;
import com.agricraft.agricraft.api.codecs.AgriRequirement;
import com.agricraft.agricraft.api.codecs.AgriSeed;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.crop.AgriGrowthStage;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.api.plant.AgriPlantModifierFactoryRegistry;
import com.agricraft.agricraft.api.plant.AgriPlantModifierInfo;
import com.agricraft.agricraft.api.plant.IAgriPlantModifier;
import com.agricraft.agricraft.common.util.Platform;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AgriPlant {
    public static final Codec<AgriPlant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("mods").forGetter(plant -> plant.mods), (App)AgriSeed.CODEC.listOf().fieldOf("seeds").forGetter(plant -> plant.seeds), (App)Codec.INT.listOf().fieldOf("stages").forGetter(plant -> plant.stages), (App)Codec.INT.fieldOf("harvest_stage").forGetter(plant -> plant.harvestStage), (App)Codec.DOUBLE.fieldOf("growth_chance").forGetter(plant -> plant.growthChance), (App)Codec.DOUBLE.fieldOf("growth_bonus").forGetter(plant -> plant.growthBonus), (App)Codec.BOOL.fieldOf("cloneable").forGetter(plant -> plant.cloneable), (App)Codec.BOOL.optionalFieldOf("fireproof", (Object)false).forGetter(plant -> plant.fireproof), (App)Codec.DOUBLE.fieldOf("spread_chance").forGetter(plant -> plant.spreadChance), (App)AgriProduct.CODEC.listOf().optionalFieldOf("products", List.of()).forGetter(plant -> plant.products), (App)AgriProduct.CODEC.listOf().optionalFieldOf("clip_products", List.of()).forGetter(plant -> plant.clipProducts), (App)AgriRequirement.CODEC.fieldOf("requirement").forGetter(plant -> plant.requirement), (App)AgriPlantModifierInfo.CODEC.listOf().optionalFieldOf("modifiers", List.of()).forGetter(plant -> plant.modifierInfos), (App)AgriParticleEffect.CODEC.listOf().optionalFieldOf("particle_effects", List.of()).forGetter(plant -> plant.particleEffects)).apply((Applicative)instance, AgriPlant::new));
    public static final AgriPlant NO_PLANT = new Builder().harvest(0).chances(0.0, 0.0, 0.0).build();
    public static final ResourceLocation UNKNOWN = new ResourceLocation("agricraft:unknown");
    private final List<String> mods;
    private final List<AgriSeed> seeds;
    private final List<Integer> stages;
    private final int harvestStage;
    private final double growthChance;
    private final double growthBonus;
    private final boolean cloneable;
    private final boolean fireproof;
    private final double spreadChance;
    private final List<AgriProduct> products;
    private final List<AgriProduct> clipProducts;
    private final AgriRequirement requirement;
    private final List<AgriPlantModifierInfo> modifierInfos;
    private final List<AgriParticleEffect> particleEffects;
    private List<IAgriPlantModifier> modifiers;

    public AgriPlant(List<String> mods, List<AgriSeed> seeds, List<Integer> stages, int harvestStage, double growthChance, double growthBonus, boolean cloneable, boolean fireproof, double spreadChance, List<AgriProduct> products, List<AgriProduct> clipProducts, AgriRequirement requirement, List<AgriPlantModifierInfo> modifierInfos, List<AgriParticleEffect> particleEffects) {
        this.mods = mods;
        this.seeds = seeds;
        this.stages = stages;
        this.harvestStage = harvestStage;
        this.growthChance = growthChance;
        this.growthBonus = growthBonus;
        this.cloneable = cloneable;
        this.fireproof = fireproof;
        this.spreadChance = spreadChance;
        this.products = products;
        this.clipProducts = clipProducts;
        this.requirement = requirement;
        this.modifierInfos = modifierInfos;
        this.particleEffects = particleEffects;
    }

    public double getSpreadChance(AgriGrowthStage growthStage) {
        return this.spreadChance;
    }

    public double getGrowthChance(AgriGrowthStage growthStage) {
        return this.growthChance;
    }

    public double getBonusGrowthChance(AgriGrowthStage growthStage) {
        return this.growthBonus;
    }

    public AgriGrowthStage getInitialGrowthStage() {
        return new AgriGrowthStage(0, this.stages.size());
    }

    public AgriGrowthStage getGrowthStageAfterHarvest() {
        return new AgriGrowthStage(this.harvestStage, this.stages.size());
    }

    public int getPlantHeight(AgriGrowthStage stage) {
        if (stage.index() < 0 || stage.index() >= this.stages.size()) {
            return 0;
        }
        return this.stages.get(stage.index());
    }

    public boolean isSeedItem(ItemStack stack) {
        return this.seeds.stream().anyMatch(seed -> seed.isVariant(stack));
    }

    public AgriSeed getSeed(ItemStack stack) {
        return this.seeds.stream().filter(seed -> seed.isVariant(stack)).findFirst().orElse(null);
    }

    public AgriRequirement getGrowthRequirements() {
        return this.requirement;
    }

    public void getAllPossibleProducts(Consumer<ItemStack> products) {
        this.products.forEach(product -> Platform.get().getItemsFromLocation(product.item()).forEach(item -> {
            ItemStack itemStack = new ItemStack((ItemLike)item, product.min());
            if (!product.nbt().m_128456_()) {
                itemStack.m_41784_().m_128391_(product.nbt());
            }
            products.accept(itemStack);
        }));
    }

    public void getHarvestProducts(Consumer<ItemStack> products, AgriGrowthStage growthStage, AgriGenome genome, RandomSource random) {
        if (growthStage.isMature()) {
            this.products.stream().filter(product -> product.shouldDrop(random)).forEach(product -> {
                List<Item> possible = Platform.get().getItemsFromLocation(product.item());
                Item item = possible.get(random.m_188503_(possible.size()));
                ItemStack itemStack = new ItemStack((ItemLike)item, product.getAmount(random));
                if (!product.nbt().m_128456_()) {
                    itemStack.m_41784_().m_128391_(product.nbt());
                }
                products.accept(itemStack);
            });
        }
    }

    public void getAllPossibleClipProducts(Consumer<ItemStack> products) {
        this.clipProducts.forEach(product -> Platform.get().getItemsFromLocation(product.item()).forEach(item -> products.accept(new ItemStack((ItemLike)item))));
    }

    public void getClipProducts(Consumer<ItemStack> products, ItemStack clipper, AgriGrowthStage growthStage, AgriGenome genome, RandomSource random) {
        if (growthStage.isMature()) {
            this.clipProducts.stream().filter(product -> product.shouldDrop(random)).forEach(product -> {
                List<Item> possible = Platform.get().getItemsFromLocation(product.item());
                Item item = possible.get(random.m_188503_(possible.size()));
                ItemStack itemStack = new ItemStack((ItemLike)item, product.getAmount(random));
                if (!product.nbt().m_128456_()) {
                    itemStack.m_41784_().m_128391_(product.nbt());
                }
                products.accept(itemStack);
            });
        }
    }

    public boolean allowsCloning(AgriGrowthStage growthStage) {
        return this.cloneable;
    }

    public boolean isFireproof() {
        return this.fireproof;
    }

    public void spawnParticles(AgriCrop crop, RandomSource random) {
        AgriGrowthStage stage = crop.getGrowthStage();
        Level world = crop.m_58904_();
        if (stage.index() == -1 || world == null) {
            return;
        }
        this.particleEffects.stream().filter(effect -> effect.allowParticles(stage.index())).forEach(effect -> {
            ParticleType<?> particle = Platform.get().getParticleType(new ResourceLocation(effect.particle()));
            if (!(particle instanceof ParticleOptions)) {
                return;
            }
            for (int amount = 0; amount < 3; ++amount) {
                if (!(random.m_188500_() < effect.probability())) continue;
                BlockPos pos = crop.m_58899_();
                double x = (double)pos.m_123341_() + 0.5 + (double)(random.m_188499_() ? 1 : -1) * effect.deltaX() * random.m_188500_();
                double y = (double)pos.m_123342_() + 0.5 + effect.deltaY() * random.m_188500_();
                double z = (double)pos.m_123343_() + 0.5 + (double)(random.m_188499_() ? 1 : -1) * effect.deltaZ() * random.m_188500_();
                world.m_7106_((ParticleOptions)particle, x, y, z, 0.0, 0.0, 0.0);
            }
        });
    }

    public boolean allowHarvest(AgriGrowthStage growthStage, @Nullable LivingEntity entity) {
        return growthStage.isMature();
    }

    public boolean allowsClipping(AgriGrowthStage growthStage, ItemStack clipper, @Nullable LivingEntity entity) {
        return growthStage.isMature();
    }

    public Stream<IAgriPlantModifier> getModifiers() {
        if (this.modifiers == null) {
            this.modifiers = new ArrayList<IAgriPlantModifier>();
            this.modifierInfos.stream().map(AgriPlantModifierFactoryRegistry::construct).filter(Optional::isPresent).map(Optional::get).forEach(modifier -> this.modifiers.add((IAgriPlantModifier)modifier));
        }
        return this.modifiers.stream();
    }

    public int getBrightness(AgriCrop crop) {
        return this.getModifiers().mapToInt(modifier -> modifier.getBrightness(crop)).max().orElse(0);
    }

    public int getRedstonePower(AgriCrop crop) {
        return this.getModifiers().mapToInt(modifier -> modifier.getRedstonePower(crop)).max().orElse(0);
    }

    public void onPlanted(AgriCrop crop, @Nullable LivingEntity entity) {
        this.getModifiers().forEach(modifier -> modifier.onPlanted(crop, entity));
    }

    public void onSpawned(AgriCrop crop) {
        this.getModifiers().forEach(modifier -> modifier.onSpawned(crop));
    }

    public void onRandomTick(AgriCrop crop, RandomSource random) {
        this.getModifiers().forEach(modifier -> modifier.onRandomTick(crop, random));
    }

    public void onGrowth(AgriCrop crop) {
        this.getModifiers().forEach(modifier -> modifier.onGrowth(crop));
    }

    public void onRemoved(AgriCrop crop) {
        this.getModifiers().forEach(modifier -> modifier.onRemoved(crop));
    }

    public void onHarvest(AgriCrop crop, @Nullable LivingEntity entity) {
        this.getModifiers().forEach(modifier -> modifier.onHarvest(crop, entity));
    }

    public void onClipped(AgriCrop crop, ItemStack clipper, @Nullable LivingEntity entity) {
        this.getModifiers().forEach(modifier -> modifier.onClipped(crop, clipper, entity));
    }

    public void onFertilized(AgriCrop crop, ItemStack fertilizer, RandomSource random) {
        this.getModifiers().forEach(modifier -> modifier.onFertilized(crop, fertilizer, random));
    }

    public void onBroken(AgriCrop crop, @Nullable LivingEntity entity) {
        this.getModifiers().forEach(modifier -> modifier.onBroken(crop, entity));
    }

    public void onEntityCollision(AgriCrop crop, Entity entity) {
        this.getModifiers().forEach(modifier -> modifier.onEntityCollision(crop, entity));
    }

    public Optional<InteractionResult> onRightClickPre(AgriCrop crop, ItemStack stack, @Nullable Entity entity) {
        return this.getModifiers().map(modifier -> modifier.onRightClickPre(crop, stack, entity)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public Optional<InteractionResult> onRightClickPost(AgriCrop crop, ItemStack stack, @Nullable Entity entity) {
        return this.getModifiers().map(modifier -> modifier.onRightClickPost(crop, stack, entity)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AgriPlant that = (AgriPlant)obj;
        return Objects.equals(this.mods, that.mods) && Objects.equals(this.seeds, that.seeds) && Objects.equals(this.stages, that.stages) && this.harvestStage == that.harvestStage && Double.doubleToLongBits(this.growthChance) == Double.doubleToLongBits(that.growthChance) && Double.doubleToLongBits(this.growthBonus) == Double.doubleToLongBits(that.growthBonus) && this.cloneable == that.cloneable && this.fireproof == that.fireproof && Double.doubleToLongBits(this.spreadChance) == Double.doubleToLongBits(that.spreadChance) && Objects.equals(this.products, that.products) && Objects.equals(this.clipProducts, that.clipProducts) && Objects.equals(this.requirement, that.requirement) && Objects.equals(this.modifierInfos, that.modifierInfos) && Objects.equals(this.particleEffects, that.particleEffects);
    }

    public int hashCode() {
        return Objects.hash(this.mods, this.seeds, this.stages, this.harvestStage, this.growthChance, this.growthBonus, this.cloneable, this.fireproof, this.spreadChance, this.products, this.clipProducts, this.requirement, this.modifierInfos, this.particleEffects);
    }

    public String toString() {
        return "AgriPlant[mods=" + this.mods + ", seeds=" + this.seeds + ", stages=" + this.stages + ", harvestStage=" + this.harvestStage + ", growthChance=" + this.growthChance + ", growthBonus=" + this.growthBonus + ", cloneable=" + this.cloneable + ", fireproof=" + this.fireproof + ", spreadChance=" + this.spreadChance + ", products=" + this.products + ", clipProducts=" + this.clipProducts + ", requirement=" + this.requirement + ", modifiers=" + this.modifierInfos + ", particleEffects=" + this.particleEffects + "]";
    }

    public static class Builder {
        List<String> mods = new ArrayList<String>();
        List<AgriSeed> seeds = new ArrayList<AgriSeed>();
        List<Integer> stages = new ArrayList<Integer>();
        int harvestStage = 4;
        double growthChance = 0.75;
        double growthBonus = 0.025;
        double spreadChance = 0.1;
        boolean cloneable = true;
        boolean fireproof = false;
        List<AgriProduct> products = new ArrayList<AgriProduct>();
        List<AgriProduct> clipProducts = List.of();
        AgriRequirement requirement = AgriRequirement.NO_REQUIREMENT;
        List<AgriPlantModifierInfo> modifiers = List.of();
        List<AgriParticleEffect> particleEffects = List.of();

        public static Builder from(AgriPlant plant) {
            return new Builder().mods(plant.mods.toArray(new String[0])).seeds(plant.seeds.toArray(new AgriSeed[0])).stages(plant.stages.toArray(new Integer[0])).harvest(plant.harvestStage).chances(plant.growthChance, plant.growthBonus, plant.spreadChance).cloneable(plant.cloneable).fireproof(plant.fireproof).products(plant.products.toArray(new AgriProduct[0])).clips(plant.clipProducts.toArray(new AgriProduct[0])).requirement(plant.requirement).modifiers(plant.modifierInfos.toArray(new AgriPlantModifierInfo[0])).particles(plant.particleEffects.toArray(new AgriParticleEffect[0]));
        }

        public AgriPlant build() {
            return new AgriPlant(this.mods, this.seeds, this.stages, this.harvestStage, this.growthChance, this.growthBonus, this.cloneable, this.fireproof, this.spreadChance, this.products, this.clipProducts, this.requirement, this.modifiers, this.particleEffects);
        }

        public Builder mods(String ... mods) {
            Collections.addAll(this.mods, mods);
            return this;
        }

        public Builder seeds(AgriSeed ... seeds) {
            Collections.addAll(this.seeds, seeds);
            return this;
        }

        public Builder stages(Integer ... stages) {
            Collections.addAll(this.stages, stages);
            return this;
        }

        public Builder stages16() {
            for (int i = 2; i < 17; i += 2) {
                this.stages.add(i);
            }
            return this;
        }

        public Builder harvest(int stage) {
            this.harvestStage = stage;
            return this;
        }

        public Builder chances(double growth, double growthBonus, double spread) {
            this.growthChance = growth;
            this.growthBonus = growthBonus;
            this.spreadChance = spread;
            return this;
        }

        public Builder cloneable(boolean cloneable) {
            this.cloneable = cloneable;
            return this;
        }

        public Builder fireproof(boolean fireproof) {
            this.fireproof = fireproof;
            return this;
        }

        public Builder products(AgriProduct ... products) {
            Collections.addAll(this.products, products);
            return this;
        }

        public Builder clips(AgriProduct ... clips) {
            this.clipProducts = List.of(clips);
            return this;
        }

        public Builder requirement(AgriRequirement requirement) {
            this.requirement = requirement;
            return this;
        }

        public Builder modifiers(AgriPlantModifierInfo ... modifiers) {
            this.modifiers = List.of(modifiers);
            return this;
        }

        public Builder particles(AgriParticleEffect ... particles) {
            this.particleEffects = List.of(particles);
            return this;
        }
    }
}

