/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.client.gui;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.codecs.AgriSoil;
import com.agricraft.agricraft.api.tools.magnifying.MagnifyingInspectable;
import com.agricraft.agricraft.api.tools.magnifying.MagnifyingInspector;
import com.agricraft.agricraft.common.registry.ModItems;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class MagnifyingGlassOverlay {
    private static final List<Predicate<Player>> allowingPredicates = new ArrayList<Predicate<Player>>();
    private static final Set<MagnifyingInspector> inspectors = new HashSet<MagnifyingInspector>();
    private static int hoverTicks;

    public static void addAllowingPredicate(Predicate<Player> predicate) {
        allowingPredicates.add(predicate);
    }

    public static void addInspector(MagnifyingInspector inspector) {
        inspectors.add(inspector);
    }

    public static void renderOverlay(GuiGraphics graphics, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null && !(mc.f_91080_ instanceof ChatScreen) || mc.f_91066_.f_92062_ || mc.f_91072_.m_105295_() == GameType.SPECTATOR || mc.f_91074_ == null || mc.f_91073_ == null) {
            hoverTicks = 0;
            return;
        }
        boolean shouldOverlay = false;
        for (Predicate<Player> predicate : allowingPredicates) {
            if (!predicate.test((Player)mc.f_91074_)) continue;
            shouldOverlay = true;
            break;
        }
        if (!shouldOverlay) {
            hoverTicks = 0;
            return;
        }
        Optional<MagnifyingInspectable> inspectable = MagnifyingGlassOverlay.inspectors.stream().map(inspectors -> inspectors.inspect((Level)mc.f_91073_, (Player)mc.f_91074_, mc.f_91077_)).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (inspectable.isEmpty()) {
            hoverTicks = 0;
            return;
        }
        int posX = graphics.m_280182_() / 2 + 20;
        int posY = graphics.m_280206_() / 2;
        float fade = Mth.m_14036_((float)((float)(++hoverTicks) / 48.0f), (float)0.0f, (float)1.0f);
        posX += (int)(Math.pow(1.0f - fade, 3.0) * 8.0);
        ArrayList<Component> tooltip = new ArrayList<Component>();
        inspectable.get().addMagnifyingTooltip(tooltip, mc.f_91074_.m_6144_());
        if (!tooltip.isEmpty()) {
            int tooltipHeight = 8;
            if (tooltip.size() > 1) {
                tooltipHeight += 2;
                tooltipHeight += (tooltip.size() - 1) * 10;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)Mth.m_14036_((float)((float)hoverTicks / 24.0f), (float)0.0f, (float)0.8f));
            graphics.m_280677_(mc.f_91062_, tooltip, Optional.empty(), posX - 12, posY - tooltipHeight / 2 + 12);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    static {
        MagnifyingGlassOverlay.addAllowingPredicate(player -> player.m_21205_().m_150930_((Item)ModItems.MAGNIFYING_GLASS.get()));
        MagnifyingGlassOverlay.addAllowingPredicate(player -> player.m_21206_().m_150930_((Item)ModItems.MAGNIFYING_GLASS.get()));
        MagnifyingGlassOverlay.addAllowingPredicate(player -> {
            CompoundTag tag = player.m_6844_(EquipmentSlot.HEAD).m_41783_();
            return tag != null && tag.m_128471_("magnifying");
        });
        inspectors.add((level, player, hitResult) -> {
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult result = (BlockHitResult)hitResult;
                BlockEntity patt2302$temp = level.m_7702_(result.m_82425_());
                if (patt2302$temp instanceof MagnifyingInspectable) {
                    MagnifyingInspectable inspectable = (MagnifyingInspectable)patt2302$temp;
                    return Optional.of(inspectable);
                }
                Optional<AgriSoil> soil = AgriApi.getSoil((BlockGetter)level, result.m_82425_(), level.m_9598_());
                if (soil.isPresent()) {
                    return Optional.of((MagnifyingInspectable)soil.get());
                }
            }
            return Optional.empty();
        });
        inspectors.add((level, player, hitResult) -> {
            Vec3 lookAngle = player.m_20154_();
            if (-0.1 <= lookAngle.f_82481_ && lookAngle.f_82481_ <= 0.1) {
                HitResult pick = Minecraft.m_91087_().m_91288_().m_19907_(100.0, 0.0f, false);
                double sunOrientation = level.m_46942_(0.0f);
                double playerOrientation = Math.atan2(lookAngle.f_82479_, lookAngle.f_82480_) / Math.PI / 2.0;
                if (-0.5 < playerOrientation && playerOrientation < 0.0) {
                    playerOrientation = Math.abs(playerOrientation);
                } else if (0.0 < playerOrientation && playerOrientation < 0.5) {
                    playerOrientation = 1.0 - playerOrientation;
                }
                double diff = sunOrientation - playerOrientation;
                if (-0.013 <= diff && diff <= 0.013 && pick.m_6662_() == HitResult.Type.MISS) {
                    return Optional.of((tooltip, isPlayerSneaking) -> tooltip.add(Component.m_237115_((String)"agricraft.tooltip.magnifying.sun")));
                }
            }
            return Optional.empty();
        });
    }
}

