/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.inventory.container;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.common.block.SeedAnalyzerBlock;
import com.agricraft.agricraft.common.block.entity.SeedAnalyzerBlockEntity;
import com.agricraft.agricraft.common.item.AgriSeedItem;
import com.agricraft.agricraft.common.item.JournalItem;
import com.agricraft.agricraft.common.registry.ModMenus;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SeedAnalyzerMenu
extends AbstractContainerMenu {
    private final BlockPos pos;
    private final SeedAnalyzerBlockEntity analyzer;

    public SeedAnalyzerMenu(int id, Inventory playerInventory, Player player, final BlockPos pos) {
        super((MenuType)ModMenus.SEED_ANALYZER_MENU.get(), id);
        this.pos = pos;
        this.analyzer = (SeedAnalyzerBlockEntity)player.m_9236_().m_7702_(pos);
        this.m_38897_(new Slot((Container)this.analyzer.getInventory(), 0, 26, 38){

            public void m_5852_(ItemStack stack) {
                ItemStack agricraftSeed = SeedAnalyzerMenu.this.getAgriCraftEquivalent(stack);
                super.m_5852_(agricraftSeed.m_41619_() ? stack : agricraftSeed);
                if (SeedAnalyzerMenu.this.analyzer.hasJournal() && !agricraftSeed.m_41619_()) {
                    ItemStack journal = SeedAnalyzerMenu.this.analyzer.getJournal();
                    JournalItem.researchPlant(journal, new ResourceLocation(AgriSeedItem.getSpecies(agricraftSeed)));
                }
            }

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof AgriSeedItem || AgriApi.getPlantRegistry().map(registry -> registry.m_123024_().anyMatch(plant -> plant.isSeedItem(stack))).orElse(false) != false;
            }
        });
        this.m_38897_(new Slot((Container)this.analyzer.getInventory(), 1, 26, 71){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof JournalItem;
            }

            public void m_5852_(ItemStack stack) {
                BlockState state = (BlockState)SeedAnalyzerMenu.this.analyzer.m_58900_().m_61124_((Property)SeedAnalyzerBlock.JOURNAL, (Comparable)Boolean.valueOf(true));
                SeedAnalyzerMenu.this.analyzer.m_58904_().m_7731_(pos, state, 3);
                super.m_5852_(stack);
            }

            public void m_142406_(Player player, ItemStack stack) {
                BlockState state = (BlockState)SeedAnalyzerMenu.this.analyzer.m_58900_().m_61124_((Property)SeedAnalyzerBlock.JOURNAL, (Comparable)Boolean.valueOf(false));
                SeedAnalyzerMenu.this.analyzer.m_58904_().m_7731_(pos, state, 3);
                super.m_142406_(player, stack);
            }
        });
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, 9 + 9 * y + x, 13 + 18 * x, 104 + 18 * y));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 13 + 18 * i, 162));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            itemStack = slotStack.m_41777_();
            if (index <= 1 ? !this.m_38903_(slotStack, 2, 38, true) : index <= 38 && (slotStack.m_41720_() instanceof AgriSeedItem ? !this.m_38903_(slotStack, 0, 1, false) : (!this.getAgriCraftEquivalent(slotStack).m_41619_() ? !this.m_38903_(slotStack, 0, 1, false) : slotStack.m_41720_() instanceof JournalItem && !this.m_38903_(slotStack, 1, 2, false)))) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotStack);
        }
        return itemStack;
    }

    public Optional<AgriGenome> getGenomeToRender() {
        ItemStack seed = this.analyzer.getSeed().m_41777_();
        if (seed.m_41619_()) {
            return Optional.empty();
        }
        AgriGenome genome = AgriGenome.fromNBT(seed.m_41783_());
        return Optional.ofNullable(genome);
    }

    public boolean m_6875_(Player player) {
        return player.m_20275_((double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5) < 64.0;
    }

    private ItemStack getAgriCraftEquivalent(ItemStack originalStack) {
        if (originalStack.m_41720_() instanceof AgriSeedItem) {
            return originalStack;
        }
        ItemStack agricraftSeed = AgriApi.getPlantRegistry().flatMap(registry -> registry.m_123024_().filter(plant -> plant.isSeedItem(originalStack)).findFirst()).map(AgriSeedItem::toStack).orElse(ItemStack.f_41583_);
        if (!agricraftSeed.m_41619_()) {
            agricraftSeed.m_41764_(originalStack.m_41613_());
        }
        return agricraftSeed;
    }
}

