/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.plugin;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.config.CompatConfig;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.common.item.AgriSeedItem;
import com.agricraft.agricraft.common.registry.ModBlocks;
import com.agricraft.agricraft.common.registry.ModItems;
import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="agricraft", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class MysticalAgriculturePlugin {
    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        if (ModList.get().isLoaded("mysticalagriculture") && CompatConfig.enableMysticalAgriculture) {
            event.register((stack, tintIndex) -> {
                Crop crop;
                String species = AgriSeedItem.getSpecies(stack);
                if (species != null && !species.equals("agricraft:unknown") && (crop = MysticalAgricultureAPI.getCropRegistry().getCropById(new ResourceLocation(species))) != null && crop.isSeedColored()) {
                    return crop.getSeedColor();
                }
                return -1;
            }, new ItemLike[]{(ItemLike)ModItems.SEED.get()});
        }
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        if (ModList.get().isLoaded("mysticalagriculture") && CompatConfig.enableMysticalAgriculture) {
            event.register((state, level, pos, tintIndex) -> {
                Optional<AgriCrop> optional = AgriApi.getCrop((BlockGetter)level, pos);
                if (optional.isPresent() && optional.get().hasPlant()) {
                    String species = optional.get().getGenome().getSpeciesGene().getTrait();
                    Crop crop = MysticalAgricultureAPI.getCropRegistry().getCropById(new ResourceLocation(species));
                    if (crop != null && crop.isFlowerColored()) {
                        return crop.getFlowerColor();
                    }
                }
                return -1;
            }, new Block[]{(Block)ModBlocks.CROP.get()});
        }
    }
}

