/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.util.forge;

import com.agricraft.agricraft.AgriCraft;
import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.common.block.entity.CropBlockEntity;
import com.agricraft.agricraft.common.forge.block.entity.ForgeCropBlockEntity;
import com.agricraft.agricraft.common.item.AgriSeedItem;
import com.agricraft.agricraft.common.item.forge.ForgeAgriSeedItem;
import com.agricraft.agricraft.common.registry.ModCreativeTabs;
import com.agricraft.agricraft.common.registry.ModItems;
import com.agricraft.agricraft.common.util.ExtraDataMenuProvider;
import com.agricraft.agricraft.common.util.Platform;
import com.agricraft.agricraft.common.util.PlatformRegistry;
import com.agricraft.agricraft.common.util.forge.ForgeRegistry;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ForgePlatform
extends Platform {
    @Override
    public <T> PlatformRegistry<T> createRegistry(Registry<T> registry, String modid) {
        return new ForgeRegistry<T>(registry, modid);
    }

    @Override
    public AgriSeedItem createAgriSeedItem(Item.Properties properties) {
        return new ForgeAgriSeedItem(properties);
    }

    @Override
    public CropBlockEntity createCropBlockEntity(BlockPos pos, BlockState state) {
        return new ForgeCropBlockEntity(pos, state);
    }

    @Override
    public CreativeModeTab createMainCreativeTab() {
        return CreativeModeTab.builder().m_257737_(() -> new ItemStack((ItemLike)ModItems.DEBUGGER.get())).m_257941_((Component)Component.m_237115_((String)"itemGroup.agricraft.main")).m_257501_(ModItems::addItemsToTabs).m_257652_();
    }

    @Override
    public CreativeModeTab createSeedsCreativeTab() {
        return CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.agricraft.seeds")).m_257737_(() -> new ItemStack((ItemLike)Items.f_42404_)).m_257501_((itemDisplayParameters, output) -> AgriApi.getPlantRegistry().ifPresent(registry -> {
            AgriCraft.LOGGER.info("add seeds in tab: " + registry.m_123024_().count());
            for (Map.Entry entry : registry.m_6579_().stream().sorted(Map.Entry.comparingByKey()).toList()) {
                output.m_246342_(AgriSeedItem.toStack((AgriPlant)entry.getValue()));
            }
        })).withTabsBefore(new ResourceLocation[]{ModCreativeTabs.MAIN_TAB.id()}).m_257652_();
    }

    @Override
    public Optional<RegistryAccess> getRegistryAccess() {
        if (FMLLoader.getDist().isClient()) {
            if (Minecraft.m_91087_().f_91073_ != null) {
                return Optional.of(Minecraft.m_91087_().f_91073_.m_9598_());
            }
        } else if (ServerLifecycleHooks.getCurrentServer() != null) {
            return Optional.of(ServerLifecycleHooks.getCurrentServer().m_206579_());
        }
        return Optional.empty();
    }

    @Override
    public List<Item> getItemsFromLocation(ExtraCodecs.TagOrElementLocation tag) {
        if (!tag.f_216196_()) {
            return List.of((Item)ForgeRegistries.ITEMS.getValue(tag.f_216195_()));
        }
        return ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)tag.f_216195_())).stream().toList();
    }

    @Override
    public List<Block> getBlocksFromLocation(ExtraCodecs.TagOrElementLocation tag) {
        if (!tag.f_216196_()) {
            return List.of((Block)ForgeRegistries.BLOCKS.getValue(tag.f_216195_()));
        }
        return ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)tag.f_216195_())).stream().toList();
    }

    @Override
    public List<Fluid> getFluidsFromLocation(ExtraCodecs.TagOrElementLocation tag) {
        if (!tag.f_216196_()) {
            return List.of((Fluid)ForgeRegistries.FLUIDS.getValue(tag.f_216195_()));
        }
        return ForgeRegistries.FLUIDS.tags().getTag(FluidTags.create((ResourceLocation)tag.f_216195_())).stream().toList();
    }

    @Override
    public <T extends AbstractContainerMenu> MenuType<T> createMenuType(Platform.MenuFactory<T> factory) {
        return IForgeMenuType.create(factory::create);
    }

    @Override
    public void openMenu(ServerPlayer player, ExtraDataMenuProvider provider) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider, buf -> provider.writeExtraData(player, (FriendlyByteBuf)buf));
    }

    @Override
    public ParticleType<?> getParticleType(ResourceLocation particleId) {
        return (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(particleId);
    }
}

