/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.forge;

import com.agricraft.agricraft.AgriCraft;
import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.codecs.AgriMutation;
import com.agricraft.agricraft.api.codecs.AgriSoil;
import com.agricraft.agricraft.api.config.CompatConfig;
import com.agricraft.agricraft.api.config.CoreConfig;
import com.agricraft.agricraft.api.fertilizer.AgriFertilizer;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.api.plant.AgriWeed;
import com.agricraft.agricraft.common.commands.DumpRegistriesCommand;
import com.agricraft.agricraft.common.commands.GiveSeedCommand;
import com.agricraft.agricraft.common.handler.DenyBonemeal;
import com.agricraft.agricraft.common.handler.VanillaSeedConversion;
import com.agricraft.agricraft.common.util.Platform;
import com.agricraft.agricraft.common.util.forge.ForgePlatform;
import com.agricraft.agricraft.compat.botania.BotaniaPlugin;
import com.agricraft.agricraft.compat.botania.ManaGrowthCondition;
import com.agricraft.agricraft.plugin.minecraft.MinecraftPlugin;
import com.mojang.brigadier.CommandDispatcher;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.InteractionResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.DataPackRegistryEvent;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaNetworkAction;

@Mod(value="agricraft")
public class AgriCraftForge {
    public AgriCraftForge() {
        Platform.setup(new ForgePlatform());
        AgriCraft.init();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(AgriCraftForge::onCommonSetup);
        bus.addListener(AgriCraftForge::onRegisterDatapackRegistry);
        bus.addListener(AgriCraftForge::onAddPackFinders);
        MinecraftForge.EVENT_BUS.addListener(AgriCraftForge::onRegisterCommands);
        MinecraftForge.EVENT_BUS.addListener(AgriCraftForge::onRightClick);
        MinecraftForge.EVENT_BUS.addListener(AgriCraftForge::onRightClickBonemeal);
    }

    public static void onCommonSetup(FMLCommonSetupEvent event) {
        MinecraftPlugin.init();
        if (ModList.get().isLoaded("botania") && CompatConfig.enableBotania) {
            BotaniaPlugin.init();
            MinecraftForge.EVENT_BUS.addListener(e -> {
                if (e.getAction() == ManaNetworkAction.REMOVE && e.getType() == ManaBlockType.POOL) {
                    ManaGrowthCondition.removePoll(e.getReceiver());
                }
            });
        }
    }

    public static void onRegisterDatapackRegistry(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(AgriApi.AGRIPLANTS, AgriPlant.CODEC, AgriPlant.CODEC);
        event.dataPackRegistry(AgriApi.AGRIWEEDS, AgriWeed.CODEC, AgriWeed.CODEC);
        event.dataPackRegistry(AgriApi.AGRISOILS, AgriSoil.CODEC, AgriSoil.CODEC);
        event.dataPackRegistry(AgriApi.AGRIMUTATIONS, AgriMutation.CODEC, AgriMutation.CODEC);
        event.dataPackRegistry(AgriApi.AGRIFERTILIZERS, AgriFertilizer.CODEC, AgriFertilizer.CODEC);
    }

    public static void onRegisterCommands(RegisterCommandsEvent event) {
        GiveSeedCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
        DumpRegistriesCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult result = VanillaSeedConversion.onRightClick(event.getEntity(), event.getHand(), event.getPos(), event.getHitVec());
        if (result != InteractionResult.PASS) {
            event.setUseItem(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    public static void onRightClickBonemeal(PlayerInteractEvent.RightClickBlock event) {
        if (DenyBonemeal.denyBonemeal(event.getEntity(), event.getHand(), event.getPos(), event.getLevel())) {
            event.setUseItem(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    public static void onAddPackFinders(AddPackFindersEvent event) {
        String modId;
        if (event.getPackType() == PackType.SERVER_DATA) {
            for (IModInfo mod : ModList.get().getMods()) {
                modId = mod.getModId();
                if (modId.equals("minecraft") || modId.equals("agricraft")) continue;
                AgriCraftForge.addPack("datapacks", modId, PackType.SERVER_DATA, event);
            }
        }
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            for (IModInfo mod : ModList.get().getMods()) {
                modId = mod.getModId();
                if (modId.equals("minecraft") || modId.equals("agricraft")) continue;
                AgriCraftForge.addPack("resourcepacks", modId, PackType.CLIENT_RESOURCES, event);
            }
        }
    }

    public static void addPack(String type, String modid, PackType packType, AddPackFindersEvent event) {
        Path resourcePath = ModList.get().getModFileById("agricraft").getFile().findResource(new String[]{type, modid});
        if (!Files.exists(resourcePath, new LinkOption[0])) {
            return;
        }
        String id = "builtin/agricraft_" + type + "_" + modid;
        Function<String, PackResources> onName = path -> new PathPackResources(path, resourcePath, true);
        Pack.ResourcesSupplier resources = string -> (PackResources)onName.apply(id);
        try (PackResources packresources = resources.m_247679_(id);){
            PackMetadataSection packmetadatasection = (PackMetadataSection)packresources.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_243696_);
            if (packmetadatasection == null) {
                return;
            }
        }
        catch (IOException ignored) {
            return;
        }
        Pack pack = Pack.m_245429_((String)id, (Component)Component.m_237115_((String)("agricraft." + type + "." + modid)), (boolean)CoreConfig.enablePacksByDefault, (Pack.ResourcesSupplier)resources, (PackType)packType, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
        if (pack != null) {
            event.addRepositorySource(packConsumer -> packConsumer.accept(pack));
        }
    }
}

