/*
 * Decompiled with CFR 0.152.
 */
package com.msg.end_less.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class NewEndPlatform
extends Feature<NoneFeatureConfiguration> {
    public NewEndPlatform(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        NewEndPlatform.createPlatform((ServerLevelAccessor)context.level(), context.origin());
        return true;
    }

    public static void createPlatform(ServerLevelAccessor level, BlockPos pos) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        for (int i = 1; i < 10; ++i) {
            for (int j = -2; j < 3; ++j) {
                for (int k = -2; k < 3; ++k) {
                    BlockPos.MutableBlockPos blockPos = mutableBlockPos.set((Vec3i)pos).move(j, i, k);
                    NewEndPlatform.placeBlock(level, (BlockPos)blockPos, (i == 6 ? Blocks.OBSIDIAN : Blocks.AIR).defaultBlockState());
                }
            }
        }
        NewEndPlatform.placePortal((ServerLevel)level, pos);
    }

    public static void placePortal(ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                BlockState state;
                BlockPos.MutableBlockPos blockPos = mutableBlockPos.set((Vec3i)pos).move(j, 0, i);
                if (Math.abs(i) == 2 && Math.abs(j) == 2) {
                    state = Blocks.AIR.defaultBlockState();
                } else {
                    state = (BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue((Property)EndPortalFrameBlock.HAS_EYE, (Comparable)Boolean.valueOf(true));
                    state = i == 2 ? (BlockState)state.setValue((Property)EndPortalFrameBlock.FACING, (Comparable)Direction.NORTH) : (i == -2 ? (BlockState)state.setValue((Property)EndPortalFrameBlock.FACING, (Comparable)Direction.SOUTH) : (j == 2 ? (BlockState)state.setValue((Property)EndPortalFrameBlock.FACING, (Comparable)Direction.WEST) : (j == -2 ? (BlockState)state.setValue((Property)EndPortalFrameBlock.FACING, (Comparable)Direction.EAST) : Blocks.END_PORTAL.defaultBlockState())));
                }
                NewEndPlatform.placeBlock((ServerLevelAccessor)level, (BlockPos)blockPos, state);
            }
        }
    }

    private static void placeBlock(ServerLevelAccessor level, BlockPos blockPos, BlockState blockState) {
        if (!level.getBlockState(blockPos).is(blockState.getBlock())) {
            level.setBlock(blockPos, blockState, 3);
        }
    }
}

