/*
 * Decompiled with CFR 0.152.
 */
package com.msg.end_less.mixin;

import com.msg.end_less.EndLessConstants;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EndDragonFight.class})
public class DragonFightMixin {
    @Shadow
    public boolean previouslyKilled;
    @Shadow
    private ServerLevel level;

    @Inject(method={"Lnet/minecraft/world/level/dimension/end/EndDragonFight;setDragonKilled(Lnet/minecraft/world/entity/boss/enderdragon/EnderDragon;)V"}, at={@At(value="HEAD")})
    private void firstDragonKilled(EnderDragon enderDragon, CallbackInfo ci) {
        if (!this.previouslyKilled) {
            EndLessConstants.LOG.info("Trying to spawn the portal");
            DragonFightMixin.place_portal(this.level.getServer().getLevel(Level.OVERWORLD));
        }
    }

    private static void place_portal(ServerLevel level) {
        StructureTemplateManager structureTemplateManager = level.getStructureManager();
        ResourceLocation portal = ResourceLocation.fromNamespaceAndPath((String)"msg", (String)"island_portal");
        Optional optional = null;
        try {
            optional = structureTemplateManager.get(portal);
        }
        catch (ResourceLocationException var13) {
            EndLessConstants.LOG.info("Cannot spawn island portal.");
        }
        if (optional.isEmpty()) {
            EndLessConstants.LOG.info("Cannot find island portal to spawn.");
        } else {
            StructureTemplate structureTemplate = (StructureTemplate)optional.get();
            structureTemplate.placeInWorld((ServerLevelAccessor)level, new BlockPos(-structureTemplate.getSize().getX() / 2 + 1, 300, -structureTemplate.getSize().getZ() / 2), new BlockPos(0, 300, 0), new StructurePlaceSettings(), StructureBlockEntity.createRandom((long)0L), 2);
        }
    }
}

