/*
 * Decompiled with CFR 0.152.
 */
package com.msg.end_less.mixin;

import com.msg.end_less.features.EndLessSaveAndLoader;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.EnderEyeItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnderEyeItem.class})
public class EnderEyeItemMixin {
    @Inject(method={"useOn"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;globalLevelEvent(ILnet/minecraft/core/BlockPos;I)V")})
    private void onEndPortalBlockPlaced(UseOnContext context, CallbackInfoReturnable<InteractionResult> cir) {
        Level world = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        EndLessSaveAndLoader openPortals = EndLessSaveAndLoader.getServerState(world.getServer());
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                BlockPos checkAtPos;
                if (i > -2 && i < 2 && j > -2 && j < 2 || i == j && Math.abs(i) == 2 || !EnderEyeItemMixin.checkSquare(world, checkAtPos = blockPos.offset(i, 0, j))) continue;
                openPortals.openEndPortal.add(checkAtPos);
                return;
            }
        }
    }

    private static boolean checkSquare(Level world, BlockPos blockPos) {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                if (world.getBlockState(blockPos.offset(i, 0, j)).is(Blocks.END_PORTAL)) continue;
                return false;
            }
        }
        return true;
    }
}

