package com.fireIron24.crafter10.mixin;

import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_8886;
import net.minecraft.class_8887;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;


@Mixin(class_8886.class)
public class CrafterBlockMixin {
    /**
     * Overwrite the getAnalogOutputSignal method to change its behavior.
     * @author FireIro24
     * @reason to get to getRedstoneSignal with blockEntity reference
     * @param blockState The block state.
     * @param level The level.
     * @param blockPos The block position.
     * @param direction The direction
     * @return The new analog output signal.
     */
    @Overwrite
    public int  getAnalogOutputSignal(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2350 direction) {
        class_2586 blockEntity = level.method_8321(blockPos);
        if (blockEntity instanceof class_8887) {
            return (getRedstoneSignal((class_8887) blockEntity));
        } else {
            return 0;
        }
    }

    @Unique
    public int getRedstoneSignal(class_8887 blockentity) {
        int i = 0;
        short extra = 0;
        boolean fillableSlot = false;
        for(int j = 0; j < blockentity.method_5439(); ++j) {
            class_1799 itemStack = blockentity.method_5438(j);
            if (blockentity.method_54483(j)) {
                ++i;
                ++extra;
            } else if (!itemStack.method_7960()) {
                fillableSlot=true;
                if (itemStack.method_7914()==1) {
                    ++i;
                    ++extra;
                } else {
                    ++i;
                    if (itemStack.method_7947() >1) {
                        ++extra;
                    }
                }
            }
        }

        return (extra == 9 && fillableSlot) ? (i + 1) : i;
    }








}
