/*
 * Decompiled with CFR 0.152.
 */
package Kyo.autofish.scheduler;

import Kyo.autofish.FabricModAutofish;
import Kyo.autofish.scheduler.Action;
import Kyo.autofish.scheduler.ActionType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;

public class AutofishScheduler {
    private FabricModAutofish modAutofish;
    private List<Action> queuedActions = new ArrayList<Action>();
    private List<Action> repeatingActions = new ArrayList<Action>();
    private boolean doesWorldExist;

    public AutofishScheduler(FabricModAutofish modAutofish) {
        this.modAutofish = modAutofish;
    }

    public void tick(class_310 client) {
        if (client.field_1687 == null == this.doesWorldExist) {
            this.doesWorldExist = client.field_1687 != null;
            this.repeatingActions.forEach(Action::resetTimer);
        }
        if (!this.modAutofish.getConfig().isAutofishEnabled()) {
            this.queuedActions.clear();
        }
        if (client.field_1687 == null || client.field_1724 == null) {
            this.queuedActions.clear();
            return;
        }
        this.queuedActions.removeIf(Action::tick);
        this.repeatingActions.forEach(Action::tick);
    }

    public void scheduleAction(ActionType actionType, long delay, Runnable runnable) {
        this.queuedActions.add(new Action(actionType, delay, runnable));
    }

    public void scheduleAction(Action action) {
        this.queuedActions.add(action);
    }

    public void scheduleRepeatingAction(long interval, Runnable runnable) {
        this.repeatingActions.add(new Action(ActionType.REPEATING_ACTION, interval, runnable));
    }

    public boolean isRecastQueued() {
        return this.queuedActions.stream().anyMatch(action -> action.getActionType() == ActionType.RECAST);
    }
}

