/*
 * Decompiled with CFR 0.152.
 */
package com.yshs.searchonmcmod;

import com.yshs.searchonmcmod.KeyBindings;
import com.yshs.searchonmcmod.MainUtil;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchOnMcmod
implements ModInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchOnMcmod.class);
    public static boolean keyDown = false;

    public void onInitialize() {
        KeyBindingHelper.registerKeyBinding((class_304)KeyBindings.SEARCH_ON_MCMOD_KEY);
        ItemTooltipCallback.EVENT.register(this::onRenderTooltipEvent);
    }

    public void onRenderTooltipEvent(class_1799 itemStack, class_1792.class_9635 tooltipContext, class_1836 tooltipFlag, List<class_2561> componentList) {
        if (!keyDown) {
            return;
        }
        keyDown = false;
        String descriptionId = itemStack.method_7909().method_7876();
        if (StringUtils.isBlank((CharSequence)descriptionId)) {
            return;
        }
        String registryName = MainUtil.convertDescriptionIdToRegistryName(descriptionId);
        if ("minecraft:air".equals(registryName)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)registryName) && StringUtils.isNotBlank((CharSequence)descriptionId)) {
            MainUtil.openSearchPage(descriptionId);
            return;
        }
        String localizedName = itemStack.method_7964().getString();
        CompletableFuture.runAsync(() -> {
            Optional<String> optionalItemMCMODID;
            try {
                optionalItemMCMODID = MainUtil.fetchItemMCMODID(registryName);
            }
            catch (Exception e) {
                log.error("MC\u767e\u79d1\u641c\u7d22: \u65e0\u6cd5\u901a\u8fc7\u767e\u79d1 API \u83b7\u53d6\u7269\u54c1 MCMOD ID\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u7f51\u7edc\u60c5\u51b5", (Throwable)e);
                class_746 player = class_310.method_1551().field_1724;
                if (player != null) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"text.searchonmcmod.mcmodid_not_found"));
                }
                return;
            }
            if (!optionalItemMCMODID.isPresent()) {
                return;
            }
            String itemMCMODID = optionalItemMCMODID.get();
            if ("0".equals(itemMCMODID)) {
                MainUtil.openSearchPage(localizedName);
                return;
            }
            if (!MainUtil.itemPageExist(itemMCMODID)) {
                MainUtil.openSearchPage(localizedName);
                return;
            }
            MainUtil.openItemPage(itemMCMODID);
        });
    }
}

