/*
 * Decompiled with CFR 0.152.
 */
package com.yshs.searchonmcmod;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MainUtil.class);
    private static final String SEARCH_PAGE_URL = "https://search.mcmod.cn/s?key=%s";
    private static final String ITEM_PAGE_URL = "https://www.mcmod.cn/item/%s.html";
    private static final String FETCH_ITEM_ID_URL = "https://api.mcmod.cn/getItem/?regname=%s";

    public static void openSearchPage(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String encode = URLEncoder.encode(name, "UTF-8");
        String url = String.format(SEARCH_PAGE_URL, encode);
        log.info("\u6253\u5f00MC\u767e\u79d1\u641c\u7d22\u9875\u9762: {}", (Object)url);
        Util.getPlatform().openUri(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean itemPageExist(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        String urlStr = String.format(ITEM_PAGE_URL, id);
        log.info("\u68c0\u67e5MC\u767e\u79d1\u7269\u54c1\u9875\u9762\u662f\u5426\u5b58\u5728: {}", (Object)urlStr);
        URL url = new URL(urlStr);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        try {
            boolean bl = connection.getResponseCode() == 200;
            connection.disconnect();
            return bl;
        }
        catch (Throwable throwable) {
            connection.disconnect();
            throw throwable;
        }
    }

    public static void openItemPage(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        String url = String.format(ITEM_PAGE_URL, id);
        log.info("\u6253\u5f00MC\u767e\u79d1\u7269\u54c1\u9875\u9762: {}", (Object)url);
        Util.getPlatform().openUri(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static Optional<String> fetchItemMCMODID(@NonNull String registryName) {
        if (registryName == null) {
            throw new NullPointerException("registryName is marked non-null but is null");
        }
        String urlStr = String.format(FETCH_ITEM_ID_URL, registryName);
        log.info("\u901a\u8fc7\u767e\u79d1API\u83b7\u53d6\u7269\u54c1 ID: {}", (Object)urlStr);
        URL url = new URL(urlStr);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        try {
            Optional<String> optional;
            block12: {
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) {
                    log.error("\u83b7\u53d6\u7269\u54c1 ID \u5931\u8d25: {}", (Object)responseCode);
                    Optional<String> optional2 = Optional.empty();
                    return optional2;
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                try {
                    String mcmodItemID = in.readLine();
                    log.info("\u83b7\u53d6\u7269\u54c1 MCMOD ID \u6210\u529f: {}", (Object)mcmodItemID);
                    optional = Optional.of(mcmodItemID);
                    if (Collections.singletonList(in).get(0) == null) break block12;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(in).get(0) != null) {
                        in.close();
                    }
                    throw throwable;
                }
                in.close();
            }
            return optional;
        }
        finally {
            connection.disconnect();
        }
    }

    public static String convertDescriptionIdToRegistryName(@NonNull String descriptionId) {
        if (descriptionId == null) {
            throw new NullPointerException("descriptionId is marked non-null but is null");
        }
        String[] parts = descriptionId.split("\\.");
        if (parts.length >= 2) {
            return parts[1] + ":" + parts[2];
        }
        return "";
    }
}

