/*
 * Decompiled with CFR 0.152.
 */
package com.yshs.searchonmcmod;

import com.mojang.blaze3d.platform.InputConstants;
import com.yshs.searchonmcmod.KeyBindings;
import com.yshs.searchonmcmod.MainUtil;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="searchonmcmod")
public class SearchOnMcmod {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchOnMcmod.class);
    public static final String MOD_ID = "searchonmcmod";
    private final AtomicBoolean allowOpenUrl = new AtomicBoolean(false);
    private final AtomicBoolean keyPressedFlag = new AtomicBoolean(false);

    public SearchOnMcmod() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRenderTooltipEvent(ItemTooltipEvent event) {
        if (!this.allowOpenUrl.getAndSet(false)) {
            return;
        }
        log.info("allowOpenUrl\u8bbe\u7f6e\u4e3afalse");
        String descriptionId = event.getItemStack().getItem().getDescriptionId();
        if (StringUtils.isBlank((CharSequence)descriptionId)) {
            return;
        }
        String registryName = MainUtil.convertDescriptionIdToRegistryName(descriptionId);
        if ("minecraft:air".equals(registryName)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)registryName) && StringUtils.isNotBlank((CharSequence)descriptionId)) {
            MainUtil.openSearchPage(descriptionId);
            return;
        }
        String localizedName = event.getItemStack().getHoverName().getString();
        CompletableFuture.runAsync(() -> {
            Optional<String> optionalItemMCMODID;
            try {
                optionalItemMCMODID = MainUtil.fetchItemMCMODID(registryName);
            }
            catch (Exception e) {
                log.error("MC\u767e\u79d1\u641c\u7d22: \u65e0\u6cd5\u901a\u8fc7\u767e\u79d1 API \u83b7\u53d6\u7269\u54c1 MCMOD ID\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u7f51\u7edc\u60c5\u51b5", (Throwable)e);
                LocalPlayer player = Minecraft.getInstance().player;
                if (player != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"text.searchonmcmod.mcmodid_not_found"), false);
                }
                return;
            }
            if (!optionalItemMCMODID.isPresent()) {
                return;
            }
            String itemMCMODID = optionalItemMCMODID.get();
            if ("0".equals(itemMCMODID)) {
                MainUtil.openSearchPage(localizedName);
                return;
            }
            if (!MainUtil.itemPageExist(itemMCMODID)) {
                MainUtil.openSearchPage(localizedName);
                return;
            }
            MainUtil.openItemPage(itemMCMODID);
        });
    }

    @SubscribeEvent
    public void onKeyPressed(ScreenEvent.KeyPressed.Post event) {
        InputConstants.Key settingsKey;
        int eventKeyCode = event.getKeyCode();
        if (eventKeyCode != (settingsKey = KeyBindings.SEARCH_ON_MCMOD_KEY.getKey()).getValue()) {
            return;
        }
        if (this.keyPressedFlag.get()) {
            return;
        }
        this.keyPressedFlag.set(true);
        this.allowOpenUrl.set(true);
        log.info("SEARCH_ON_MCMOD_KEY\u6309\u952e\u5df2\u6309\u4e0b\uff0ckeyPressedFlag\uff0callowOpenUrl\u8bbe\u7f6e\u4e3atrue");
    }

    @SubscribeEvent
    public void onKeyReleased(ScreenEvent.KeyReleased.Post event) {
        InputConstants.Key settingsKey;
        int eventKeyCode = event.getKeyCode();
        if (eventKeyCode != (settingsKey = KeyBindings.SEARCH_ON_MCMOD_KEY.getKey()).getValue()) {
            return;
        }
        this.keyPressedFlag.set(false);
        log.info("SEARCH_ON_MCMOD_KEY\u6309\u952e\u5df2\u91ca\u653e\uff0ckeyPressedFlag\u8bbe\u7f6e\u4e3afalse");
    }

    @EventBusSubscriber(modid="searchonmcmod", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerBindings(RegisterKeyMappingsEvent event) {
            event.register(KeyBindings.SEARCH_ON_MCMOD_KEY);
        }
    }
}

