/*
 * Decompiled with CFR 0.152.
 */
package com.yshs.searchonmcmod;

import com.mojang.blaze3d.platform.InputConstants;
import com.yshs.searchonmcmod.KeyBindings;
import com.yshs.searchonmcmod.MainUtil;
import java.util.Optional;
import lombok.Generated;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="searchonmcmod")
public class SearchOnMcmod {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchOnMcmod.class);
    public static final String MOD_ID = "searchonmcmod";
    private static boolean keyDown = false;

    public SearchOnMcmod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRenderTooltipEvent(ItemTooltipEvent event) {
        if (!keyDown) {
            return;
        }
        keyDown = false;
        String descriptionId = event.getItemStack().m_41720_().m_5524_();
        if (StringUtils.isBlank((CharSequence)descriptionId)) {
            return;
        }
        String registryName = MainUtil.convertDescriptionIdToRegistryName(descriptionId);
        if ("minecraft:air".equals(registryName)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)registryName) && StringUtils.isNotBlank((CharSequence)descriptionId)) {
            MainUtil.openSearchPage(descriptionId);
            return;
        }
        Optional<String> optionalItemMCMODID = MainUtil.fetchItemMCMODID(registryName);
        if (!optionalItemMCMODID.isPresent()) {
            return;
        }
        String itemMCMODID = optionalItemMCMODID.get();
        if ("0".equals(itemMCMODID)) {
            String localizedName = event.getItemStack().m_41786_().getString();
            MainUtil.openSearchPage(localizedName);
            return;
        }
        MainUtil.openItemPage(itemMCMODID);
    }

    @SubscribeEvent
    public void onKeyPressed(ScreenEvent.KeyPressed.Post event) {
        InputConstants.Key key;
        int keyCode = event.getKeyCode();
        if (keyCode == (key = KeyBindings.SEARCH_ON_MCMOD_KEY.getKey()).m_84873_() && !keyDown) {
            keyDown = true;
            log.info("SEARCH_ON_MCMOD_KEY\u6309\u952e\u5df2\u6309\u4e0b\uff0ckeyDown\u8bbe\u7f6e\u4e3atrue");
        }
    }

    @SubscribeEvent
    public void onKeyReleased(ScreenEvent.KeyReleased.Post event) {
        int keyCode = event.getKeyCode();
        if (keyCode == KeyBindings.SEARCH_ON_MCMOD_KEY.getKey().m_84873_()) {
            keyDown = false;
            log.info("SEARCH_ON_MCMOD_KEY\u6309\u952e\u5df2\u91ca\u653e\uff0ckeyDown\u8bbe\u7f6e\u4e3afalse");
        }
    }

    @Mod.EventBusSubscriber(modid="searchonmcmod", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerBindings(RegisterKeyMappingsEvent event) {
            event.register(KeyBindings.SEARCH_ON_MCMOD_KEY);
        }
    }
}

