/*
 * Decompiled with CFR 0.152.
 */
package com.yshs.searchonmcmod;

import com.yshs.searchonmcmod.KeyBindings;
import com.yshs.searchonmcmod.MainUtil;
import java.util.Optional;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

@Mod(modid="searchonmcmod")
public class SearchOnMcmod {
    public static final String MOD_ID = "searchonmcmod";
    private static final Logger log = LogManager.getLogger();
    private static boolean keyDown = false;

    public SearchOnMcmod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyBindings.SEARCH_ON_MCMOD_KEY);
    }

    @SubscribeEvent
    public void onRenderTooltipEvent(ItemTooltipEvent event) {
        if (!keyDown) {
            return;
        }
        keyDown = false;
        log.info("\u89e6\u53d1\u4e86");
        ResourceLocation registryName = event.getItemStack().func_77973_b().getRegistryName();
        if (registryName == null) {
            MainUtil.openSearchPage(event.getItemStack().func_82833_r());
            return;
        }
        String registryNameStr = registryName.toString();
        if ("minecraft:air".equals(registryNameStr)) {
            return;
        }
        int metadata = event.getItemStack().func_77960_j();
        Optional<String> optionalItemMCMODID = MainUtil.fetchItemMCMODID(registryNameStr, metadata);
        if (!optionalItemMCMODID.isPresent()) {
            return;
        }
        String itemMCMODID = optionalItemMCMODID.get();
        if ("0".equals(itemMCMODID)) {
            String localizedName = event.getItemStack().func_82833_r();
            MainUtil.openSearchPage(localizedName);
            return;
        }
        MainUtil.openItemPage(itemMCMODID);
    }

    @SubscribeEvent
    public void onKeyPressed(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (Keyboard.isKeyDown((int)KeyBindings.SEARCH_ON_MCMOD_KEY.func_151463_i()) && !keyDown) {
            keyDown = true;
            log.info("\u6309\u952e\u5df2\u6309\u4e0b\uff0ckeyDown\u8bbe\u7f6e\u4e3atrue");
        }
    }

    @SubscribeEvent
    public void onKeyReleased(GuiScreenEvent.KeyboardInputEvent.Post event) {
        if (!Keyboard.isKeyDown((int)KeyBindings.SEARCH_ON_MCMOD_KEY.func_151463_i()) && keyDown) {
            keyDown = false;
            log.info("\u6309\u952e\u5df2\u91ca\u653e\uff0ckeyDown\u8bbe\u7f6e\u4e3afalse");
        }
    }
}

