/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.config.api.instance.xjs;

import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.frozenblock.lib.config.api.instance.xjs.XjsUtils;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Nullable;
import net.frozenblock.lib.shadow.personthecat.fresult.Result;
import net.frozenblock.lib.shadow.xjs.data.JsonContainer;
import net.frozenblock.lib.shadow.xjs.data.JsonObject;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.PathFilter;

public class JsonPath
implements Iterable<Either<String, Integer>> {
    private final List<Either<String, Integer>> path;
    private final String raw;

    public JsonPath(List<Either<String, Integer>> path) {
        this.path = path;
        this.raw = JsonPath.serialize(path);
    }

    public JsonPath(List<Either<String, Integer>> path, String raw) {
        this.path = path;
        this.raw = raw;
    }

    public static JsonPathBuilder builder() {
        return new JsonPathBuilder();
    }

    public static Stub stub() {
        return Stub.EMPTY;
    }

    public static JsonPath parse(String raw) throws CommandSyntaxException {
        return JsonPath.parse(new StringReader(raw));
    }

    public static JsonPath parse(StringReader reader) throws CommandSyntaxException {
        ArrayList<Either<String, Integer>> path = new ArrayList<Either<String, Integer>>();
        int begin = reader.getCursor();
        while (reader.canRead() && reader.peek() != ' ') {
            char c = reader.read();
            if (c == '.') {
                JsonPath.checkDot(reader, begin);
                continue;
            }
            if (JsonPath.inKey(c)) {
                path.add((Either<String, Integer>)Either.left((Object)(c + JsonPath.readKey(reader))));
                continue;
            }
            if (c == '[') {
                JsonPath.checkDot(reader, begin);
                path.add((Either<String, Integer>)Either.right((Object)reader.readInt()));
                reader.expect(']');
                continue;
            }
            throw JsonPath.cmdSyntax(reader, "Invalid character");
        }
        return new JsonPath(path, reader.getString().substring(begin, reader.getCursor()));
    }

    private static String readKey(StringReader reader) {
        int start = reader.getCursor();
        while (reader.canRead() && JsonPath.inKey(reader.peek())) {
            reader.skip();
        }
        return reader.getString().substring(start, reader.getCursor());
    }

    private static boolean inKey(char c) {
        return c != '.' && c != ' ' && c != '[';
    }

    private static void checkDot(StringReader reader, int begin) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        char last = reader.getString().charAt(cursor - 2);
        if (cursor - 1 == begin || last == '.') {
            throw JsonPath.cmdSyntax(reader, "Unexpected accessor");
        }
    }

    public static Result<JsonPath, CommandSyntaxException> tryParse(String raw) {
        return Result.of(() -> JsonPath.parse(raw)).ifErr(Result::IGNORE);
    }

    public static JsonPath objectOnly(String raw) {
        ArrayList<Either<String, Integer>> path = new ArrayList<Either<String, Integer>>();
        for (String key : raw.split("\\.")) {
            path.add((Either<String, Integer>)Either.left((Object)key));
        }
        return new JsonPath(path, raw);
    }

    public static String serialize(Collection<Either<String, Integer>> path) {
        StringBuilder sb = new StringBuilder();
        for (Either<String, Integer> either : path) {
            either.ifLeft(s -> {
                sb.append('.');
                sb.append((String)s);
            });
            either.ifRight(i -> {
                sb.append('[');
                sb.append(i);
                sb.append(']');
            });
        }
        String s2 = sb.toString();
        return s2.startsWith(".") ? s2.substring(1) : s2;
    }

    public static List<JsonPath> getAllPaths(JsonObject json) {
        return JsonPath.toPaths(json.getPaths());
    }

    public static List<JsonPath> getUsedPaths(JsonObject json) {
        return JsonPath.toPaths(json.getPaths(PathFilter.USED));
    }

    public static List<JsonPath> getUnusedPaths(JsonObject json) {
        return JsonPath.toPaths(json.getPaths(PathFilter.UNUSED));
    }

    private static List<JsonPath> toPaths(List<String> raw) {
        return raw.stream().map(JsonPath::parseUnchecked).collect(Collectors.toList());
    }

    private static JsonPath parseUnchecked(String path) {
        try {
            return JsonPath.parse(path);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalStateException("JSON lib returned unusable path", e);
        }
    }

    public JsonContainer getLastContainer(JsonObject json) {
        return XjsUtils.getLastContainer(json, this);
    }

    public Optional<JsonValue> getValue(JsonObject json) {
        return XjsUtils.getValueFromPath(json, this);
    }

    public void setValue(JsonObject json, @Nullable JsonValue value) {
        XjsUtils.setValueFromPath(json, this, value);
    }

    public JsonPath getClosestMatch(JsonObject json) {
        return XjsUtils.getClosestMatch(json, this);
    }

    public int getLastAvailable(JsonObject json) {
        return XjsUtils.getLastAvailable(json, this);
    }

    public JsonPathBuilder toBuilder() {
        return new JsonPathBuilder(new ArrayList<Either<String, Integer>>(this.path), new StringBuilder(this.raw));
    }

    public Stub beginTracking() {
        return new Stub(this.raw);
    }

    public Collection<Either<String, Integer>> asCollection() {
        return Collections.unmodifiableCollection(this.path);
    }

    public String asRawPath() {
        return this.raw;
    }

    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    public int size() {
        return this.path.size();
    }

    public Either<String, Integer> get(int index) {
        return this.path.get(index);
    }

    public int indexOf(String key) {
        return this.path.indexOf(Either.left((Object)key));
    }

    public int lastIndexOf(String key) {
        return this.path.lastIndexOf(Either.left((Object)key));
    }

    public List<Either<String, Integer>> subList(int s, int e) {
        return this.path.subList(s, e);
    }

    public JsonPath subPath(String key) {
        int index = this.indexOf(key);
        return index < 0 ? this : this.subPath(index, this.size());
    }

    public JsonPath subPath(int s, int e) {
        return new JsonPath(this.subList(s, e));
    }

    public JsonPath append(JsonPath path) {
        return this.append(path, 0, path.size());
    }

    public JsonPath append(JsonPath path, int startInclusive) {
        return this.append(path, startInclusive, path.size());
    }

    public JsonPath append(JsonPath path, int startInclusive, int endExclusive) {
        return this.toBuilder().append(path, startInclusive, endExclusive).build();
    }

    @Override
    @NotNull
    public Iterator<Either<String, Integer>> iterator() {
        return this.path.iterator();
    }

    public boolean equals(Object o) {
        if (o instanceof JsonPath) {
            return this.path.equals(((JsonPath)o).path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.raw;
    }

    private static CommandSyntaxException cmdSyntax(StringReader reader, String msg) {
        int cursor = reader.getCursor();
        String input = reader.getString().substring(0, cursor);
        LiteralMessage m = new LiteralMessage(msg);
        return new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)m), (Message)m, input, cursor);
    }

    public static class JsonPathBuilder {
        private final List<Either<String, Integer>> path;
        private final StringBuilder raw;

        private JsonPathBuilder() {
            this(new ArrayList<Either<String, Integer>>(), new StringBuilder());
        }

        private JsonPathBuilder(List<Either<String, Integer>> path, StringBuilder raw) {
            this.path = path;
            this.raw = raw;
        }

        public JsonPathBuilder key(String key) {
            this.path.add((Either<String, Integer>)Either.left((Object)key));
            if (this.raw.length() > 0) {
                this.raw.append('.');
            }
            this.raw.append(key);
            return this;
        }

        public JsonPathBuilder index(int index) {
            this.path.add((Either<String, Integer>)Either.right((Object)index));
            this.raw.append('[').append(index).append(']');
            return this;
        }

        public JsonPathBuilder up(int count) {
            JsonPathBuilder builder = this;
            for (int i = 0; i < count; ++i) {
                builder = builder.up();
            }
            return builder;
        }

        public JsonPathBuilder up() {
            if (this.path.isEmpty()) {
                return this;
            }
            if (this.path.size() == 1) {
                return new JsonPathBuilder();
            }
            this.path.remove(this.path.size() - 1);
            int dot = this.raw.lastIndexOf(".");
            int bracket = this.raw.lastIndexOf("[");
            this.raw.delete(Math.max(dot, bracket), this.raw.length());
            return this;
        }

        public JsonPathBuilder append(JsonPath path, int startInclusive, int endExclusive) {
            for (int i = startInclusive; i < endExclusive; ++i) {
                path.get(i).ifLeft(this::key).ifRight(this::index);
            }
            return this;
        }

        public JsonPath build() {
            return new JsonPath(this.path, this.raw.toString());
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof JsonPathBuilder) {
                return this.path.equals(((JsonPathBuilder)o).path);
            }
            return false;
        }
    }

    public static class Stub {
        private static final Stub EMPTY = new Stub("");
        private final String path;

        private Stub(String path) {
            this.path = path;
        }

        public Stub key(String key) {
            if (this.path.isEmpty()) {
                return new Stub(key);
            }
            return new Stub(this.path + "." + key);
        }

        public Stub index(int index) {
            return new Stub(this.path + "[" + index + "]");
        }

        public JsonPath capture() {
            try {
                return JsonPath.parse(this.path);
            }
            catch (CommandSyntaxException e) {
                throw new IllegalArgumentException("Invalid characters in stub: " + this.path);
            }
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Stub) {
                return this.path.equals(((Stub)o).path);
            }
            return false;
        }
    }
}

