/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.personthecat.fresult;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.CheckReturnValue;
import net.frozenblock.lib.shadow.personthecat.fresult.BasicResult;
import net.frozenblock.lib.shadow.personthecat.fresult.PartialOptionalResult;
import net.frozenblock.lib.shadow.personthecat.fresult.PartialResult;
import net.frozenblock.lib.shadow.personthecat.fresult.Protocol;
import net.frozenblock.lib.shadow.personthecat.fresult.Result;
import net.frozenblock.lib.shadow.personthecat.fresult.Shorthand;
import net.frozenblock.lib.shadow.personthecat.fresult.Void;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.OptionalResultFunction;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingFunction;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingRunnable;
import net.frozenblock.lib.shadow.personthecat.fresult.functions.ThrowingSupplier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface OptionalResult<T, E extends Throwable>
extends BasicResult<T, E>,
Serializable {
    public Result<T, E> defaultIfEmpty(Supplier<T> var1);

    public Result<T, E> errIfEmpty(Supplier<E> var1);

    @CheckReturnValue
    public boolean isEmpty();

    public OptionalResult<T, E> ifEmpty(Runnable var1);

    @CheckReturnValue
    public boolean isErr();

    public OptionalResult<T, E> ifErr(Consumer<E> var1);

    @CheckReturnValue
    public boolean isOk();

    public OptionalResult<T, E> ifOk(Consumer<T> var1);

    @CheckReturnValue
    public Optional<T> get();

    @CheckReturnValue
    public Optional<E> getErr();

    @CheckReturnValue
    public T orElse(T var1);

    @CheckReturnValue
    public T orElseGet(Supplier<T> var1);

    @CheckReturnValue
    public PartialResult<T, E> orElseTry(ThrowingSupplier<T, E> var1);

    @CheckReturnValue
    public Result<T, Throwable> orElseTry(Protocol var1, ThrowingSupplier<T, Throwable> var2);

    @CheckReturnValue
    public <M> OptionalResult<M, E> map(Function<T, M> var1);

    @CheckReturnValue
    public <E2 extends Throwable> OptionalResult<T, E2> mapErr(Function<E, E2> var1);

    @CheckReturnValue
    public <M> OptionalResult<M, E> flatMap(OptionalResultFunction<T, M, E> var1);

    @CheckReturnValue
    public <E2 extends Throwable> OptionalResult<T, E2> flatMapErr(OptionalResultFunction<E, T, E2> var1);

    @CheckReturnValue
    public OptionalResult<T, E> filter(Predicate<T> var1);

    @CheckReturnValue
    public OptionalResult<T, E> filter(Predicate<T> var1, Supplier<E> var2);

    @CheckReturnValue
    public OptionalResult<T, E> filterErr(Predicate<E> var1);

    @CheckReturnValue
    public OptionalResult<T, E> filterErr(Predicate<E> var1, Supplier<T> var2);

    @CheckReturnValue
    public <M> OptionalResult<M, E> andThen(Function<T, M> var1);

    @CheckReturnValue
    public <M> PartialOptionalResult<M, E> andThenTry(ThrowingFunction<T, M, E> var1);

    @CheckReturnValue
    public <M> OptionalResult<M, Throwable> andThenSuppress(ThrowingFunction<T, M, Throwable> var1);

    public OptionalResult<Void, E> andThen(Runnable var1);

    @CheckReturnValue
    public PartialOptionalResult<Void, E> andThenTry(ThrowingRunnable<E> var1);

    @CheckReturnValue
    public OptionalResult<Void, Throwable> andThenSuppress(ThrowingRunnable<Throwable> var1);

    @CheckReturnValue
    default public E unwrapErr() {
        return this.expectErr("Attempted to unwrap a result with no error.");
    }

    default public void assertEmpty() {
        this.expectEmpty("Wrapper contains a value or error.");
    }

    public E expectErr(String var1);

    default public E expectErr(String message, Object ... args) {
        return this.expectErr(Shorthand.f(message, args));
    }

    public void expectEmpty(String var1);

    default public void expectEmpty(String message, Object ... args) {
        this.expectEmpty(Shorthand.f(message, args));
    }

    default public T orElseThrow() throws E {
        this.throwIfErr();
        return this.unwrap();
    }

    public void throwIfErr() throws E;
}

