/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Nullable;
import net.frozenblock.lib.shadow.xjs.data.Json;
import net.frozenblock.lib.shadow.xjs.data.JsonContainer;
import net.frozenblock.lib.shadow.xjs.data.JsonReference;
import net.frozenblock.lib.shadow.xjs.data.JsonType;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.PathFilter;

public class JsonArray
extends JsonContainer
implements JsonContainer.View<JsonValue> {
    private ElementView elements;

    public JsonArray() {
    }

    public JsonArray(List<JsonReference> references) {
        super(references);
    }

    public JsonArray set(int index, long value) {
        return this.set(index, Json.value(value));
    }

    public JsonArray set(int index, double value) {
        return this.set(index, Json.value(value));
    }

    public JsonArray set(int index, boolean value) {
        return this.set(index, Json.value(value));
    }

    public JsonArray set(int index, String value) {
        return this.set(index, Json.value(value));
    }

    public JsonArray set(int index, @Nullable JsonValue value) {
        ((JsonReference)this.references.get(index)).apply(og -> Json.nonnull(value).setDefaultMetadata((JsonValue)og));
        return this;
    }

    public JsonArray setReference(int index, JsonReference reference) {
        this.references.set(index, reference);
        return this;
    }

    public JsonArray setComment(int index, String comment) {
        this.get(index).setComment(comment);
        return this;
    }

    public JsonArray add(long value) {
        return this.add(Json.value(value));
    }

    public JsonArray add(double value) {
        return this.add(Json.value(value));
    }

    public JsonArray add(boolean value) {
        return this.add(Json.value(value));
    }

    public JsonArray add(String value) {
        return this.add(Json.value(value));
    }

    public JsonArray add(JsonValue value) {
        return this.addReference(new JsonReference(value));
    }

    public JsonArray add(long value, String comment) {
        return this.add(Json.value(value), comment);
    }

    public JsonArray add(double value, String comment) {
        return this.add(Json.value(value), comment);
    }

    public JsonArray add(boolean value, String comment) {
        return this.add(Json.value(value), comment);
    }

    public JsonArray add(String value, String comment) {
        return this.add(Json.value(value), comment);
    }

    public JsonArray add(JsonValue value, String comment) {
        return this.add(Json.nonnull(value).setComment(comment));
    }

    public JsonArray addAll(JsonContainer container) {
        container.references.forEach(this::addReference);
        return this;
    }

    public JsonArray addReference(JsonReference reference) {
        this.references.add(reference);
        return this;
    }

    public JsonArray insert(int index, JsonValue value) {
        return this.insertReference(index, new JsonReference(value).setAccessed(true));
    }

    public JsonArray insertReference(int index, JsonReference reference) {
        this.references.add(index, reference);
        return this;
    }

    public List<Object> toList() {
        return this.stream().map(JsonValue::unwrap).collect(Collectors.toList());
    }

    public JsonContainer.View<Element> elements() {
        if (this.elements == null) {
            this.elements = new ElementView();
            return this.elements;
        }
        return this.elements;
    }

    @Override
    public JsonArray clear() {
        return (JsonArray)super.clear();
    }

    @Override
    public JsonArray remove(JsonValue value) {
        return (JsonArray)super.remove(value);
    }

    public JsonArray remove(int index) {
        this.references.remove(index);
        return this;
    }

    @Override
    public JsonArray removeAll(Iterable<JsonValue> values) {
        return (JsonArray)super.removeAll(values);
    }

    @Override
    public JsonArray copy(int options) {
        JsonArray copy = new JsonArray(this.copyReferences(options));
        if ((options & 8) == 8) {
            copy.setLinesTrailing(this.linesTrailing);
        }
        return JsonArray.withMetadata(copy, this, options);
    }

    @Override
    public final JsonType getType() {
        return JsonType.ARRAY;
    }

    @Override
    public List<Object> unwrap() {
        return this.toList();
    }

    @Override
    public final boolean isArray() {
        return true;
    }

    @Override
    public JsonArray asArray() {
        return this;
    }

    @Override
    public JsonArray intoArray() {
        return this;
    }

    @Override
    public Iterator<JsonValue> iterator() {
        return this.values().iterator();
    }

    @Override
    public int valueHashCode() {
        int result = 1;
        for (JsonReference reference : this.references) {
            result = 31 * reference.getOnly().valueHashCode();
        }
        return result;
    }

    @Override
    public int hashCode() {
        return 31 * this.metaHashCode() + this.references.hashCode();
    }

    @Override
    public boolean matches(JsonValue other) {
        if (!(other instanceof JsonArray)) {
            return false;
        }
        JsonArray array = (JsonArray)other;
        if (this.size() != array.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (((JsonReference)this.references.get(i)).getOnly().matches(((JsonReference)array.references.get(i)).getOnly())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof JsonArray) {
            return this.references.equals(((JsonArray)o).references);
        }
        return false;
    }

    @Override
    public JsonArray freeze(boolean recursive) {
        return new JsonArray(this.freezeReferences(recursive));
    }

    @Override
    public List<String> getPaths(PathFilter filter) {
        ArrayList<String> paths = new ArrayList<String>();
        for (Element element : this.elements()) {
            if (!filter.test(element.getReference())) continue;
            String key = "[" + element.getIndex() + "]";
            paths.add(key);
            if (!element.getOnly().isContainer()) continue;
            String prefix = element.getOnly().isObject() ? key + "." : key;
            for (String inner : element.getOnly().asContainer().getPaths(filter)) {
                paths.add(prefix + inner);
            }
        }
        return paths;
    }

    private class ElementView
    implements JsonContainer.View<Element> {
        private ElementView() {
        }

        @NotNull
        public ElementIterator iterator() {
            return new ElementIterator();
        }
    }

    public static class Element {
        protected JsonReference reference;
        protected int index;

        public Element(JsonReference reference) {
            this(-1, reference);
        }

        public Element(int index, JsonReference reference) {
            this.reference = reference;
            this.index = index;
        }

        @NotNull
        public JsonValue getValue() {
            return this.reference.get();
        }

        public Element setValue(@Nullable JsonValue value) {
            this.reference.set(value);
            return this;
        }

        @NotNull
        public JsonValue getOnly() {
            return this.reference.getOnly();
        }

        public Element setOnly(@Nullable JsonValue value) {
            this.reference.setOnly(value);
            return this;
        }

        public JsonReference getReference() {
            return this.reference;
        }

        public int getIndex() {
            return this.index;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.index;
            result = 31 * result + this.reference.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (o instanceof Element) {
                Element other = (Element)o;
                return this.index == other.index && this.reference.equals(other.reference);
            }
            return false;
        }

        public String toString() {
            return "([" + this.index + "]=" + this.reference + ")";
        }
    }

    private class ElementIterator
    implements Iterator<Element> {
        final Iterator<JsonReference> references;
        int index;

        private ElementIterator() {
            this.references = JsonArray.this.references.iterator();
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.references.hasNext();
        }

        @Override
        public Element next() {
            JsonReference reference = this.references.next();
            return new Element(this.index++, reference);
        }

        @Override
        public void remove() {
            this.references.remove();
        }
    }
}

