/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Contract;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Nullable;
import net.frozenblock.lib.shadow.xjs.data.Json;
import net.frozenblock.lib.shadow.xjs.data.JsonArray;
import net.frozenblock.lib.shadow.xjs.data.JsonContainer;
import net.frozenblock.lib.shadow.xjs.data.JsonReference;
import net.frozenblock.lib.shadow.xjs.data.JsonType;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.PathFilter;
import net.frozenblock.lib.shadow.xjs.data.serialization.util.HashIndexTable;

public class JsonObject
extends JsonContainer
implements JsonContainer.View<Member> {
    private final List<String> keys;
    private final transient HashIndexTable table;

    public JsonObject() {
        this.keys = new ArrayList<String>();
        this.table = new HashIndexTable();
    }

    protected JsonObject(List<String> keys, List<JsonReference> references) {
        super(references);
        this.keys = keys;
        this.table = new HashIndexTable();
        this.table.init(this.keys);
    }

    public List<String> keys() {
        return Collections.unmodifiableList(this.keys);
    }

    public JsonObject set(String key, long value) {
        return this.set(key, Json.value(value));
    }

    public JsonObject set(String key, double value) {
        return this.set(key, Json.value(value));
    }

    public JsonObject set(String key, boolean value) {
        return this.set(key, Json.value(value));
    }

    public JsonObject set(String key, String value) {
        return this.set(key, Json.value(value));
    }

    public JsonObject set(String key, @Nullable JsonValue value) {
        int index = this.indexOf(key);
        if (index != -1) {
            ((JsonReference)this.references.get(index)).apply(og -> Json.nonnull(value).setDefaultMetadata((JsonValue)og));
            return this;
        }
        return this.addReference(key, new JsonReference(value).setAccessed(true));
    }

    public JsonObject setReference(String key, JsonReference reference) {
        int index = this.indexOf(key);
        if (index != -1) {
            this.references.set(index, reference);
            return this;
        }
        return this.addReference(key, reference);
    }

    public JsonObject setComment(String key, String comment) {
        JsonValue expected = this.get(key);
        if (expected == null) {
            throw new UnsupportedOperationException("Setting comment on null value (" + key + ")");
        }
        expected.setComment(comment);
        return this;
    }

    public JsonObject setDefaults(JsonObject defaultValues) {
        Iterator<String> keyIterator = defaultValues.keys.iterator();
        Iterator referenceIterator = defaultValues.references.iterator();
        while (keyIterator.hasNext() && referenceIterator.hasNext()) {
            String key = keyIterator.next();
            JsonReference reference = (JsonReference)referenceIterator.next();
            JsonValue replaced = this.get(key, null);
            if (replaced == null) {
                this.add(key, reference.get());
                continue;
            }
            if (!replaced.isObject() || !reference.getOnly().isObject()) continue;
            replaced.asObject().setDefaults(reference.get().asObject());
        }
        return this;
    }

    public JsonObject add(String key, long value) {
        return this.add(key, Json.value(value));
    }

    public JsonObject add(String key, double value) {
        return this.add(key, Json.value(value));
    }

    public JsonObject add(String key, boolean value) {
        return this.add(key, Json.value(value));
    }

    public JsonObject add(String key, String value) {
        return this.add(key, Json.value(value));
    }

    public JsonObject add(String key, @Nullable JsonValue value) {
        return this.addReference(key, new JsonReference(value));
    }

    public JsonObject add(String key, long value, String comment) {
        return this.add(key, Json.value(value), comment);
    }

    public JsonObject add(String key, double value, String comment) {
        return this.add(key, Json.value(value), comment);
    }

    public JsonObject add(String key, boolean value, String comment) {
        return this.add(key, Json.value(value), comment);
    }

    public JsonObject add(String key, String value, String comment) {
        return this.add(key, Json.value(value), comment);
    }

    public JsonObject add(String key, @Nullable JsonValue value, String comment) {
        return this.add(key, Json.nonnull(value).setComment(comment));
    }

    public JsonObject addAll(JsonObject object) {
        Iterator<String> keyIterator = object.keys.iterator();
        Iterator referenceIterator = object.references.iterator();
        while (keyIterator.hasNext() && referenceIterator.hasNext()) {
            this.addReference(keyIterator.next(), (JsonReference)referenceIterator.next());
        }
        return this;
    }

    public JsonObject addReference(String key, JsonReference reference) {
        this.table.add(key, this.keys.size());
        this.keys.add(key);
        this.references.add(reference);
        return this;
    }

    public JsonObject set(int index, String key, @Nullable JsonValue value) {
        if (!this.has(index)) {
            return this.add(key, value);
        }
        ((JsonReference)this.references.get(index)).apply(og -> Json.nonnull(value).setDefaultMetadata((JsonValue)og));
        this.keys.set(index, key);
        this.table.clear();
        this.table.init(this.keys);
        return this;
    }

    public JsonObject setKey(int index, String key) {
        if (index >= 0 && index < this.references.size()) {
            this.keys.set(index, key);
            this.table.clear();
            this.table.init(this.keys);
        }
        return this;
    }

    public JsonObject insert(int index, String key, @Nullable JsonValue value) {
        return this.insertReference(index, key, new JsonReference(value).setAccessed(true));
    }

    public JsonObject insertReference(int index, String key, JsonReference reference) {
        this.references.add(index, reference);
        this.keys.add(index, key);
        this.table.clear();
        this.table.init(this.keys);
        return this;
    }

    public boolean has(String key) {
        return this.indexOf(key) != -1;
    }

    @Nullable
    public JsonValue get(String key) {
        int index = this.indexOf(key);
        if (index != -1) {
            return ((JsonReference)this.references.get(index)).get();
        }
        return null;
    }

    @Contract(value="_, !null -> !null")
    public JsonValue get(String key, Object defaultValue) {
        JsonValue expected = this.get(key);
        if (expected != null) {
            return expected;
        }
        if (defaultValue == null) {
            return null;
        }
        return Json.any(defaultValue);
    }

    @NotNull
    public JsonValue getAsserted(String key) {
        JsonValue expected = this.get(key);
        if (expected == null) {
            throw new UnsupportedOperationException("Expected: " + key);
        }
        return expected;
    }

    public <T> Optional<T> getOptional(String key, Function<JsonValue, T> filter) {
        return this.getOptional(key).flatMap(value -> Optional.ofNullable(JsonObject.mapSuppressing(value, filter)));
    }

    public Optional<JsonValue> getOptional(String key) {
        return Optional.ofNullable(this.get(key));
    }

    @Nullable
    public JsonReference getReference(String key) {
        int index = this.indexOf(key);
        return index != -1 ? (JsonReference)this.references.get(index) : null;
    }

    public String getKey(int index) {
        return this.keys.get(index);
    }

    public JsonObject remove(String key) {
        int index = this.indexOf(key);
        if (index != -1) {
            this.references.remove(index);
            this.keys.remove(index);
            this.table.remove(index);
        }
        return this;
    }

    public JsonObject removeAllKeys(Iterable<String> keys) {
        keys.forEach(this::remove);
        return this;
    }

    public int indexOf(String key) {
        int index = this.table.get(key);
        if (index != -1 && key.equals(this.keys.get(index))) {
            return index;
        }
        return this.keys.lastIndexOf(key);
    }

    @Override
    public JsonObject clear() {
        this.references.clear();
        this.keys.clear();
        this.table.clear();
        return this;
    }

    @Override
    public JsonObject remove(JsonValue value) {
        int index = this.indexOf(value);
        if (index != -1) {
            this.references.remove(index);
            this.keys.remove(index);
            this.table.remove(index);
        }
        return this;
    }

    @Override
    public JsonObject removeAll(Iterable<JsonValue> values) {
        return (JsonObject)super.removeAll(values);
    }

    public <T> Map<String, T> toMap(Function<JsonValue, T> mapper) {
        return this.stream().collect(Collectors.toMap(Member::getKey, m -> mapper.apply(m.getValue())));
    }

    public Map<String, Object> toMap() {
        return this.toMap(JsonValue::unwrap);
    }

    @Override
    public JsonObject copy(int options) {
        JsonObject copy = new JsonObject(new ArrayList<String>(this.keys), this.copyReferences(options));
        if ((options & 8) == 8) {
            copy.setLinesTrailing(this.linesTrailing);
        }
        return JsonObject.withMetadata(copy, this, options);
    }

    @Override
    public final JsonType getType() {
        return JsonType.OBJECT;
    }

    @Override
    public Map<String, Object> unwrap() {
        return this.toMap();
    }

    @Override
    public final boolean isObject() {
        return true;
    }

    @Override
    public JsonObject asObject() {
        return this;
    }

    @Override
    public JsonObject intoObject() {
        return this;
    }

    @Override
    public Iterator<Member> iterator() {
        return new MemberIterator();
    }

    private synchronized void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.table.clear();
        this.table.init(this.keys);
    }

    @Override
    public int valueHashCode() {
        int result = 1;
        result = 31 * result + this.keys.hashCode();
        for (JsonReference reference : this.references) {
            result = 31 * reference.getOnly().valueHashCode();
        }
        return result;
    }

    @Override
    public int hashCode() {
        int result = this.metaHashCode();
        result = 31 * result + this.keys.hashCode();
        return 31 * result + this.references.hashCode();
    }

    @Override
    public boolean matches(JsonValue other) {
        if (!(other instanceof JsonObject)) {
            return false;
        }
        JsonObject object = (JsonObject)other;
        if (this.size() != object.size()) {
            return false;
        }
        if (!this.keys.equals(object.keys)) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (((JsonReference)this.references.get(i)).getOnly().matches(((JsonReference)object.references.get(i)).getOnly())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof JsonObject) {
            return this.keys.equals(((JsonObject)o).keys) && this.references.equals(((JsonObject)o).references);
        }
        return false;
    }

    @Override
    public JsonObject freeze(boolean recursive) {
        return new JsonObject(this.keys, this.freezeReferences(recursive));
    }

    @Override
    public List<String> getPaths(PathFilter filter) {
        ArrayList<String> paths = new ArrayList<String>();
        for (Member member : this) {
            if (!filter.test(member.getReference())) continue;
            paths.add(member.getKey());
            if (!member.getOnly().isContainer()) continue;
            Object prefix = member.getOnly().isObject() ? member.getKey() + "." : member.getKey();
            for (String inner : member.getOnly().asContainer().getPaths(filter)) {
                paths.add((String)prefix + inner);
            }
        }
        return paths;
    }

    private class MemberIterator
    implements Iterator<Member> {
        final Iterator<String> keys;
        final Iterator<JsonReference> references;
        int index;

        private MemberIterator() {
            this.keys = JsonObject.this.keys.iterator();
            this.references = JsonObject.this.references.iterator();
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext() && this.references.hasNext();
        }

        @Override
        public Member next() {
            return new Member(this.index++, this.keys.next(), this.references.next());
        }

        @Override
        public void remove() {
            this.references.remove();
            this.keys.remove();
        }
    }

    public static class Member
    extends JsonArray.Element {
        protected final String key;

        public Member(String key, JsonValue value) {
            this(-1, key, new JsonReference(value));
        }

        public Member(String key, JsonReference reference) {
            this(-1, key, reference);
        }

        public Member(int index, String key, JsonReference reference) {
            super(index, reference);
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public int hashCode() {
            int result = 1;
            result = 31 * result + this.index;
            result = 31 * result + this.key.hashCode();
            result = 31 * result + this.reference.hashCode();
            return result;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Member) {
                Member other = (Member)o;
                return this.index == other.index && this.key.equals(other.key) && this.reference.equals(other.reference);
            }
            return false;
        }

        @Override
        public String toString() {
            return "(" + this.key + "=" + this.reference + ")";
        }
    }
}

