/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.token;

import java.io.IOException;
import java.io.InputStream;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Nullable;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.Token;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenStream;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenType;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.Tokenizer;
import net.frozenblock.lib.shadow.xjs.data.serialization.util.PositionTrackingReader;

public class DjsTokenizer
extends Tokenizer {
    public DjsTokenizer(InputStream is, boolean containerized) throws IOException {
        super(is, containerized);
    }

    public DjsTokenizer(String text, boolean containerized) {
        super(text, containerized);
    }

    public DjsTokenizer(PositionTrackingReader reader, boolean containerized) {
        super(reader, containerized);
    }

    public static TokenStream stream(String text) {
        return new TokenStream(new DjsTokenizer(text, false), TokenType.OPEN);
    }

    public static TokenStream stream(InputStream is) throws IOException {
        return new TokenStream(new DjsTokenizer(is, false), TokenType.OPEN);
    }

    public static TokenStream stream(PositionTrackingReader reader) {
        return new TokenStream(new DjsTokenizer(reader, false), TokenType.OPEN);
    }

    public static TokenStream containerize(String text) {
        return new TokenStream(new DjsTokenizer(text, true), TokenType.OPEN);
    }

    public static TokenStream containerize(InputStream is) throws IOException {
        return new TokenStream(new DjsTokenizer(is, true), TokenType.OPEN);
    }

    public static TokenStream containerize(PositionTrackingReader reader) {
        return new TokenStream(new DjsTokenizer(reader, true), TokenType.OPEN);
    }

    @Override
    @Nullable
    protected Token single() throws IOException {
        this.reader.skipLineWhitespace();
        if (this.reader.isEndOfText()) {
            return null;
        }
        char c = (char)this.reader.current;
        this.startReading();
        return switch (c) {
            case '-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' -> this.number();
            case '#', '/' -> this.comment(c);
            case '\"', '\'' -> this.quote(c);
            case '\n' -> this.newLine();
            case '.' -> this.dot();
            default -> this.word();
        };
    }
}

