/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.token;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.ApiStatus;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Nullable;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.VisibleForTesting;
import net.frozenblock.lib.shadow.xjs.data.exception.SyntaxException;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.NumberToken;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.SymbolToken;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.Token;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenType;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.Tokenizer;
import net.frozenblock.lib.shadow.xjs.data.serialization.util.PositionTrackingReader;

public class TokenStream
extends Token
implements Iterable<Token>,
Closeable {
    protected final Queue<Token> pending = new ArrayDeque<Token>();
    @Nullable
    protected volatile Tokenizer tokenizer;
    protected List<Token> source;
    protected int lastRead;

    public TokenStream(int start, int end, int line, int lastLine, int offset, TokenType type, List<Token> tokens) {
        super(start, end, line, lastLine, offset, type);
        this.source = new ArrayList<Token>(tokens);
        this.lastRead = tokens.size() - 1;
    }

    public TokenStream(@NotNull Tokenizer tokenizer, TokenType type) {
        super(tokenizer.reader.index, -1, tokenizer.reader.line, -1, tokenizer.reader.index, type);
        this.source = Collections.emptyList();
        this.lastRead = -1;
        this.tokenizer = tokenizer;
    }

    public TokenStream(@NotNull Tokenizer tokenizer, Token from, TokenType type) {
        super(from.start(), -1, from.line(), -1, from.offset(), type);
        this.source = Collections.emptyList();
        this.lastRead = -1;
        this.tokenizer = tokenizer;
    }

    public TokenStream preserveOutput() {
        if (this.source == Collections.EMPTY_LIST) {
            this.source = new ArrayList<Token>();
        }
        return this;
    }

    @ApiStatus.Experimental
    public String stringify() {
        return this.stringify(1, true);
    }

    protected synchronized String stringify(int level, boolean readToEnd) {
        Token token;
        int idx;
        StringBuilder sb = new StringBuilder("[");
        int e = readToEnd ? Integer.MAX_VALUE : this.lastRead + 1;
        Itr itr = this.iterator();
        int n = idx = this.source.isEmpty() ? this.lastRead + 1 : 0;
        while (idx < e && (token = itr.peek(++idx)) != null) {
            this.stringifySingle(sb, token, level, readToEnd);
        }
        if (this.tokenizer != null) {
            this.writeNewLine(sb, level);
            sb.append("<reading...>");
        }
        this.writeNewLine(sb, level - 1);
        return sb.append("]").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public TokenStream readToEnd() {
        Tokenizer tokenizer = this.tokenizer;
        if (tokenizer != null) {
            TokenStream tokenStream = this;
            synchronized (tokenStream) {
                this.iterator().peek(Integer.MAX_VALUE);
            }
        }
        return this;
    }

    private void stringifySingle(StringBuilder sb, Token token, int level, boolean readToEnd) {
        this.writeNewLine(sb, level);
        sb.append(token.type()).append('(');
        if (token instanceof NumberToken) {
            NumberToken number = (NumberToken)token;
            sb.append(number.number);
        } else if (token instanceof TokenStream) {
            TokenStream stream = (TokenStream)token;
            sb.append(stream.stringify(level + 1, readToEnd));
        } else if (token instanceof SymbolToken) {
            SymbolToken symbol = (SymbolToken)token;
            sb.append('\'').append(symbol.symbol).append('\'');
        } else if (token.hasText()) {
            String text = token.parsed().replace("\n", "\\n").replace("\t", "\\t");
            sb.append('\'').append(text).append('\'');
        }
        sb.append(')');
    }

    private void writeNewLine(StringBuilder sb, int level) {
        sb.append('\n');
        sb.append(" ".repeat(Math.max(0, level)));
    }

    public List<Token> viewTokens() {
        return Collections.unmodifiableList(this.source);
    }

    @Nullable
    public Lookup lookup(char symbol, boolean exact) {
        return this.lookup(symbol, 0, exact);
    }

    @Nullable
    public Lookup lookup(char symbol, int fromIndex, boolean exact) {
        Token token;
        Itr itr = this.iterator();
        while ((token = itr.peek(++fromIndex)) != null) {
            if (!token.isSymbol(symbol)) continue;
            Lookup result = new Lookup(token, itr.getIndex());
            if (exact && (result.followsOtherSymbol() || result.precedesOtherSymbol())) {
                return this.lookup(symbol, fromIndex - 1, true);
            }
            return result;
        }
        return null;
    }

    @Nullable
    public Lookup lookup(String symbol, boolean exact) {
        return this.lookup(symbol, 0, exact);
    }

    @Nullable
    public Lookup lookup(String symbol, int fromIndex, boolean exact) {
        char c = symbol.charAt(0);
        Lookup firstLookup = this.lookup(c, fromIndex, false);
        if (firstLookup == null) {
            return null;
        }
        if (exact && firstLookup.followsOtherSymbol()) {
            return this.lookup(symbol, fromIndex + 1, true);
        }
        Lookup previousLookup = firstLookup;
        Lookup nextLookup = firstLookup;
        for (int i = 1; i < symbol.length(); ++i) {
            c = symbol.charAt(i);
            nextLookup = this.lookup(c, fromIndex + i, false);
            if (nextLookup == null) {
                return null;
            }
            if (nextLookup.token.start() != previousLookup.token.end() || nextLookup.index - previousLookup.index != 1) {
                return this.lookup(symbol, firstLookup.index + 1, exact);
            }
            previousLookup = nextLookup;
        }
        if (exact && nextLookup.precedesOtherSymbol()) {
            return this.lookup(symbol, nextLookup.index + 1, true);
        }
        return firstLookup;
    }

    public Itr iterator() {
        char closer = switch ((TokenType)((Object)this.type)) {
            case TokenType.PARENTHESES -> ')';
            case TokenType.BRACES -> '}';
            case TokenType.BRACKETS -> ']';
            default -> '\u0000';
        };
        return new Itr(closer);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof TokenStream) {
            return super.equals(o) && this.lastLine == ((TokenStream)o).lastLine && this.source.equals(((TokenStream)o).source);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.stringify(1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Tokenizer tokenizer;
        TokenStream tokenStream = this;
        synchronized (tokenStream) {
            tokenizer = this.tokenizer;
        }
        if (tokenizer != null) {
            tokenizer.close();
        }
    }

    public class Itr
    implements Iterator<Token> {
        protected final char closer;
        protected Token previous;
        protected Token next;
        protected boolean ready;
        protected int elementIndex;

        protected Itr(char closer) {
            this.closer = closer;
            this.elementIndex = -1;
            this.ready = true;
        }

        @Override
        public boolean hasNext() {
            if (this.ready) {
                this.read();
                this.ready = false;
            }
            return this.next != null;
        }

        @Override
        public Token next() {
            if (this.ready) {
                this.read();
            }
            Token current = this.next;
            ++this.elementIndex;
            this.ready = true;
            return current;
        }

        protected void read() {
            this.previous = this.next;
            this.next = !TokenStream.this.pending.isEmpty() ? TokenStream.this.pending.poll() : (this.elementIndex + 1 < TokenStream.this.source.size() ? TokenStream.this.source.get(this.elementIndex + 1) : this.resolve(1, false));
        }

        public void skipTo(int index) {
            this.skip(index - 1 - this.elementIndex);
        }

        public void skip(int amount) {
            for (int i = 0; i < amount; ++i) {
                if (TokenStream.this.pending.isEmpty()) continue;
                TokenStream.this.pending.poll();
            }
            this.elementIndex += amount;
            this.resolve(0, false);
            this.ready = true;
        }

        public int getIndex() {
            return this.elementIndex;
        }

        public TokenStream getParent() {
            return TokenStream.this;
        }

        @Nullable
        public Token peek() {
            return this.peek(1);
        }

        public Token peek(int amount, Token defaultValue) {
            Token peek = this.peek(amount);
            return peek != null ? peek : defaultValue;
        }

        @Nullable
        public Token peek(int amount) {
            Token peek = this.getCached(amount);
            return peek != null ? peek : this.resolve(amount, true);
        }

        @Nullable
        protected Token getCached(int offset) {
            int peekIndex;
            if (offset == -1) {
                return this.previous;
            }
            if (!TokenStream.this.pending.isEmpty()) {
                if (offset == 1) {
                    return TokenStream.this.pending.peek();
                }
                int pendingIdx = offset - 1;
                if (pendingIdx > 0 && pendingIdx < TokenStream.this.pending.size()) {
                    return new ArrayList<Token>(TokenStream.this.pending).get(pendingIdx);
                }
            } else if (!TokenStream.this.source.isEmpty() && (peekIndex = this.elementIndex + offset) >= 0 && peekIndex < TokenStream.this.source.size()) {
                return TokenStream.this.source.get(peekIndex);
            }
            return null;
        }

        @Nullable
        protected Token resolve(int offset, boolean enqueue) {
            Tokenizer tokenizer = TokenStream.this.tokenizer;
            if (tokenizer == null) {
                return null;
            }
            Token next = this.getCached(offset - 1);
            while (TokenStream.this.lastRead < this.elementIndex + offset) {
                TokenStream stream;
                if (next instanceof TokenStream) {
                    stream = (TokenStream)next;
                    stream.readToEnd();
                    this.expandToFit(stream);
                }
                try {
                    next = tokenizer.next();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                ++TokenStream.this.lastRead;
                if (next == null) {
                    if (this.closer != '\u0000') {
                        PositionTrackingReader reader = tokenizer.getReader();
                        throw SyntaxException.expected(this.closer, reader.line, reader.column);
                    }
                    Itr.tryClose(tokenizer);
                    TokenStream.this.tokenizer = null;
                    return null;
                }
                this.expandToFit(next);
                if (next.isSymbol(this.closer)) {
                    TokenStream.this.tokenizer = null;
                    return null;
                }
                if (TokenStream.this.source != Collections.EMPTY_LIST) {
                    if (next instanceof TokenStream) {
                        stream = (TokenStream)next;
                        stream.preserveOutput();
                    }
                    TokenStream.this.source.add(next);
                    continue;
                }
                if (!enqueue) continue;
                TokenStream.this.pending.add(next);
            }
            return next;
        }

        protected void expandToFit(Token t) {
            if (t.end() > TokenStream.this.end) {
                TokenStream.this.end = t.end();
            }
            if (t.lastLine() > TokenStream.this.lastLine) {
                TokenStream.this.lastLine = t.lastLine();
            }
        }

        protected static void tryClose(Tokenizer tokenizer) {
            if (tokenizer != null) {
                try {
                    tokenizer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public class Lookup {
        public final Token token;
        public final int index;

        protected Lookup(Token token, int index) {
            this.token = token;
            this.index = index;
        }

        public boolean followsOtherSymbol() {
            if (this.index > 0) {
                Token previous = TokenStream.this.source.get(this.index - 1);
                return previous.type() == TokenType.SYMBOL && this.token.start() == previous.end();
            }
            return false;
        }

        public boolean precedesOtherSymbol() {
            if (this.index < TokenStream.this.source.size() - 1) {
                Token following = TokenStream.this.source.get(this.index + 1);
                return following.type() == TokenType.SYMBOL && this.token.end() == following.start();
            }
            return false;
        }

        @ApiStatus.Experimental
        public boolean isFollowedBy(char symbol) {
            if (TokenStream.this.source.size() > this.index + 1) {
                Token following = TokenStream.this.source.get(this.index + 1);
                return this.token.end() == following.start() && following.isSymbol(symbol);
            }
            return false;
        }
    }
}

