/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data.serialization.writer;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Iterator;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Nullable;
import net.frozenblock.lib.shadow.xjs.data.JsonArray;
import net.frozenblock.lib.shadow.xjs.data.JsonContainer;
import net.frozenblock.lib.shadow.xjs.data.JsonObject;
import net.frozenblock.lib.shadow.xjs.data.JsonReference;
import net.frozenblock.lib.shadow.xjs.data.JsonString;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.StringType;
import net.frozenblock.lib.shadow.xjs.data.serialization.JsonContext;
import net.frozenblock.lib.shadow.xjs.data.serialization.util.BufferedStack;
import net.frozenblock.lib.shadow.xjs.data.serialization.util.WritingBuffer;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.JsonWriterOptions;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.ValueWriter;

public abstract class ElementWriter
implements ValueWriter {
    protected static final Iterator<? extends JsonArray.Element> EMPTY_ITERATOR = Collections.emptyIterator();
    protected final boolean format;
    protected final Writer tw;
    protected final boolean allowCondense;
    protected final boolean bracesSameLine;
    protected final boolean nestedSameLine;
    protected final boolean omitRootBraces;
    protected final boolean omitQuotes;
    protected final String eol;
    protected final String indent;
    protected final int minSpacing;
    protected final int maxSpacing;
    protected final int defaultSpacing;
    protected final boolean smartSpacing;
    protected final boolean nextLineMulti;
    protected final String separator;
    protected final BufferedStack.OfTwo<JsonArray.Element, Iterator<? extends JsonArray.Element>> stack;
    protected Iterator<? extends JsonArray.Element> iterator;
    protected JsonArray.Element parent;
    protected JsonArray.Element previous;
    protected JsonArray.Element current;
    protected JsonArray.Element peek;
    protected int level;

    protected ElementWriter(File file, boolean format) throws IOException {
        this((Writer)new FileWriter(file), format);
    }

    protected ElementWriter(Writer writer, boolean format) {
        this.format = format;
        this.tw = new WritingBuffer(writer);
        this.eol = JsonContext.getEol();
        this.allowCondense = true;
        this.bracesSameLine = true;
        this.nestedSameLine = false;
        this.omitRootBraces = true;
        this.omitQuotes = true;
        this.indent = "  ";
        this.minSpacing = 0;
        this.maxSpacing = Integer.MAX_VALUE;
        this.defaultSpacing = format ? 1 : 0;
        this.smartSpacing = false;
        this.nextLineMulti = true;
        this.separator = format ? " " : "";
        this.stack = BufferedStack.ofTwo();
        this.level = 0;
    }

    protected ElementWriter(File file, JsonWriterOptions options) throws IOException {
        this((Writer)new FileWriter(file), options);
    }

    protected ElementWriter(Writer writer, JsonWriterOptions options) {
        this.format = true;
        this.tw = new WritingBuffer(writer);
        this.eol = options.getEol();
        this.allowCondense = options.isAllowCondense();
        this.bracesSameLine = options.isBracesSameLine();
        this.nestedSameLine = options.isNestedSameLine();
        this.omitRootBraces = options.isOmitRootBraces();
        this.omitQuotes = options.isOmitQuotes();
        this.indent = options.getIndent();
        this.minSpacing = options.getMinSpacing();
        this.maxSpacing = options.getMaxSpacing();
        this.defaultSpacing = options.getDefaultSpacing();
        this.smartSpacing = options.isSmartSpacing();
        this.nextLineMulti = options.isNextLineMulti();
        this.separator = options.getSeparator();
        this.stack = BufferedStack.ofTwo();
        this.level = 0;
    }

    @Override
    public void write(JsonValue value) throws IOException {
        this.current = new JsonArray.Element(0, new JsonReference(value));
        this.write();
        this.tw.flush();
    }

    protected abstract void write() throws IOException;

    protected void next() {
        Iterator<? extends JsonArray.Element> iterator = this.iterator;
        if (iterator == EMPTY_ITERATOR) {
            this.current = null;
            return;
        }
        JsonArray.Element next = iterator.hasNext() ? iterator.next() : null;
        this.cycle(next);
    }

    protected void cycle(JsonArray.Element peek) {
        this.previous = this.current;
        this.current = this.peek;
        this.peek = peek;
    }

    protected boolean push() {
        if (this.parent == this.current) {
            return false;
        }
        if (this.current.getOnly() instanceof JsonContainer) {
            if (this.parent != null) {
                this.stack.push(this.parent, this.iterator);
            }
            this.parent = this.current;
            this.iterator = this.getNextIterator();
            this.clear();
            if (this.iterator.hasNext()) {
                this.current = this.iterator.next();
                if (this.iterator.hasNext()) {
                    this.peek = this.iterator.next();
                }
            }
            ++this.level;
            return true;
        }
        return false;
    }

    protected Iterator<? extends JsonArray.Element> getNextIterator() {
        if (this.current.getOnly().isObject()) {
            return this.current.getOnly().asObject().iterator();
        }
        return this.current.getOnly().asArray().elements().iterator();
    }

    protected boolean pop() {
        if (this.stack.isEmpty()) {
            this.iterator = EMPTY_ITERATOR;
            return false;
        }
        int index = this.parent.getIndex();
        this.stack.pop();
        this.parent = this.stack.getFirst();
        this.iterator = this.stack.getSecond();
        this.reconstruct(index);
        --this.level;
        return true;
    }

    protected void reconstruct(int index) {
        this.clear();
        if (index > 0) {
            this.previous = this.getElement(index - 1);
        }
        this.current = this.getElement(index);
        if (index < this.parent().size() - 1) {
            this.peek = this.getElement(index + 1);
        }
    }

    protected JsonArray.Element getElement(int index) {
        JsonContainer c = this.parent();
        if (c.isObject()) {
            JsonObject o = c.asObject();
            return new JsonObject.Member(index, o.getKey(index), o.getReference(index));
        }
        return new JsonArray.Element(index, this.parent().getReference(index));
    }

    protected void clear() {
        this.previous = null;
        this.current = null;
        this.peek = null;
    }

    protected JsonContainer parent() {
        return this.parent != null ? this.parent.getOnly().asContainer() : null;
    }

    protected JsonValue previous() {
        return this.previous != null ? this.previous.getOnly() : null;
    }

    protected JsonValue current() {
        return this.current.getOnly();
    }

    protected JsonValue peek() {
        return this.peek != null ? this.peek.getOnly() : null;
    }

    protected int index() {
        return this.current != null ? this.current.getIndex() : 0;
    }

    protected String key() {
        return ((JsonObject.Member)this.current).getKey();
    }

    protected void open(char opener) throws IOException {
        this.push();
        if (opener != '\u0000') {
            this.tw.write(opener);
        }
        if (this.shouldSeparateOpener()) {
            this.tw.write(this.separator);
        }
    }

    protected void close(char closer) throws IOException {
        if (this.format && !this.writeTrailing() && this.shouldSeparateCloser()) {
            this.tw.write(this.separator);
        }
        if (closer != '\u0000') {
            this.tw.write(closer);
        }
        this.pop();
    }

    protected boolean shouldSeparateOpener() {
        return this.format && this.allowCondense && this.level > 0 && this.parent().size() > 1 && this.getFirst(this.parent()).getLinesAbove() == 0;
    }

    protected boolean shouldSeparateCloser() {
        return this.isCondensed() && this.level > 0;
    }

    protected void writeAbove() throws IOException {
        if (this.format) {
            this.writeLines(this.getActualLinesAbove());
        }
    }

    protected void writeBetween() throws IOException {
        if (this.format) {
            int lines = this.getActualLinesBetween();
            if (lines > 0) {
                this.writeLines(lines, this.level + 1);
            } else {
                this.tw.write(this.separator);
            }
        }
    }

    protected void writeAfter() throws IOException {
    }

    protected boolean writeTrailing() throws IOException {
        int lines;
        if (this.format && (lines = this.getActualLinesTrailing()) > 0) {
            this.writeLines(lines, this.level - 1);
            return true;
        }
        return false;
    }

    protected boolean isCondensed() {
        return this.isCondensed(this.parent());
    }

    protected boolean isCondensed(@Nullable JsonContainer c) {
        if (c == null || !this.allowCondense) {
            return false;
        }
        if (c.isEmpty()) {
            return false;
        }
        if (c.size() == 1 && this.level == -1) {
            return false;
        }
        if (this.getLinesAbove(this.getFirst(c)) != 0) {
            return false;
        }
        return c.size() == 1 || this.getLinesAbove(this.getLast(c)) == 0;
    }

    protected JsonValue getFirst(JsonContainer c) {
        return c.getReference(0).getOnly();
    }

    @Nullable
    protected JsonValue getFirst(JsonValue v) {
        return v instanceof JsonContainer ? this.getFirst(v.asContainer()) : null;
    }

    protected JsonValue getLast(JsonContainer c) {
        return c.getReference(c.size() - 1).getOnly();
    }

    protected int getLinesAbove(@Nullable JsonValue value) {
        return value != null ? value.getLinesAbove() : -1;
    }

    protected int getActualLinesAbove() {
        int lines = this.getLinesAbove(this.current());
        if (lines < 0) {
            return this.getDefaultLinesAbove();
        }
        if (!this.isTopOfFile() && !this.allowCondense) {
            return Math.max(1, lines);
        }
        if (this.level == 0 && this.index() == 0) {
            return lines;
        }
        return this.limitLines(lines);
    }

    protected int getDefaultLinesAbove() {
        if (this.isTopOfFile()) {
            return 0;
        }
        int spacing = this.getSpacing();
        if (this.index() == 0) {
            if (this.level > 0) {
                return Math.max(1, spacing - 1);
            }
            return spacing - 1;
        }
        return spacing;
    }

    protected int getSpacing() {
        if (this.shouldDoSmartSpace()) {
            return this.defaultSpacing + 1;
        }
        return this.defaultSpacing;
    }

    protected boolean shouldDoSmartSpace() {
        if (this.smartSpacing && this.parent != null && this.parent().isObject()) {
            return this.requiresSmartSpace(this.current()) || this.requiresSmartSpace(this.previous());
        }
        return false;
    }

    protected int getLinesBetween(@Nullable JsonValue value) {
        return value != null ? value.getLinesBetween() : -1;
    }

    protected int getActualLinesBetween() {
        JsonValue value = this.current();
        int lines = this.getLinesBetween(value);
        lines = value.isContainer() && !this.bracesSameLine ? Math.max(1, lines) : Math.max(0, lines);
        return Math.min(lines, this.maxSpacing);
    }

    protected int getActualLinesTrailing() {
        int lines = this.parent().getLinesTrailing();
        if (lines < 0 && this.parent().size() > 0) {
            return this.getDefaultLinesTrailing();
        }
        return this.limitLines(lines);
    }

    private int getDefaultLinesTrailing() {
        if (this.isCondensed()) {
            return 0;
        }
        if (this.level >= 0) {
            return Math.max(1, this.defaultSpacing - 1);
        }
        return this.defaultSpacing - 1;
    }

    protected int limitLines(int lines) {
        if (this.isCondensed()) {
            return Math.min(lines, this.maxSpacing);
        }
        if (this.isTopOrBottom()) {
            return Math.max(Math.min(lines, this.maxSpacing - 1), this.minSpacing - 1);
        }
        return Math.max(Math.min(lines, this.maxSpacing), this.minSpacing);
    }

    protected boolean isTopOrBottom() {
        return this.current == null || this.index() == 0;
    }

    protected boolean isTopOfFile() {
        return this.level == 0 && this.index() == 0;
    }

    protected boolean isEndOfContainer() {
        return this.parent == null || this.index() == this.parent().size() - 1;
    }

    protected boolean requiresSmartSpace(JsonValue value) {
        return value instanceof JsonContainer;
    }

    protected void nl() throws IOException {
        this.nl(this.level);
    }

    protected void nl(int level) throws IOException {
        if (this.format) {
            this.tw.write(this.eol);
            for (int i = 0; i < level; ++i) {
                this.tw.write(this.indent);
            }
        }
    }

    protected void writeLines(int lines) throws IOException {
        this.writeLines(lines, this.level);
    }

    protected void writeLines(int lines, int level) throws IOException {
        int i;
        if (lines <= 0 || level < 0) {
            return;
        }
        for (i = 0; i < lines; ++i) {
            this.tw.write(this.eol);
        }
        for (i = 0; i < level; ++i) {
            this.tw.write(this.indent);
        }
    }

    protected void delimit() throws IOException {
        if (this.peek != null) {
            this.tw.write(44);
            if (this.allowCondense && this.getLinesAbove(this.peek()) == 0) {
                this.tw.write(this.separator);
            }
        }
    }

    protected void writeNumber(double decimal) throws IOException {
        long integer = (long)decimal;
        if ((double)integer == decimal) {
            this.tw.write(Long.toString(integer));
            return;
        }
        String res = decimal == Double.POSITIVE_INFINITY ? "infinity" : (decimal == Double.NEGATIVE_INFINITY ? "-infinity" : BigDecimal.valueOf(decimal).toEngineeringString());
        if (res.endsWith(".0")) {
            res = res.substring(0, res.length() - 2);
        } else if (res.contains("E")) {
            res = Double.toString(decimal).replace("E", "e");
        }
        this.tw.write(res);
    }

    protected void writeQuoted(String text, char quote) throws IOException {
        this.tw.write(quote);
        this.tw.write(ElementWriter.escapeQuoted(text, quote));
        this.tw.write(quote);
    }

    protected static String escapeQuoted(String text, char quote) {
        if (text == null) {
            return null;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (ElementWriter.getEscapedChar(text.charAt(i), quote) == null) continue;
            StringBuilder sb = new StringBuilder();
            if (i > 0) {
                sb.append(text, 0, i);
            }
            return ElementWriter.doEscapeString(sb, text, i, quote);
        }
        return text;
    }

    protected static String doEscapeString(StringBuilder sb, String text, int cur, char quote) {
        int start = cur;
        for (int i = cur; i < text.length(); ++i) {
            String escaped = ElementWriter.getEscapedChar(text.charAt(i), quote);
            if (escaped == null) continue;
            sb.append(text, start, i);
            sb.append(escaped);
            start = i + 1;
        }
        sb.append(text, start, text.length());
        return sb.toString();
    }

    @Nullable
    protected static String getEscapedChar(char c, char quote) {
        if (c == quote) {
            return "\\" + quote;
        }
        return switch (c) {
            case '\t' -> "\\t";
            case '\n' -> "\\n";
            case '\r' -> "\\r";
            case '\f' -> "\\f";
            case '\b' -> "\\b";
            case '\\' -> "\\\\";
            default -> null;
        };
    }

    protected void writeMulti(String value) throws IOException {
        int i;
        int level;
        int n = level = this.current instanceof JsonObject.Member ? this.level + 1 : this.level;
        if (this.shouldNextLineMulti()) {
            this.nl(level);
        }
        this.tw.write("'''");
        this.nl(level);
        int lastLine = 0;
        int quotes = 0;
        for (i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\r') {
                if (i >= value.length() - 1 || value.charAt(i + 1) != '\n') continue;
                this.writeLine(value, level, lastLine, i);
                lastLine = i + 2;
                ++i;
                continue;
            }
            if (c == '\n') {
                this.writeLine(value, level, lastLine, i);
                lastLine = i + 1;
                continue;
            }
            if (c == '\'') {
                if (++quotes != 3) continue;
                this.writeLine(value, level, lastLine, i);
                this.tw.write("\\'");
                lastLine = i;
                continue;
            }
            quotes = 0;
        }
        this.tw.write(value, lastLine, i - lastLine);
        this.nl(level);
        this.tw.write("'''");
    }

    protected boolean shouldNextLineMulti() {
        if (!this.nextLineMulti || !(this.current instanceof JsonObject.Member)) {
            return false;
        }
        JsonValue source = this.current.getOnly();
        int between = source.getLinesBetween();
        if (source instanceof JsonString && ((JsonString)source).getStringType() == StringType.MULTI) {
            return between == -1;
        }
        return between < 1;
    }

    protected void writeIndented(String data) throws IOException {
        this.writeIndented(data, this.level, false);
    }

    protected void writeIndented(String data, int level) throws IOException {
        this.writeIndented(data, level, false);
    }

    protected void writeIndented(String data, int level, boolean trim) throws IOException {
        int i;
        int lastLine = 0;
        for (i = 0; i < (trim ? data.length() - 1 : data.length()); ++i) {
            char c = data.charAt(i);
            if (c == '\r') {
                if (i >= data.length() - 1 || data.charAt(i + 1) != '\n') continue;
                this.writeLine(data, level, lastLine, i);
                lastLine = i + 1;
                ++i;
                continue;
            }
            if (c != '\n') continue;
            this.writeLine(data, level, lastLine, i);
            lastLine = i + 1;
        }
        this.tw.write(data, lastLine, i - lastLine);
    }

    protected void writeLine(String value, int level, int s, int e) throws IOException {
        char peek;
        if (e < value.length() - 2 && ((peek = value.charAt(e + 2)) == '\r' || peek == '\n')) {
            level = 0;
        }
        if (e - s != 0) {
            this.tw.write(value, s, e - s);
        }
        this.nl(level);
    }

    @Override
    public void close() throws IOException {
        this.tw.close();
    }
}

