/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.biome.api.parameters;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import net.frozenblock.lib.worldgen.biome.api.parameters.BiomeParameters;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6554;

public final class OverworldBiomeBuilderParameters {
    public static final float VALLEY_SIZE = 0.05f;
    public static final float LOW_START = 0.26666668f;
    public static final float HIGH_START = 0.4f;
    public static final float HIGH_END = 0.93333334f;
    public static final float PEAK_SIZE = 0.1f;
    public static final float PEAK_START = 0.56666666f;
    public static final float PEAK_END = 0.7666667f;
    public static final float NEAR_INLAND_START = -0.11f;
    public static final float MID_INLAND_START = 0.03f;
    public static final float FAR_INLAND_START = 0.3f;
    public static final float EROSION_INDEX_1_START = -0.78f;
    public static final float EROSION_INDEX_2_START = -0.375f;
    private static final float EROSION_DEEP_DARK_DRYNESS_THRESHOLD = -0.225f;
    private static final float DEPTH_DEEP_DARK_DRYNESS_THRESHOLD = 0.9f;
    public static final class_6544.class_6546 FULL_RANGE = class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f);
    public static final class_6544.class_6546[] TEMPERATURES = new class_6544.class_6546[]{class_6544.class_6546.method_38121((float)-1.0f, (float)-0.45f), class_6544.class_6546.method_38121((float)-0.45f, (float)-0.15f), class_6544.class_6546.method_38121((float)-0.15f, (float)0.2f), class_6544.class_6546.method_38121((float)0.2f, (float)0.55f), class_6544.class_6546.method_38121((float)0.55f, (float)1.0f)};
    public static final class_6544.class_6546[] HUMIDITIES = new class_6544.class_6546[]{class_6544.class_6546.method_38121((float)-1.0f, (float)-0.35f), class_6544.class_6546.method_38121((float)-0.35f, (float)-0.1f), class_6544.class_6546.method_38121((float)-0.1f, (float)0.1f), class_6544.class_6546.method_38121((float)0.1f, (float)0.3f), class_6544.class_6546.method_38121((float)0.3f, (float)1.0f)};
    public static final class_6544.class_6546[] EROSIONS = new class_6544.class_6546[]{class_6544.class_6546.method_38121((float)-1.0f, (float)-0.78f), class_6544.class_6546.method_38121((float)-0.78f, (float)-0.375f), class_6544.class_6546.method_38121((float)-0.375f, (float)-0.2225f), class_6544.class_6546.method_38121((float)-0.2225f, (float)0.05f), class_6544.class_6546.method_38121((float)0.05f, (float)0.45f), class_6544.class_6546.method_38121((float)0.45f, (float)0.55f), class_6544.class_6546.method_38121((float)0.55f, (float)1.0f)};
    public static final class_6544.class_6546 FROZEN_RANGE = TEMPERATURES[0];
    public static final class_6544.class_6546 UNFROZEN_RANGE = class_6544.class_6546.method_38123((class_6544.class_6546)TEMPERATURES[1], (class_6544.class_6546)TEMPERATURES[4]);
    public static final class_6544.class_6546 MUSHROOM_FIELDS_CONTINENTALNESS = class_6544.class_6546.method_38121((float)-1.2f, (float)-1.05f);
    public static final class_6544.class_6546 DEEP_OCEAN_CONTINENTALNESS = class_6544.class_6546.method_38121((float)-1.05f, (float)-0.455f);
    public static final class_6544.class_6546 OCEAN_CONTINENTALNESS = class_6544.class_6546.method_38121((float)-0.455f, (float)-0.19f);
    public static final class_6544.class_6546 COAST_CONTINENTALNESS = class_6544.class_6546.method_38121((float)-0.19f, (float)-0.11f);
    public static final class_6544.class_6546 INLAND_CONTINENTALNESS = class_6544.class_6546.method_38121((float)-0.11f, (float)0.55f);
    public static final class_6544.class_6546 NEAR_INLAND_CONTINENTALNESS = class_6544.class_6546.method_38121((float)-0.11f, (float)0.03f);
    public static final class_6544.class_6546 MID_INLAND_CONTINENTALNESS = class_6544.class_6546.method_38121((float)0.03f, (float)0.3f);
    public static final class_6544.class_6546 FAR_INLAND_CONTINENTALNESS = class_6544.class_6546.method_38121((float)0.3f, (float)1.0f);
    public static final Map<class_2960, BiomeParameters> BIOMES = new LinkedHashMap<class_2960, BiomeParameters>();
    private static boolean hasRun = false;
    private static final List<class_6544.class_4762> OFF_COAST_POINTS = new ArrayList<class_6544.class_4762>();

    public static BiomeParameters getParameters(class_2960 location) {
        OverworldBiomeBuilderParameters.runBiomes();
        return OverworldBiomeBuilderParameters.getOrCreateParameters(location);
    }

    private static void runBiomes() {
        if (!hasRun) {
            hasRun = true;
            OverworldBiomeBuilderParameters.addBiomes(pair -> OverworldBiomeBuilderParameters.addParameters((class_2960)pair.getFirst(), (class_6544.class_4762)pair.getSecond()));
        }
    }

    public static BiomeParameters getParameters(class_5321<class_1959> key) {
        return OverworldBiomeBuilderParameters.getParameters(key.method_29177());
    }

    private static void addParameters(class_2960 location, class_6544.class_4762 parameters) {
        BiomeParameters biomeParameters = OverworldBiomeBuilderParameters.getOrCreateParameters(location);
        biomeParameters.add(parameters);
    }

    private static BiomeParameters getOrCreateParameters(class_2960 location) {
        if (BIOMES.containsKey(location)) {
            return BIOMES.get(location);
        }
        BiomeParameters parameters = new BiomeParameters();
        BIOMES.put(location, parameters);
        return parameters;
    }

    public static List<class_6544.class_4762> points(BiomeParameters parameters) {
        return parameters.points;
    }

    public static List<class_6544.class_4762> points(class_5321<class_1959> key) {
        return OverworldBiomeBuilderParameters.points(key.method_29177());
    }

    public static List<class_6544.class_4762> points(class_2960 location) {
        return OverworldBiomeBuilderParameters.points(OverworldBiomeBuilderParameters.getParameters(location));
    }

    private static void addBiomes(Consumer<Pair<class_2960, class_6544.class_4762>> key) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        new class_6554().method_38185(parameterPointResourceKeyPair -> builder.add(parameterPointResourceKeyPair));
        builder.build().forEach(parameterPointResourceKeyPair -> key.accept(new Pair((Object)((class_5321)parameterPointResourceKeyPair.getSecond()).method_29177(), (Object)((class_6544.class_4762)parameterPointResourceKeyPair.getFirst()))));
    }

    public static List<class_6544.class_4762> getOffCoastPoints() {
        OverworldBiomeBuilderParameters.runBiomes();
        return OFF_COAST_POINTS;
    }

    @Generated
    private OverworldBiomeBuilderParameters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

