/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.biome.impl;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.frozenblock.lib.FrozenSharedConstants;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.ApiStatus;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_8197;
import org.slf4j.Logger;

@ApiStatus.Internal
public final class OverworldBiomeData {
    private static final Set<class_5321<class_1959>> OVERWORLD_BIOMES = new ObjectOpenHashSet();
    private static final Map<class_5321<class_1959>, class_6544.class_4762> OVERWORLD_BIOME_NOISE_POINTS = new Object2ObjectOpenHashMap();
    private static final Logger LOGGER = FrozenSharedConstants.LOGGER;

    private OverworldBiomeData() {
    }

    public static void addOverworldBiome(class_5321<class_1959> biome, class_6544.class_4762 spawnNoisePoint) {
        Preconditions.checkArgument((biome != null ? 1 : 0) != 0, (Object)"Biome is null");
        Preconditions.checkArgument((spawnNoisePoint != null ? 1 : 0) != 0, (Object)"Climate.ParameterPoint is null");
        OVERWORLD_BIOME_NOISE_POINTS.put(biome, spawnNoisePoint);
        OverworldBiomeData.clearBiomeSourceCache();
    }

    public static Map<class_5321<class_1959>, class_6544.class_4762> getOverworldBiomeNoisePoints() {
        return OVERWORLD_BIOME_NOISE_POINTS;
    }

    public static boolean canGenerateInOverworld(class_5321<class_1959> biome) {
        return class_8197.class_5305.field_34499.method_49514().anyMatch(input -> input.equals(biome));
    }

    private static void clearBiomeSourceCache() {
        OVERWORLD_BIOMES.clear();
    }

    public static <T> class_6544.class_6547<T> withModdedBiomeEntries(class_6544.class_6547<T> entries, Function<class_5321<class_1959>, T> biomes) {
        if (OVERWORLD_BIOME_NOISE_POINTS.isEmpty()) {
            return entries;
        }
        ArrayList<Pair> entryList = new ArrayList<Pair>(entries.method_38128());
        for (Map.Entry<class_5321<class_1959>, class_6544.class_4762> entry : OVERWORLD_BIOME_NOISE_POINTS.entrySet()) {
            entryList.add(Pair.of((Object)entry.getValue(), biomes.apply(entry.getKey())));
        }
        return new class_6544.class_6547(entryList);
    }
}

