/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.feature.api.features;

import com.mojang.serialization.Codec;
import net.frozenblock.lib.math.api.EasyNoiseSampler;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.frozenblock.lib.worldgen.feature.api.features.config.PathSwapUnderWaterTagFeatureConfig;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3031;
import net.minecraft.class_3486;
import net.minecraft.class_3756;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6646;

public class NoisePathSwapUnderWaterTagFeature
extends class_3031<PathSwapUnderWaterTagFeatureConfig> {
    public NoisePathSwapUnderWaterTagFeature(Codec<PathSwapUnderWaterTagFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(@NotNull class_5821<PathSwapUnderWaterTagFeatureConfig> context) {
        boolean generated = false;
        PathSwapUnderWaterTagFeatureConfig config = (PathSwapUnderWaterTagFeatureConfig)context.method_33656();
        class_2338 blockPos = context.method_33655();
        class_5281 level = context.method_33652();
        int radiusSquared = config.radius() * config.radius();
        class_5819 random = level.method_8409();
        long noiseSeed = level.method_8412();
        class_3756 sampler = config.noise() == 1 ? EasyNoiseSampler.createLocalNoise(noiseSeed) : (config.noise() == 2 ? EasyNoiseSampler.createCheckedNoise(noiseSeed) : (config.noise() == 3 ? EasyNoiseSampler.createLegacyThreadSafeNoise(noiseSeed) : EasyNoiseSampler.createXoroNoise(noiseSeed)));
        float chance = config.placementChance();
        int bx = blockPos.method_10263();
        int by = blockPos.method_10264();
        int bz = blockPos.method_10260();
        class_2338.class_2339 mutable = blockPos.method_25503();
        class_6646 predicate = config.onlyPlaceWhenExposed() ? class_6646.field_35697 : class_6646.method_39011();
        for (int x = bx - config.radius(); x <= bx + config.radius(); ++x) {
            for (int z = bz - config.radius(); z <= bz + config.radius(); ++z) {
                if (!config.is3D()) {
                    double distance = (bx - x) * (bx - x) + (bz - z) * (bz - z);
                    if (!(distance < (double)radiusSquared)) continue;
                    mutable.method_10103(x, level.method_8624(class_2902.class_2903.field_13200, x, z) - 1, z);
                    double sample = EasyNoiseSampler.sample(sampler, (class_2382)mutable, config.noiseScale(), config.scaleY(), config.useY());
                    if (!(sample > config.minThreshold()) || !(sample < config.maxThreshold()) || !level.method_8320((class_2338)mutable).method_26164(config.replaceableBlocks()) || !NoisePathSwapUnderWaterTagFeature.checkSurroundingBlocks(level, (class_2338)mutable, predicate) || !(random.method_43057() <= chance)) continue;
                    generated = true;
                    class_2680 setState = level.method_8316(mutable.method_10062().method_10084()).method_15767(class_3486.field_15517) ? config.underWaterState().method_23455(random, (class_2338)mutable) : config.state().method_23455(random, (class_2338)mutable);
                    level.method_8652((class_2338)mutable, setState, 3);
                    continue;
                }
                for (int y = by - config.radius(); y <= by + config.radius(); ++y) {
                    double distance = (bx - x) * (bx - x) + (bz - z) * (bz - z) + (by - y) * (by - y);
                    if (!(distance < (double)radiusSquared)) continue;
                    mutable.method_10103(x, y, z);
                    double sample = EasyNoiseSampler.sample(sampler, (class_2382)mutable, config.noiseScale(), config.scaleY(), config.useY());
                    if (!(sample > config.minThreshold()) || !(sample < config.maxThreshold()) || !level.method_8320((class_2338)mutable).method_26164(config.replaceableBlocks()) || !NoisePathSwapUnderWaterTagFeature.checkSurroundingBlocks(level, (class_2338)mutable, predicate) || !(random.method_43057() <= chance)) continue;
                    generated = true;
                    class_2680 setState = level.method_8316(mutable.method_10062().method_10084()).method_15767(class_3486.field_15517) ? config.underWaterState().method_23455(random, (class_2338)mutable) : config.state().method_23455(random, (class_2338)mutable);
                    level.method_8652((class_2338)mutable, setState, 3);
                }
            }
        }
        return generated;
    }

    private static boolean checkSurroundingBlocks(class_5281 level, class_2338 pos, class_6646 predicate) {
        for (class_2350 direction : class_2350.values()) {
            if (!predicate.test((Object)level, (Object)pos.method_10093(direction))) continue;
            return true;
        }
        return false;
    }
}

