/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.platform.EmiAgnos;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class EmiBookCloningRecipe
extends EmiPatternCraftingRecipe {
    private static final List<String> AUTHORS = List.of("Emi", "A Rabbit", "[REDACTED]", "Jeb", "The Multiversal Author's Guild", "Another Book", "A Collection of Branches", "Unknown");
    private static final List<String> MOD_AUTHORS = EmiAgnos.getAllModAuthors();
    private static final List<String> MOD = EmiAgnos.getAllModNames();
    private static final List<String> NOUN = List.of("Bunnies", "Apples", "Rocks", "Antimemetics", "a Rabbit", "Deers", "Mice", "a Dog", "Bnuuy", "Kitties", "Reconstruction", "Dawn", "Time", "Night", "the Sky", "Diamonds", "Pickaxes", "Planks", "Stone", "Slime", "Creepers", "Iron", "Redstone", "Trinkets", "Fungiculture", "Floralisia", "Chime", "Yttr", "Mnemonics", "Quilt");
    private static final List<String> OBJECT = Stream.concat(List.of("Fighting Monsters").stream(), NOUN.stream()).toList();
    private static final List<String> ADJECTIVE = List.of("Cool", "Introductory", "Diffused", "Wooden", "Slimey", "Dark", "Antimemetic", "Fun", "Fuzzy", "Tall", "Rotund", "Jovial", "");
    private static final List<String> IMPERATIVE = List.of("A Guide to", "Introduction to", "Discussing", "The Making of");
    private static final List<Template> TEMPLATES = List.of(Template.of(IMPERATIVE, ADJECTIVE, OBJECT), Template.of(ADJECTIVE, OBJECT, "101"), Template.of(IMPERATIVE, OBJECT), Template.of(NOUN, "and", NOUN), Template.of(NOUN, "1st Edition"), Template.of(IMPERATIVE, MOD));
    private static final EmiStack BOOK_AND_QUILL = EmiStack.of((class_1935)class_1802.field_8674);
    private static final EmiStack WRITTEN_BOOK = EmiStack.of((class_1935)class_1802.field_8360);

    public EmiBookCloningRecipe(class_2960 id) {
        super(List.of(WRITTEN_BOOK, BOOK_AND_QUILL), WRITTEN_BOOK.copy().setAmount(2L), id);
    }

    @Override
    public SlotWidget getInputWidget(int slot, int x, int y) {
        if (slot == 0) {
            return new GeneratedSlotWidget(r -> this.getWrittenBook((Random)r, false), this.unique, x, y);
        }
        if (slot == 1) {
            return new SlotWidget(BOOK_AND_QUILL, x, y);
        }
        return new SlotWidget(EmiStack.EMPTY, x, y);
    }

    @Override
    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(r -> this.getWrittenBook((Random)r, true), this.unique, x, y);
    }

    private EmiStack getWrittenBook(Random random, boolean copy) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8360);
        class_2487 tag = new class_2487();
        Object title = TEMPLATES.get(random.nextInt(TEMPLATES.size())).resolve(random);
        if (((String)title).length() > 0) {
            title = Character.toUpperCase(((String)title).charAt(0)) + ((String)title).substring(1, ((String)title).length());
        }
        tag.method_10582("title", (String)title);
        String author = random.nextInt(20) < 5 ? MOD_AUTHORS.get(random.nextInt(MOD_AUTHORS.size())) : AUTHORS.get(random.nextInt(AUTHORS.size()));
        tag.method_10582("author", author);
        tag.method_10569("generation", (copy ? 1 : 0) + random.nextInt(2));
        tag.method_10566("pages", (class_2520)new class_2499());
        stack.method_7980(tag);
        return EmiStack.of(stack);
    }

    public static class Template {
        private List<Object> parts;

        private Template(List<Object> parts) {
            this.parts = parts;
        }

        public static Template of(Object ... parts) {
            return new Template(Arrays.asList(parts));
        }

        public String resolve(Random random) {
            Object ret = this.resolvePart(random, this.parts.get(0));
            for (int i = 1; i < this.parts.size(); ++i) {
                ret = (String)ret + " " + this.resolvePart(random, this.parts.get(i));
            }
            return ret;
        }

        private String resolvePart(Random random, Object part) {
            if (part instanceof String) {
                String s = (String)part;
                return s;
            }
            if (part instanceof List) {
                List l = (List)part;
                return (String)l.get(random.nextInt(l.size()));
            }
            return "";
        }
    }
}

