/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.config.IDrawerConfig;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlock;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedSourceBlock;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.block.tile.util.FrameHelper;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackMatcher;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockStandardDrawers
extends BlockDrawers
implements IFramedSourceBlock {
    private String matKey = null;
    private String matNamespace = "storagedrawers";

    public BlockStandardDrawers(int drawerCount, boolean halfDepth, Supplier<IDrawerConfig> drawerConfig, class_4970.class_2251 properties) {
        super(drawerCount, halfDepth, drawerConfig, properties);
    }

    @Deprecated
    public BlockStandardDrawers(int drawerCount, boolean halfDepth, int storageUnits, class_4970.class_2251 properties) {
        super(drawerCount, halfDepth, storageUnits, properties);
    }

    @Deprecated
    public BlockStandardDrawers(int drawerCount, boolean halfDepth, class_4970.class_2251 properties) {
        super(drawerCount, halfDepth, BlockStandardDrawers.calcUnits(drawerCount, halfDepth), properties);
    }

    private static int calcUnits(int drawerCount, boolean halfDepth) {
        return halfDepth ? 4 / drawerCount : 8 / drawerCount;
    }

    public BlockStandardDrawers setMatKey(class_2960 material) {
        this.matNamespace = material.method_12836();
        this.matKey = material.method_12832();
        return this;
    }

    public BlockStandardDrawers setMatKey(@Nullable String matKey) {
        this.matKey = matKey;
        return this;
    }

    public String getMatKey() {
        return this.matKey;
    }

    public String getNameMatKey() {
        return "block." + this.matNamespace + ".mat." + this.matKey;
    }

    @Override
    protected int getFaceSlot(class_2350 correctSide, @NotNull class_243 normalizedHit) {
        if (!this.hitWithinArea(correctSide, normalizedHit, 0.0625f, 0.9375f)) {
            return super.getFaceSlot(correctSide, normalizedHit);
        }
        if (this.getDrawerCount() == 1) {
            return 0;
        }
        boolean hitTop = this.hitWithinY(normalizedHit, 0.5f, 1.0f);
        if (this.getDrawerCount() == 2) {
            return hitTop ? 0 : 1;
        }
        if (this.getDrawerCount() == 4) {
            if (this.hitWithinX(correctSide, normalizedHit, 0.0f, 0.5f)) {
                return hitTop ? 0 : 2;
            }
            return hitTop ? 1 : 3;
        }
        return super.getFaceSlot(correctSide, normalizedHit);
    }

    @Nullable
    public BlockEntityDrawers newBlockEntity(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return (BlockEntityDrawers)ModServices.RESOURCE_FACTORY.createBlockEntityDrawersStandard(this.getDrawerCount()).create(pos, state);
    }

    @Override
    public boolean retrimBlock(class_1937 world, class_2338 pos, class_1799 prototype) {
        if (this.retrimType() == null) {
            return false;
        }
        class_2248 protoBlock = class_2248.method_9503((class_1792)prototype.method_7909());
        if (!(protoBlock instanceof BlockTrim)) {
            return false;
        }
        BlockTrim trim = (BlockTrim)protoBlock;
        if (trim.getMatKey() == null || Objects.equals(trim.getMatKey(), "") || !trim.canUseForRetrim()) {
            return false;
        }
        List<BlockStandardDrawers> blockList = ModBlocks.getDrawersOfTypeAndSizeAndDepth(BlockStandardDrawers.class, this.getDrawerCount(), this.isHalfDepth()).filter(b -> b.getMatKey() == trim.getMatKey()).toList();
        if (blockList.size() != 1) {
            return false;
        }
        BlockStandardDrawers targetBlock = blockList.get(0);
        class_2586 entity = world.method_8321(pos);
        if (!(entity instanceof BlockEntityDrawersStandard)) {
            return false;
        }
        class_2680 curState = world.method_8320(pos);
        BlockEntityDrawersStandard curEntity = (BlockEntityDrawersStandard)entity;
        class_2487 entityData = curEntity.method_38244();
        class_2680 newState = (class_2680)targetBlock.method_9564().method_11657((class_2769)field_11177, (Comparable)((class_2350)curState.method_11654((class_2769)field_11177)));
        world.method_8501(pos, newState);
        class_2586 newEnt = world.method_8321(pos);
        newEnt.method_11014(entityData);
        return true;
    }

    @Override
    public boolean repartitionBlock(class_1937 world, class_2338 pos, class_1799 prototype) {
        if (this.retrimType() == null) {
            return false;
        }
        class_2248 protoBlock = class_2248.method_9503((class_1792)prototype.method_7909());
        if (!(protoBlock instanceof BlockStandardDrawers)) {
            return false;
        }
        BlockStandardDrawers targetBlock = (BlockStandardDrawers)protoBlock;
        if (targetBlock.isHalfDepth() != this.isHalfDepth()) {
            return false;
        }
        if (targetBlock.getDrawerCount() == this.getDrawerCount()) {
            return false;
        }
        class_2586 sourceEntity = world.method_8321(pos);
        if (!(sourceEntity instanceof BlockEntityDrawersStandard)) {
            return false;
        }
        BlockEntityDrawersStandard sourceBE = (BlockEntityDrawersStandard)sourceEntity;
        class_1799 firstStack = sourceBE.getGroup().getDrawer(0).getStoredItemPrototype();
        int aggCount = 0;
        for (int i = 0; i < sourceBE.getGroup().getDrawerCount(); ++i) {
            IDrawer drawer = sourceBE.getGroup().getDrawer(i);
            class_1799 stack = drawer.getStoredItemPrototype();
            if (firstStack.method_7960() && !stack.method_7960()) {
                firstStack = stack;
            }
            if (!ItemStackMatcher.areItemsEqual(firstStack, stack) && !stack.method_7960()) {
                return false;
            }
            aggCount += drawer.getStoredItemCount();
        }
        class_2680 curState = world.method_8320(pos);
        class_2487 entityData = sourceEntity.method_38244();
        class_2680 newState = (class_2680)targetBlock.method_9564().method_11657((class_2769)field_11177, (Comparable)((class_2350)curState.method_11654((class_2769)field_11177)));
        world.method_8501(pos, newState);
        class_2586 newEnt = world.method_8321(pos);
        newEnt.method_11014(entityData);
        BlockEntityDrawersStandard targetBE = (BlockEntityDrawersStandard)newEnt;
        int drawerCount = targetBE.getGroup().getDrawerCount();
        int divCount = aggCount / drawerCount;
        int remCount = aggCount - divCount * drawerCount;
        for (int i = 0; i < drawerCount; ++i) {
            int slotCount = divCount;
            if (i < remCount) {
                ++slotCount;
            }
            targetBE.getGroup().getDrawer(i).setStoredItem(firstStack, slotCount);
        }
        return true;
    }

    @Override
    public class_1799 makeFramedItem(class_1799 source, class_1799 matSide, class_1799 matTrim, class_1799 matFront) {
        IFramedBlock frameBlock;
        switch (this.getDrawerCount()) {
            case 1: {
                IFramedBlock iFramedBlock;
                if (this.isHalfDepth()) {
                    iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_HALF_DRAWERS_1.get();
                    break;
                }
                iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_FULL_DRAWERS_1.get();
                break;
            }
            case 2: {
                IFramedBlock iFramedBlock;
                if (this.isHalfDepth()) {
                    iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_HALF_DRAWERS_2.get();
                    break;
                }
                iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_FULL_DRAWERS_2.get();
                break;
            }
            case 4: {
                IFramedBlock iFramedBlock;
                if (this.isHalfDepth()) {
                    iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_HALF_DRAWERS_4.get();
                    break;
                }
                iFramedBlock = (IFramedBlock)ModBlocks.FRAMED_FULL_DRAWERS_4.get();
                break;
            }
            default: {
                IFramedBlock iFramedBlock = frameBlock = null;
            }
        }
        if (frameBlock == null) {
            return class_1799.field_8037;
        }
        return FrameHelper.makeFramedItem(frameBlock, source, matSide, matTrim, matFront);
    }
}

