/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.framing.IFramedBlockEntity;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IControlGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesGroupControl;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IProtectable;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.block.BlockSlave;
import com.jaquadro.minecraft.storagedrawers.block.tile.BaseBlockEntity;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntitySlave;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.ControllerHostData;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.MaterialData;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemRepository;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import com.jaquadro.minecraft.storagedrawers.storage.StorageUtil;
import com.jaquadro.minecraft.storagedrawers.util.ItemCollectionRegistry;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import com.mojang.authlib.GameProfile;
import com.texelsaurus.minecraft.chameleon.capabilities.ChameleonCapability;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

public class BlockEntityController
extends BaseBlockEntity
implements IDrawerGroup,
IControlGroup,
IFramedBlockEntity {
    private static final int PRI_LOCKED = 0;
    private static final int PRI_NORMAL = 1;
    private static final int PRI_LOCKED_VOID = 2;
    private static final int PRI_VOID = 3;
    private static final int PRI_EMPTY = 4;
    private static final int PRI_LOCKED_EMPTY = 5;
    private static final int PRI_DISABLED = 6;
    private final ControllerHostData controllerHostData = new ControllerHostData();
    private final MaterialData materialData = new MaterialData();
    private final Queue<class_2338> searchQueue = new LinkedList<class_2338>();
    private final Set<class_2338> searchDiscovered = new HashSet<class_2338>();
    private final Comparator<SlotRecord> slotRecordComparator = (o1, o2) -> {
        if (o1.priorityGroup != o2.priorityGroup) {
            return o2.priorityGroup - o1.priorityGroup;
        }
        return o1.priority - o2.priority;
    };
    private final Map<class_2338, StorageRecord> storage = new HashMap<class_2338, StorageRecord>();
    protected List<SlotRecord> drawerSlotList = new ArrayList<SlotRecord>();
    private final ItemCollectionRegistry<SlotRecord> drawerPrimaryLookup = new ItemCollectionRegistry();
    protected int[] drawerSlots = new int[0];
    private long lastUpdateTime;
    private long lastClickTime;
    private UUID lastClickUUID;
    private final ItemRepository itemRepository = new ItemRepository(this);

    @Override
    public MaterialData material() {
        return this.materialData;
    }

    private IDrawerAttributes getAttributes(Object obj) {
        IDrawerAttributes attrs = EmptyDrawerAttributes.EMPTY;
        if (obj instanceof IDrawerGroup) {
            IDrawerGroup dg = (IDrawerGroup)obj;
            attrs = dg.getCapability(Capabilities.DRAWER_ATTRIBUTES);
        }
        if (attrs == null) {
            attrs = EmptyDrawerAttributes.EMPTY;
        }
        return attrs;
    }

    private int getSlotPriorityGroup(SlotRecord record) {
        IDrawerGroup group = this.getGroupForSlotRecord(record);
        IDrawerAttributes attrs = this.getAttributes(group);
        return attrs.getPriority();
    }

    private int getSlotPriority(SlotRecord record) {
        IDrawerGroup group = this.getGroupForSlotRecord(record);
        if (group == null) {
            return 6;
        }
        int drawerSlot = record.slot;
        IDrawer drawer = group.getDrawer(drawerSlot);
        if (!drawer.isEnabled()) {
            return 6;
        }
        IDrawerAttributes attrs = this.getAttributes(group);
        if (drawer.isEmpty()) {
            if (attrs.isItemLocked(LockAttribute.LOCK_EMPTY)) {
                return 5;
            }
            return 4;
        }
        if (attrs.isVoid()) {
            if (attrs.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                return 2;
            }
            return 3;
        }
        if (attrs.isItemLocked(LockAttribute.LOCK_POPULATED)) {
            return 0;
        }
        return 1;
    }

    protected BlockEntityController(class_2591<?> blockEntityType, class_2338 pos, class_2680 state) {
        super(blockEntityType, pos, state);
        this.injectPortableData(this.controllerHostData);
        this.injectPortableData(this.materialData);
    }

    public BlockEntityController(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlockEntities.CONTROLLER.get(), pos, state);
    }

    public BlockController getBlock() {
        if (this.method_10997() == null) {
            return null;
        }
        class_2248 block = this.method_10997().method_8320(this.method_11016()).method_26204();
        if (block instanceof BlockController) {
            BlockController blockController = (BlockController)block;
            return blockController;
        }
        return null;
    }

    public void printDebugInfo() {
        ModServices.log.info("Controller at " + this.field_11867);
        ModServices.log.info("  Range: " + ModCommonConfig.INSTANCE.CONTROLLER.controllerRange.get() + " blocks");
        ModServices.log.info("  Stored records: " + this.storage.size() + ", slot list: " + this.drawerSlots.length);
        ModServices.log.info("  Ticks since last update: " + (Serializable)(this.method_10997() == null ? "null" : Long.valueOf(this.method_10997().method_8510() - this.lastUpdateTime)));
    }

    @Override
    public IDrawerGroup getDrawerGroup() {
        return this;
    }

    @Override
    public IDrawerAttributesGroupControl getGroupControllableAttributes(class_1657 player) {
        return new GroupAttributeController(player);
    }

    @Override
    public IControlGroup getBoundControlGroup() {
        return null;
    }

    @Override
    public List<INetworked> getBoundRemoteNodes() {
        return this.controllerHostData.getRemoteNodes().toList();
    }

    @Override
    public void validateRemoteNode(INetworked node) {
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("Controller [{}] validating node [{}]", (Object)this.field_11867, (Object)node);
        }
        this.controllerHostData.validateRemoteNode(this, node);
    }

    @Override
    public void invalidateRemoteNode(INetworked node) {
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("Controller [{}] invalidating node [{}]", (Object)this.field_11867, (Object)node);
        }
        this.controllerHostData.removeRemoteNode(this, node);
    }

    @Override
    public boolean addRemoteNode(INetworked node) {
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("Controller [{}] add remote node [{}]", (Object)this.field_11867, (Object)node);
        }
        return this.controllerHostData.addRemoteNode(this, node);
    }

    public void method_11012() {
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("controller [{}] setRemoved", (Object)this.field_11867);
        }
        super.method_11012();
        if (this.method_10997() == null || this.method_10997().field_9236) {
            return;
        }
        for (INetworked node : this.getBoundRemoteNodes()) {
            if (!(node instanceof class_2586)) continue;
            class_2586 blockEntity = (class_2586)node;
            class_2338 pos = blockEntity.method_11016();
            try {
                if (!this.method_10997().method_8477(pos)) continue;
                node.scheduleValidation();
                this.method_10997().method_39279(pos, blockEntity.method_11010().method_26204(), 1);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean isSoftBindingValid(class_2338 pos, IDrawerGroup node) {
        if (this.method_11015()) {
            return false;
        }
        StorageRecord record = this.storage.get(pos);
        if (record == null) {
            return false;
        }
        return record.storage == node;
    }

    public void onEntityLoad() {
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("controller [{}] onEntityLoad", (Object)this.field_11867);
        }
        if (this.method_10997() == null || this.method_10997().field_9236) {
            return;
        }
        class_2338 pos = this.method_11016();
        try {
            if (!this.method_10997().method_8397().method_8674(pos, (Object)this.method_11010().method_26204())) {
                this.method_10997().method_39279(pos, this.method_11010().method_26204(), 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isGroupValid() {
        return !this.method_11015();
    }

    public int interactPutItemsIntoInventory(class_1657 player) {
        int count;
        block3: {
            block2: {
                if (this.method_10997() == null) {
                    return 0;
                }
                boolean dumpInventory = this.method_10997().method_8510() - this.lastClickTime < 10L && player.method_5667().equals(this.lastClickUUID);
                count = 0;
                if (dumpInventory) break block2;
                class_1799 currentStack = player.method_31548().method_7391();
                if (currentStack.method_7960()) break block3;
                count = this.insertItems(currentStack, player);
                if (currentStack.method_7947() != 0) break block3;
                player.method_31548().method_5447(player.method_31548().field_7545, class_1799.field_8037);
                break block3;
            }
            int n = 36;
            for (int i = 0; i < n; ++i) {
                class_1799 subStack = player.method_31548().method_5438(i);
                if (subStack.method_7960()) continue;
                count += this.insertItems(subStack, player);
                if (subStack.method_7947() != 0) continue;
                player.method_31548().method_5447(i, class_1799.field_8037);
            }
        }
        this.lastClickTime = this.method_10997().method_8510();
        this.lastClickUUID = player.method_5667();
        return count;
    }

    protected int insertItems(@NotNull class_1799 stack, class_1657 player) {
        int remainder = new ProtectedItemRepository(this, player).insertItem(stack, false).method_7947();
        int added = stack.method_7947() - remainder;
        stack.method_7939(remainder);
        return added;
    }

    private Stream<IDrawerAttributesModifiable> getSlotsValidAttributes(class_1657 player) {
        return this.storage.values().stream().map(record -> {
            if (record.storage == null) {
                return null;
            }
            if (record.storage instanceof IProtectable && !SecurityManager.hasAccess(player, (IProtectable)((Object)record.storage))) {
                return null;
            }
            IDrawerAttributes attrs = this.getAttributes(record.storage);
            if (attrs instanceof IDrawerAttributesModifiable) {
                IDrawerAttributesModifiable mattrs = (IDrawerAttributesModifiable)attrs;
                return mattrs;
            }
            return null;
        }).filter(Objects::nonNull);
    }

    public void toggleProtection(GameProfile profile, ISecurityProvider provider) {
        IProtectable template = null;
        UUID state = null;
        for (StorageRecord record : this.storage.values()) {
            IProtectable protectable;
            IDrawerGroup iDrawerGroup;
            if (record.storage == null || !((iDrawerGroup = record.storage) instanceof IProtectable) || !SecurityManager.hasOwnership(profile, protectable = (IProtectable)((Object)iDrawerGroup))) continue;
            if (template == null) {
                template = protectable;
                if (template.getOwner() == null) {
                    state = profile.getId();
                } else {
                    provider = null;
                }
            }
            protectable.setOwner(state);
            protectable.setSecurityProvider(provider);
        }
    }

    public void clearProtection() {
        for (StorageRecord record : this.storage.values()) {
            IDrawerGroup iDrawerGroup;
            if (record.storage == null || !((iDrawerGroup = record.storage) instanceof IProtectable)) continue;
            IProtectable protectable = (IProtectable)((Object)iDrawerGroup);
            protectable.setOwner(null);
            protectable.setSecurityProvider(null);
        }
    }

    protected void resetCache() {
        this.storage.clear();
        this.drawerSlotList.clear();
    }

    public boolean isValidIO(class_2338 coord) {
        StorageRecord record = this.storage.get(coord);
        if (record == null || !record.mark) {
            return false;
        }
        return record.storage == null;
    }

    public void updateCache() {
        if (this.method_10997() == null) {
            return;
        }
        this.lastUpdateTime = this.method_10997().method_8510();
        int preCount = this.drawerSlots.length;
        this.resetCache();
        this.populateNodes();
        this.flattenLists();
        this.drawerSlots = this.sortSlotRecords(this.drawerSlotList);
        this.rebuildPrimaryLookup(this.drawerPrimaryLookup, this.drawerSlotList);
        if (!(preCount == this.drawerSlots.length || preCount != 0 && this.drawerSlots.length != 0 || this.method_10997().field_9236)) {
            this.method_5431();
        }
    }

    private void indexSlotRecords(List<SlotRecord> records) {
        int n = records.size();
        for (int i = 0; i < n; ++i) {
            SlotRecord record = records.get(i);
            if (record == null) continue;
            record.index = i;
            record.priority = this.getSlotPriority(record);
            record.priorityGroup = this.getSlotPriorityGroup(record);
        }
    }

    private int[] sortSlotRecords(List<SlotRecord> records) {
        this.indexSlotRecords(records);
        ArrayList<SlotRecord> copied = new ArrayList<SlotRecord>(records);
        copied.sort(this.slotRecordComparator);
        int[] slotMap = new int[copied.size()];
        for (int i = 0; i < slotMap.length; ++i) {
            slotMap[i] = ((SlotRecord)copied.get((int)i)).index;
        }
        return slotMap;
    }

    private void rebuildPrimaryLookup(ItemCollectionRegistry<SlotRecord> lookup, List<SlotRecord> records) {
        lookup.clear();
        for (SlotRecord record : records) {
            int drawerSlot;
            IDrawer drawer;
            IDrawerGroup group = this.getGroupForSlotRecord(record);
            if (group == null || !(drawer = group.getDrawer(drawerSlot = record.slot)).isEnabled() || drawer.isEmpty()) continue;
            class_1799 item = drawer.getStoredItemPrototype();
            lookup.register(item.method_7909(), record);
        }
    }

    private boolean containsNullEntries(List<SlotRecord> list) {
        int nullCount = 0;
        for (SlotRecord aList : list) {
            if (aList != null) continue;
            ++nullCount;
        }
        return nullCount > 0;
    }

    private void flattenLists() {
        if (this.containsNullEntries(this.drawerSlotList)) {
            ArrayList<SlotRecord> newDrawerSlotList = new ArrayList<SlotRecord>();
            for (SlotRecord record : this.drawerSlotList) {
                if (record == null) continue;
                newDrawerSlotList.add(record);
            }
            this.drawerSlotList = newDrawerSlotList;
        }
    }

    private void clearRecordInfo(class_2338 coord, StorageRecord record) {
        record.clear();
        for (int i = 0; i < this.drawerSlotList.size(); ++i) {
            SlotRecord slotRecord = this.drawerSlotList.get(i);
            if (slotRecord == null || !coord.equals((Object)slotRecord.coord)) continue;
            this.drawerSlotList.set(i, null);
        }
    }

    private void updateRecordInfo(class_2338 coord, StorageRecord record, class_2586 blockEntity) {
        if (blockEntity == null) {
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            return;
        }
        if (blockEntity instanceof BlockEntityController) {
            if (record.storage == null && record.invStorageSize > 0) {
                return;
            }
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            record.storage = null;
        } else if (blockEntity instanceof BlockEntitySlave) {
            if (record.storage == null && record.invStorageSize == 0 && ((BlockEntitySlave)blockEntity).getController() == this) {
                return;
            }
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            record.storage = null;
            ((BlockEntitySlave)blockEntity).bindController(this.method_11016());
        } else if (blockEntity instanceof BlockEntityDrawers) {
            BlockEntityDrawers blockEntityDrawers = (BlockEntityDrawers)blockEntity;
            IDrawerGroup group = ((BlockEntityDrawers)blockEntity).getGroup();
            if (record.storage == group) {
                return;
            }
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            record.storage = group;
            record.drawerStorageSize = group.getDrawerCount();
            blockEntityDrawers.softBindControlGroup(this);
            int n = record.drawerStorageSize;
            for (int i = 0; i < n; ++i) {
                this.drawerSlotList.add(new SlotRecord(group, coord, i));
            }
        } else {
            IDrawerGroup group = Capabilities.DRAWER_GROUP.getCapability(this.field_11863, blockEntity.method_11016());
            if (record.storage == group) {
                return;
            }
            if (record.storage != null) {
                this.clearRecordInfo(coord, record);
            }
            if (group == null) {
                return;
            }
            record.storage = group;
            record.drawerStorageSize = group.getDrawerCount();
            if (group instanceof INetworked) {
                INetworked netGroup = (INetworked)((Object)group);
                netGroup.softBindControlGroup(this);
            }
            int n = record.drawerStorageSize;
            for (int i = 0; i < n; ++i) {
                this.drawerSlotList.add(new SlotRecord(group, coord, i));
            }
        }
    }

    private void populateNodes() {
        if (this.method_10997() == null) {
            return;
        }
        this.searchQueue.clear();
        this.searchDiscovered.clear();
        if (!this.method_10997().field_9236) {
            this.controllerHostData.validateRemoteNodes(this, this.field_11863);
        }
        int globalRange = (Integer)ModCommonConfig.INSTANCE.CONTROLLER.controllerRange.get();
        int confRemoteRange = (Integer)ModCommonConfig.INSTANCE.UPGRADES.remoteUpgrade.maxRange.get();
        int confRemoteGroupRange = (Integer)ModCommonConfig.INSTANCE.UPGRADES.remoteUpgrade.maxGroupRange.get();
        int remoteRange = confRemoteRange > 0 ? Math.min(globalRange, confRemoteRange) : globalRange;
        int remoteGroupRange = confRemoteGroupRange > 0 ? Math.min(globalRange, confRemoteGroupRange) : globalRange;
        this.populateRoot(this.method_11016(), globalRange, true);
        this.getBoundRemoteNodes().forEach(n -> {
            if (n.getBoundControlGroup() == this && n instanceof class_2586) {
                class_2586 blockEntity = (class_2586)n;
                boolean recurse = n.canRecurseSearch();
                int range = recurse ? remoteGroupRange : remoteRange;
                this.populateRoot(blockEntity.method_11016(), range, recurse);
            }
        });
    }

    private void populateRoot(class_2338 root, int range, boolean recursiveSearch) {
        this.searchQueue.add(root);
        this.searchDiscovered.add(root);
        class_2338 origin = this.method_11016();
        while (!this.searchQueue.isEmpty()) {
            class_2338[] neighbors;
            INetworked networked;
            IControlGroup group;
            class_2248 block;
            class_2338 coord = this.searchQueue.remove();
            int depth = Math.max(Math.max(Math.abs(coord.method_10263() - origin.method_10263()), Math.abs(coord.method_10264() - origin.method_10264())), Math.abs(coord.method_10260() - origin.method_10260()));
            if (depth > range || !this.method_10997().method_8477(coord) || !((block = this.method_10997().method_8320(coord).method_26204()) instanceof INetworked) || (group = (networked = (INetworked)block).getBoundControlGroup()) != null && group != this) continue;
            StorageRecord record = this.storage.get(coord);
            if (record == null) {
                record = new StorageRecord();
                this.storage.put(coord, record);
            }
            if (block instanceof BlockSlave) {
                WorldUtils.getBlockEntity((class_1922)this.method_10997(), coord, BlockEntitySlave.class);
            }
            this.updateRecordInfo(coord, record, this.method_10997().method_8321(coord));
            record.mark = true;
            record.distance = depth;
            if (!recursiveSearch) continue;
            for (class_2338 n : neighbors = new class_2338[]{coord.method_10067(), coord.method_10078(), coord.method_10072(), coord.method_10095(), coord.method_10084(), coord.method_10074()}) {
                if (this.searchDiscovered.contains(n)) continue;
                this.searchQueue.add(n);
                this.searchDiscovered.add(n);
            }
        }
    }

    public IDrawerGroup getGroupForDrawerSlot(int drawerSlot) {
        if (drawerSlot < 0 || drawerSlot >= this.drawerSlotList.size()) {
            return null;
        }
        SlotRecord record = this.drawerSlotList.get(drawerSlot);
        if (record == null) {
            return null;
        }
        return this.getGroupForSlotRecord(record);
    }

    protected IDrawerGroup getGroupForSlotRecord(SlotRecord record) {
        class_2586 tile;
        IDrawerGroup group = record.group;
        if (group == null || !group.isGroupValid()) {
            return null;
        }
        if (group instanceof class_2586 && ((tile = (class_2586)group).method_11015() || !tile.method_11016().equals((Object)record.coord))) {
            record.group = null;
            return null;
        }
        return group;
    }

    private int getLocalDrawerSlot(int drawerSlot) {
        if (drawerSlot >= this.drawerSlotList.size()) {
            return 0;
        }
        SlotRecord record = this.drawerSlotList.get(drawerSlot);
        if (record == null) {
            return 0;
        }
        return record.slot;
    }

    @Override
    public void readFixed(class_2487 tag) {
        super.readFixed(tag);
        if (this.method_10997() != null && !this.method_10997().field_9236) {
            this.updateCache();
        }
    }

    @Override
    public boolean dataPacketRequiresRenderUpdate() {
        return true;
    }

    @Override
    public int getDrawerCount() {
        return this.drawerSlotList.size();
    }

    @Override
    @NotNull
    public IDrawer getDrawer(int slot) {
        IDrawerGroup group = this.getGroupForDrawerSlot(slot);
        if (group == null) {
            return Drawers.DISABLED;
        }
        return group.getDrawer(this.getLocalDrawerSlot(slot));
    }

    @Override
    public int[] getAccessibleDrawerSlots() {
        return this.drawerSlots;
    }

    public IItemRepository getItemRepository() {
        return this.itemRepository;
    }

    @Override
    public <T> T getCapability(ChameleonCapability<T> capability) {
        if (capability == null || this.field_11863 == null) {
            return null;
        }
        return capability.getCapability(this.field_11863, this.method_11016());
    }

    public Stream<IDrawer> getBalanceDrawers(@NotNull class_1799 stack, class_1657 player) {
        Collection<SlotRecord> primaryRecords = this.drawerPrimaryLookup.getEntries(stack.method_7909());
        if (primaryRecords == null) {
            return Stream.empty();
        }
        return primaryRecords.stream().map(r -> {
            IProtectable prot;
            IDrawerGroup candidateGroup = this.getGroupForSlotRecord((SlotRecord)r);
            if (candidateGroup == null) {
                return Drawers.DISABLED;
            }
            IDrawer drawer = candidateGroup.getDrawer(r.slot);
            if (drawer.isEmpty()) {
                return Drawers.DISABLED;
            }
            if (player != null && candidateGroup instanceof IProtectable && !SecurityManager.hasAccess(player, prot = (IProtectable)((Object)candidateGroup))) {
                return Drawers.DISABLED;
            }
            return drawer;
        }).filter(drawer -> {
            if (!drawer.isEnabled()) {
                return false;
            }
            IDrawerAttributes attr = drawer.getAttributes();
            if (!attr.isBalancedFill() || attr.isSuspended()) {
                return false;
            }
            return class_1799.method_31577((class_1799)stack, (class_1799)drawer.getStoredItemPrototype());
        });
    }

    protected static class SlotRecord
    implements Comparable<SlotRecord> {
        public class_2338 coord;
        public IDrawerGroup group;
        public int slot;
        public int index;
        public int priority;
        public int priorityGroup;

        public SlotRecord(IDrawerGroup group, class_2338 coord, int slot) {
            this.group = group;
            this.coord = coord;
            this.slot = slot;
        }

        @Override
        public int compareTo(SlotRecord other) {
            int diff = other.priorityGroup - this.priorityGroup;
            if (diff != 0) {
                return diff;
            }
            diff = this.priority - other.priority;
            if (diff != 0) {
                return diff;
            }
            diff = this.coord.method_10265((class_2382)other.coord);
            if (diff != 0) {
                return diff;
            }
            return this.index - other.index;
        }
    }

    private class ItemRepository
    extends DrawerItemRepository {
        public ItemRepository(IDrawerGroup group) {
            super(group);
        }

        @Override
        @NotNull
        public class_1799 insertItem(@NotNull class_1799 stack, boolean simulate, Predicate<class_1799> predicate) {
            Collection<SlotRecord> primaryRecords = BlockEntityController.this.drawerPrimaryLookup.getEntries(stack.method_7909());
            HashSet<Integer> checkedSlots = simulate ? new HashSet<Integer>() : null;
            ArrayList<IDrawer> rebalance = new ArrayList<IDrawer>();
            int amount = stack.method_7947();
            if (primaryRecords != null) {
                IDrawerAttributes attrs;
                IDrawer drawer;
                IDrawerGroup candidateGroup;
                for (SlotRecord record : primaryRecords) {
                    candidateGroup = BlockEntityController.this.getGroupForSlotRecord(record);
                    if (candidateGroup == null || (drawer = candidateGroup.getDrawer(record.slot)).isEmpty() || !this.testPredicateInsert(drawer, stack, predicate) || !this.hasAccess(candidateGroup, drawer) || (attrs = drawer.getAttributes()).isSuspended()) continue;
                    if (attrs.isBalancedFill()) {
                        rebalance.add(drawer);
                    }
                    if (amount == 0) continue;
                    int adjusted = Math.min(amount, drawer.getRemainingCapacity());
                    amount = simulate ? Math.max(amount - drawer.getRemainingCapacity(), 0) : amount - adjusted + drawer.adjustStoredItemCount(adjusted);
                    if (amount == 0 || !simulate) continue;
                    checkedSlots.add(record.index);
                }
                if (amount > 0) {
                    for (SlotRecord record : primaryRecords) {
                        candidateGroup = BlockEntityController.this.getGroupForSlotRecord(record);
                        if (candidateGroup == null || (drawer = candidateGroup.getDrawer(record.slot)).isEmpty() || !this.testPredicateInsert(drawer, stack, predicate) || !this.hasAccess(candidateGroup, drawer) || (attrs = drawer.getAttributes()).isSuspended()) continue;
                        int n = amount = simulate ? Math.max(amount - drawer.getAcceptingRemainingCapacity(), 0) : drawer.adjustStoredItemCount(amount);
                        if (!simulate) continue;
                        checkedSlots.add(record.index);
                    }
                }
            }
            if (amount > 0) {
                for (Iterator<SlotRecord> slot : (Iterator<SlotRecord>)BlockEntityController.this.drawerSlots) {
                    IDrawerAttributes attrs;
                    IDrawerGroup group;
                    IDrawer drawer = BlockEntityController.this.getDrawer((int)slot);
                    if (!drawer.isEnabled() || !this.testPredicateInsert(drawer, stack, predicate) || !this.hasAccess(group = BlockEntityController.this.getGroupForDrawerSlot((int)slot), drawer) || (attrs = drawer.getAttributes()).isSuspended() || simulate && checkedSlots.contains(Integer.valueOf(slot))) continue;
                    boolean empty = drawer.isEmpty();
                    if (empty && !simulate) {
                        drawer = drawer.setStoredItem(stack);
                    }
                    int n = simulate ? Math.max(amount - (empty ? drawer.getAcceptingMaxCapacity(stack) : drawer.getAcceptingRemainingCapacity()), 0) : (amount = drawer.adjustStoredItemCount(amount));
                    if (amount == 0) break;
                }
            }
            if (!rebalance.isEmpty()) {
                StorageUtil.rebalanceDrawers(rebalance.stream());
            }
            return amount == 0 ? class_1799.field_8037 : this.stackResult(stack, amount);
        }

        @Override
        @NotNull
        public class_1799 extractItem(@NotNull class_1799 stack, int amount, boolean simulate, Predicate<class_1799> predicate) {
            Collection<SlotRecord> primaryRecords = BlockEntityController.this.drawerPrimaryLookup.getEntries(stack.method_7909());
            HashSet<Integer> checkedSlots = simulate ? new HashSet<Integer>() : null;
            ArrayList<IDrawer> rebalance = new ArrayList<IDrawer>();
            int remaining = amount;
            if (primaryRecords != null) {
                for (SlotRecord record : primaryRecords) {
                    IDrawerAttributes attrs;
                    IDrawer drawer;
                    IDrawerGroup candidateGroup = BlockEntityController.this.getGroupForSlotRecord(record);
                    if (candidateGroup == null || !(drawer = candidateGroup.getDrawer(record.slot)).isEnabled() || !this.testPredicateExtract(drawer, stack, predicate) || !this.hasAccess(candidateGroup, drawer) || (attrs = drawer.getAttributes()).isSuspended()) continue;
                    if (attrs.isBalancedFill()) {
                        rebalance.add(drawer);
                    }
                    if (remaining == 0) continue;
                    int n = remaining = simulate ? Math.max(remaining - drawer.getStoredItemCount(), 0) : drawer.adjustStoredItemCount(-remaining);
                    if (!simulate) continue;
                    checkedSlots.add(record.index);
                }
            }
            if (remaining > 0) {
                for (Object slot : (Object)BlockEntityController.this.drawerSlots) {
                    IDrawerAttributes attrs;
                    IDrawerGroup group;
                    IDrawer drawer = BlockEntityController.this.getDrawer((int)slot);
                    if (!drawer.isEnabled() || !this.testPredicateExtract(drawer, stack, predicate) || !this.hasAccess(group = BlockEntityController.this.getGroupForDrawerSlot((int)slot), drawer) || (attrs = drawer.getAttributes()).isSuspended() || simulate && checkedSlots.contains((int)slot)) continue;
                    int n = remaining = simulate ? Math.max(remaining - drawer.getStoredItemCount(), 0) : drawer.adjustStoredItemCount(-remaining);
                    if (remaining != 0) continue;
                    return this.stackResult(stack, amount);
                }
                if (!rebalance.isEmpty()) {
                    StorageUtil.rebalanceDrawers(rebalance.stream());
                }
                return amount == remaining ? class_1799.field_8037 : this.stackResult(stack, amount - remaining);
            }
            return amount == remaining ? class_1799.field_8037 : this.stackResult(stack, amount - remaining);
        }

        protected boolean hasAccess(IDrawerGroup group, IDrawer drawer) {
            return true;
        }
    }

    private class GroupAttributeController
    implements IDrawerAttributesGroupControl {
        private class_1657 player = null;

        public GroupAttributeController() {
        }

        public GroupAttributeController(class_1657 player) {
            this.player = player;
        }

        @Override
        public boolean setIsConcealed(boolean state) {
            BlockEntityController.this.getSlotsValidAttributes(this.player).forEach(record -> record.setIsConcealed(state));
            return true;
        }

        @Override
        public boolean setIsShowingQuantity(boolean state) {
            BlockEntityController.this.getSlotsValidAttributes(this.player).forEach(record -> record.setIsShowingQuantity(state));
            return true;
        }

        @Override
        public boolean setIsSuspended(boolean state) {
            BlockEntityController.this.getSlotsValidAttributes(this.player).forEach(record -> record.setIsSuspended(state));
            return true;
        }

        @Override
        public boolean setItemLocked(EnumSet<LockAttribute> attributes, LockAttribute attr, boolean isLocked) {
            BlockEntityController.this.getSlotsValidAttributes(this.player).forEach(record -> {
                for (LockAttribute a : attributes) {
                    record.setItemLocked(a, isLocked);
                }
            });
            return true;
        }

        @Override
        public boolean toggleConcealed() {
            BlockEntityController.this.getSlotsValidAttributes(this.player).findFirst().ifPresent(template -> this.setIsConcealed(!template.isConcealed()));
            return true;
        }

        @Override
        public boolean toggleIsShowingQuantity() {
            BlockEntityController.this.getSlotsValidAttributes(this.player).findFirst().ifPresent(template -> this.setIsShowingQuantity(!template.isShowingQuantity()));
            return true;
        }

        @Override
        public boolean toggleIsSuspended() {
            BlockEntityController.this.getSlotsValidAttributes(this.player).findFirst().ifPresent(template -> this.setIsSuspended(!template.isSuspended()));
            return true;
        }

        @Override
        public boolean toggleItemLocked(EnumSet<LockAttribute> attributes, LockAttribute attr) {
            BlockEntityController.this.getSlotsValidAttributes(this.player).findFirst().ifPresent(template -> this.setItemLocked(attributes, attr, !template.isItemLocked(attr)));
            return true;
        }
    }

    private static class StorageRecord {
        public IDrawerGroup storage;
        public boolean mark;
        public int invStorageSize;
        public int drawerStorageSize;
        public int distance = Integer.MAX_VALUE;

        private StorageRecord() {
        }

        public void clear() {
            this.storage = null;
            this.mark = false;
            this.invStorageSize = 0;
            this.drawerStorageSize = 0;
            this.distance = Integer.MAX_VALUE;
        }
    }

    private class ProtectedItemRepository
    extends ItemRepository {
        private final class_1657 player;

        public ProtectedItemRepository(IDrawerGroup group, class_1657 player) {
            super(group);
            this.player = player;
        }

        @Override
        protected boolean hasAccess(IDrawerGroup group, IDrawer drawer) {
            if (drawer.isEmpty()) {
                return false;
            }
            if (group instanceof IProtectable) {
                return SecurityManager.hasAccess(this.player, (IProtectable)((Object)group));
            }
            return true;
        }
    }
}

