/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.storage.IControlGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.BlockEntityDataShim;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;

public class ControllerHostData
extends BlockEntityDataShim {
    private Map<class_2338, INetworked> nodeMap = new HashMap<class_2338, INetworked>();

    @Override
    public void read(class_2487 tag) {
        this.nodeMap.clear();
        if (tag.method_10573("RemoteNodes", 9)) {
            class_2499 list = tag.method_10554("RemoteNodes", 10);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 ctag = list.method_10602(i);
                this.nodeMap.put(new class_2338(ctag.method_10550("x"), ctag.method_10550("y"), ctag.method_10550("z")), null);
            }
        }
    }

    @Override
    public class_2487 write(class_2487 tag) {
        class_2499 list = new class_2499();
        for (class_2338 pos : this.nodeMap.keySet()) {
            class_2487 ctag = new class_2487();
            ctag.method_10569("x", pos.method_10263());
            ctag.method_10569("y", pos.method_10264());
            ctag.method_10569("z", pos.method_10260());
            list.add((Object)ctag);
        }
        tag.method_10566("RemoteNodes", (class_2520)list);
        return tag;
    }

    public void validateRemoteNodes(IControlGroup host, class_1937 level) {
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("controllerHostData [{}, size={}] validate remote notes for host [{}]", (Object)this, (Object)this.nodeMap.size(), (Object)host);
        }
        Iterator<Map.Entry<class_2338, INetworked>> iterator = this.nodeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            INetworked networked;
            class_2338 pos = iterator.next().getKey();
            class_2586 entity = level.method_8321(pos);
            if (entity instanceof INetworked && (networked = (INetworked)entity).getBoundControlGroup() == host) {
                this.nodeMap.put(pos, networked);
                if (!((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) continue;
                ModServices.log.info("  put node [{} = {}]", (Object)pos, (Object)entity);
                continue;
            }
            iterator.remove();
            if (!((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) continue;
            ModServices.log.info("  remove node [{} = {}]", (Object)pos, (Object)entity);
        }
    }

    public void validateRemoteNode(IControlGroup host, INetworked node) {
        if (node == null) {
            return;
        }
        if (node instanceof class_2586) {
            class_2586 blockEntity = (class_2586)node;
            class_2338 pos = blockEntity.method_11016();
            if (node.getBoundControlGroup() == host) {
                this.nodeMap.put(pos, node);
                if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
                    ModServices.log.info("  put node [{} = {}]", (Object)pos, (Object)node);
                }
                return;
            }
            this.nodeMap.remove(pos);
        }
    }

    public boolean addRemoteNode(IControlGroup host, INetworked node) {
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("ControllerHostData [{}] add remote node [{}] for host [{}]", (Object)this, (Object)node, (Object)host);
        }
        if (node == null) {
            return false;
        }
        if (node instanceof class_2586) {
            class_2586 blockEntity = (class_2586)node;
            class_2338 pos = blockEntity.method_11016();
            if (node.getBoundControlGroup() == host) {
                this.nodeMap.put(pos, node);
                return true;
            }
            this.nodeMap.put(pos, null);
        }
        return false;
    }

    public boolean removeRemoteNode(IControlGroup host, INetworked node) {
        class_2586 blockEntity;
        class_2338 pos;
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.debugTrace.get()).booleanValue()) {
            ModServices.log.info("ControllerHostData [{}] remove node [{}] for host [{}]", (Object)this, (Object)node, (Object)host);
        }
        if (node == null) {
            return false;
        }
        if (node instanceof class_2586 && this.nodeMap.containsKey(pos = (blockEntity = (class_2586)node).method_11016())) {
            this.nodeMap.remove(pos);
            return true;
        }
        return false;
    }

    public Stream<INetworked> getRemoteNodes() {
        return this.nodeMap.values().stream().filter(Objects::nonNull);
    }
}

