/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class ConfigItemList {
    private final List<String> listedNamespaces = new ArrayList<String>();
    private final List<class_1792> listedItems = new ArrayList<class_1792>();
    private List<String> pendingRules = new ArrayList<String>();
    private boolean initialized;

    public void initialize() {
        this.initialized = true;
        this.innerInitialize();
        for (String rule : this.pendingRules) {
            this.register(rule);
        }
        this.pendingRules = null;
    }

    protected void innerInitialize() {
    }

    public boolean isListed(class_1799 stack) {
        String namespace;
        class_5321 resourceKey;
        class_1792 item = stack.method_7909();
        if (this.listedItems.contains(item)) {
            return true;
        }
        return !this.listedNamespaces.isEmpty() && (resourceKey = (class_5321)class_7923.field_41178.method_29113((Object)item).orElse(null)) != null && this.listedNamespaces.contains(namespace = resourceKey.method_29177().method_12836());
    }

    public boolean registerNamespace(@NotNull String namespace) {
        if (namespace.isEmpty()) {
            return false;
        }
        this.unregisterNamespace(namespace);
        this.listedNamespaces.add(namespace);
        this.logRegisterNamespace(namespace);
        return true;
    }

    protected void logRegisterNamespace(@NotNull String namespace) {
    }

    public boolean registerItem(@NotNull class_1799 item) {
        if (item.method_7960()) {
            return false;
        }
        this.unregisterItem(item);
        this.listedItems.add(item.method_7909());
        this.logRegisterItem(item);
        return true;
    }

    protected void logRegisterItem(@NotNull class_1799 item) {
    }

    public void register(List<String> entries) {
        entries.forEach(this::register);
    }

    public boolean register(String entry) {
        if (!this.initialized) {
            this.pendingRules.add(entry);
            return true;
        }
        String[] parts = entry.split("\\s*:\\s*");
        if (parts.length == 1) {
            return this.registerNamespace(parts[0]);
        }
        class_2960 resource = new class_2960(entry);
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(resource);
        return this.registerItem(new class_1799((class_1935)item));
    }

    public boolean unregisterNamespace(@NotNull String namespace) {
        if (namespace.isEmpty()) {
            return false;
        }
        return this.listedNamespaces.remove(namespace);
    }

    public boolean unregisterItem(@NotNull class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        return this.listedItems.remove(stack.method_7909());
    }
}

