/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.client.gui.StorageGuiGraphics;
import com.jaquadro.minecraft.storagedrawers.inventory.InventoryUpgrade;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotDrawer;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import com.texelsaurus.minecraft.chameleon.inventory.content.PositionContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerDrawers
extends class_1703 {
    private static final int InventoryX = 8;
    private static final int InventoryY = 117;
    private static final int HotbarY = 175;
    private static final int UpgradeX = 26;
    private static final int UpgradeY = 86;
    private final class_1263 upgradeInventory;
    private final List<class_1735> storageSlots;
    private final List<class_1735> upgradeSlots;
    private final List<class_1735> playerSlots;
    private final List<class_1735> hotbarSlots;
    public StorageGuiGraphics activeGuiGraphics;
    private final boolean isRemote;

    public ContainerDrawers(@Nullable class_3917<?> type, int windowId, class_1661 playerInv, Optional<PositionContent> content) {
        this(type, windowId, playerInv, PositionContent.getOrNull(content, playerInv.field_7546.method_37908(), BlockEntityDrawers.class));
    }

    protected static BlockEntityDrawers getBlockEntity(class_1661 playerInv, class_2338 pos) {
        class_1937 level = playerInv.field_7546.method_5770();
        BlockEntityDrawers blockEntity = WorldUtils.getBlockEntity((class_1922)level, pos, BlockEntityDrawers.class);
        if (blockEntity != null) {
            return blockEntity;
        }
        ModServices.log.error("Expected a drawers tile entity at " + pos);
        return null;
    }

    public ContainerDrawers(@Nullable class_3917<?> type, int windowId, class_1661 playerInventory, BlockEntityDrawers tileEntity) {
        super(type, windowId);
        int i;
        int drawerCount = 0;
        this.upgradeInventory = new InventoryUpgrade(tileEntity);
        class_2248 block = tileEntity.method_11010().method_26204();
        IDrawerGroup group = tileEntity.getGroup();
        if (block instanceof BlockDrawers) {
            drawerCount = ((BlockDrawers)block).getDrawerCount();
        }
        this.storageSlots = new ArrayList<class_1735>();
        for (i = 0; i < drawerCount; ++i) {
            if (!group.getDrawer(i).isEnabled() && !group.getDrawer(i).isMissing()) continue;
            this.storageSlots.add(this.method_7621(new SlotDrawer(this, group, i, this.getStorageSlotX(i), this.getStorageSlotY(i))));
        }
        this.upgradeSlots = new ArrayList<class_1735>();
        for (i = 0; i < 7; ++i) {
            this.upgradeSlots.add(this.method_7621(new SlotUpgrade(this.upgradeInventory, i, 26 + i * 18, 86)));
        }
        this.playerSlots = new ArrayList<class_1735>();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.playerSlots.add(this.method_7621(new class_1735((class_1263)playerInventory, j + i * 9 + 9, 8 + j * 18, 117 + i * 18)));
            }
        }
        this.hotbarSlots = new ArrayList<class_1735>();
        for (i = 0; i < 9; ++i) {
            this.hotbarSlots.add(this.method_7621(new class_1735((class_1263)playerInventory, i, 8 + i * 18, 175)));
        }
        this.isRemote = playerInventory.field_7546.method_5770().field_9236;
    }

    public void setLastAccessedItem(class_1799 stack) {
        if (this.isRemote && this.activeGuiGraphics != null) {
            this.activeGuiGraphics.overrideStack = stack;
        }
    }

    protected int getStorageSlotX(int slot) {
        return 0;
    }

    protected int getStorageSlotY(int slot) {
        return 0;
    }

    public List<class_1735> getStorageSlots() {
        return this.storageSlots;
    }

    public List<class_1735> getUpgradeSlots() {
        return this.upgradeSlots;
    }

    public int getStackCapacity() {
        class_1263 class_12632 = this.upgradeInventory;
        if (class_12632 instanceof InventoryUpgrade) {
            InventoryUpgrade inv = (InventoryUpgrade)class_12632;
            return inv.getStackCapacity();
        }
        return 1;
    }

    public boolean method_7597(@NotNull class_1657 player) {
        return this.upgradeInventory.method_5443(player);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public class_1799 method_7601(@NotNull class_1657 player, int slotIndex) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(slotIndex);
        int storageStart = this.storageSlots.get((int)0).field_7874;
        int storageEnd = this.storageSlots.get((int)(this.storageSlots.size() - 1)).field_7874 + 1;
        int upgradeStart = this.upgradeSlots.get((int)0).field_7874;
        int upgradeEnd = this.upgradeSlots.get((int)(this.upgradeSlots.size() - 1)).field_7874 + 1;
        int inventoryStart = this.playerSlots.get((int)0).field_7874;
        int hotbarStart = this.hotbarSlots.get((int)0).field_7874;
        int hotbarEnd = this.hotbarSlots.get((int)(this.hotbarSlots.size() - 1)).field_7874 + 1;
        if (slot.method_7681()) {
            class_1799 slotStack;
            block17: {
                slotStack = slot.method_7677();
                itemStack = slotStack.method_7972();
                if (slotIndex >= upgradeStart && slotIndex < upgradeEnd) {
                    if (!this.method_7616(slotStack, inventoryStart, hotbarEnd, true)) {
                        return class_1799.field_8037;
                    }
                    slot.method_7670(slotStack, itemStack);
                } else if (slotIndex >= inventoryStart && slotIndex < hotbarEnd && !slotStack.method_7960()) {
                    if (slotStack.method_7909() instanceof ItemUpgrade) {
                        class_1799 slotStack1 = slotStack.method_7972();
                        slotStack1.method_7939(1);
                        if (!this.method_7616(slotStack1, upgradeStart, upgradeEnd, false)) {
                            if (slotIndex < hotbarStart ? !this.method_7616(slotStack, hotbarStart, hotbarEnd, false) : !this.method_7616(slotStack, inventoryStart, hotbarStart, false)) {
                                return class_1799.field_8037;
                            }
                            break block17;
                        } else {
                            slotStack.method_7934(1);
                            if (slotStack.method_7947() == 0) {
                                slot.method_7673(class_1799.field_8037);
                            } else {
                                slot.method_7668();
                            }
                            slot.method_7667(player, slotStack);
                            return class_1799.field_8037;
                        }
                    }
                    if (slotIndex < hotbarStart ? !this.method_7616(slotStack, hotbarStart, hotbarEnd, false) : !this.method_7616(slotStack, inventoryStart, hotbarStart, false)) {
                        return class_1799.field_8037;
                    }
                } else if (!this.method_7616(slotStack, inventoryStart, hotbarEnd, false)) {
                    return class_1799.field_8037;
                }
            }
            int slotStackSize = slotStack.method_7947();
            if (slotStackSize == 0) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (slotStackSize == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, slotStack);
        }
        return itemStack;
    }
}

