/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.UpgradeData;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public class DrawerInventoryHelper {
    private static final Random RANDOM = new Random();

    public static void dropUpgradeItems(class_1937 level, class_2338 pos, UpgradeData upgrades) {
        for (int i = 0; i < upgrades.getSlotCount(); ++i) {
            class_1799 stack = upgrades.getUpgrade(i);
            if (!stack.method_7960() && stack.method_7909() != ModItems.CREATIVE_VENDING_UPGRADE.get()) {
                DrawerInventoryHelper.spawnItemStack(level, pos.method_10263(), pos.method_10264(), pos.method_10260(), stack);
            }
            upgrades.setUpgrade(i, class_1799.field_8037);
        }
    }

    public static void dropInventoryItems(class_1937 world, class_2338 pos, IDrawerGroup group) {
        int remainingStacks = (Integer)ModCommonConfig.INSTANCE.DRAWERS.storage.dropStackLimit.get();
        while (remainingStacks > 0) {
            int remainingStart = remainingStacks;
            for (int i = 0; i < group.getDrawerCount(); ++i) {
                IDrawer drawer = group.getDrawer(i);
                if (!drawer.isEnabled() || drawer.getStoredItemCount() == 0 || remainingStacks == 0) continue;
                class_1799 stack = drawer.getStoredItemPrototype().method_7972();
                int storedCount = drawer.getStoredItemCount();
                int stackLimit = stack.method_7914();
                int stackSize = Math.min(storedCount, stackLimit);
                stack.method_7939(stackSize);
                if (stack.method_7960()) continue;
                DrawerInventoryHelper.spawnItemStack(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), stack);
                drawer.adjustStoredItemCount(-stackSize);
                --remainingStacks;
            }
            if (remainingStart != remainingStacks) continue;
            break;
        }
    }

    private static void spawnItemStack(class_1937 world, double x, double y, double z, class_1799 stack) {
        float xOff = RANDOM.nextFloat() * 0.8f + 0.1f;
        float yOff = RANDOM.nextFloat() * 0.8f + 0.1f;
        float zOff = RANDOM.nextFloat() * 0.8f + 0.1f;
        while (!stack.method_7960()) {
            class_1542 entityitem = new class_1542(world, x + (double)xOff, y + (double)yOff, z + (double)zOff, stack.method_7971(RANDOM.nextInt(21) + 10));
            float velocity = 0.05f;
            entityitem.method_18800(RANDOM.nextGaussian() * (double)velocity, RANDOM.nextGaussian() * (double)velocity + (double)0.2f, RANDOM.nextGaussian() * (double)velocity);
            world.method_8649((class_1297)entityitem);
        }
    }
}

