/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.common.init;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fonnymunkey.simplehats.SimpleHats;
import fonnymunkey.simplehats.util.HatEntry;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1814;
import net.minecraft.class_2960;
import org.apache.logging.log4j.Level;

public class HatJson {
    private static List<HatEntry> hatList = new ArrayList<HatEntry>();
    private static final List<HatEntry> defaultHats = Arrays.asList(new HatEntry("babyturtle", class_1814.field_8904, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:splash", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("bandana", class_1814.field_8906, 5, 0, new HatEntry.HatDyeSettings(true, 0xF9FFFE)), new HatEntry("bandanargb", class_1814.field_8904, 5, 0), new HatEntry("baseballeaster", class_1814.field_8907, 5, 0, HatEntry.HatSeason.EASTER), new HatEntry("baseballhat", class_1814.field_8906, 5, 1, new HatEntry.HatDyeSettings(true, 0xF9FFFE)), new HatEntry("baseballhatfestive", class_1814.field_8903, 5, 0, HatEntry.HatSeason.FESTIVE), new HatEntry("baseballhatjuly", class_1814.field_8907, 5, 0, HatEntry.HatSeason.SUMMER), new HatEntry("baseballhatrgb", class_1814.field_8904, 5, 0), new HatEntry("batwinghat", class_1814.field_8904, 5, 0, HatEntry.HatSeason.HALLOWEEN), new HatEntry("beanie", class_1814.field_8906, 5, 0, new HatEntry.HatDyeSettings(true, 0xF9FFFE)), new HatEntry("beanieeaster", class_1814.field_8907, 5, 0, HatEntry.HatSeason.EASTER), new HatEntry("beaniefestive", class_1814.field_8907, 5, 0, HatEntry.HatSeason.FESTIVE), new HatEntry("beaniejuly", class_1814.field_8907, 5, 0, HatEntry.HatSeason.SUMMER), new HatEntry("beaniergb", class_1814.field_8904, 5, 0), new HatEntry("beaniespooky", class_1814.field_8907, 5, 0, HatEntry.HatSeason.HALLOWEEN), new HatEntry("beehat", class_1814.field_8904, 5, 2, new HatEntry.HatParticleSettings(true, "minecraft:falling_honey", 0.02f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("bicorne", class_1814.field_8906, 5, 0), new HatEntry("bigbrain", class_1814.field_8906, 5, 0), new HatEntry("bigcrown", class_1814.field_8907, 5, 0, new HatEntry.HatDyeSettings(true, 0xF9FFFE)), new HatEntry("bigeyes", class_1814.field_8906, 5, 0), new HatEntry("bigribbon", class_1814.field_8907, 5, 1, new HatEntry.HatDyeSettings(true, 0xF9FFFE)), new HatEntry("bigstevehead", class_1814.field_8907, 5, 0), new HatEntry("bluefireeye", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:soul_fire_flame", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FEET)), new HatEntry("bowler", class_1814.field_8906, 5, 0, new HatEntry.HatDyeSettings(true, 0xF9FFFE)), new HatEntry("breadhat", class_1814.field_8907, 5, 0), new HatEntry("brownbrick", class_1814.field_8906, 5, 0), new HatEntry("bunnyhat", class_1814.field_8903, 5, 0, HatEntry.HatSeason.EASTER), new HatEntry("burgerhat", class_1814.field_8906, 5, 0), new HatEntry("caddycap", class_1814.field_8906, 5, 0, new HatEntry.HatDyeSettings(true, 0xF9FFFE)), new HatEntry("camera", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:flash", 0.002f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("camerabeard", class_1814.field_8907, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:flash", 0.002f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("candleonhead", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:small_flame", 0.03f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("candycane", class_1814.field_8907, 5, 0, HatEntry.HatSeason.FESTIVE), new HatEntry("carrotonstick", class_1814.field_8907, 5, 0), new HatEntry("cartoonegg", class_1814.field_8906, 5, 0), new HatEntry("cheeseslice", class_1814.field_8906, 5, 0), new HatEntry("chefshat", class_1814.field_8906, 5, 0), new HatEntry("chickenhead", class_1814.field_8906, 5, 0), new HatEntry("chickenonhead", class_1814.field_8907, 5, 0), new HatEntry("christmascakehat", class_1814.field_8904, 5, 0, HatEntry.HatSeason.FESTIVE), new HatEntry("christmastree", class_1814.field_8904, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:snowflake", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FULL), HatEntry.HatSeason.FESTIVE), new HatEntry("clockface", class_1814.field_8903, 5, 0), new HatEntry("cowboy", class_1814.field_8906, 5, 0, new HatEntry.HatDyeSettings(true, 0xF9FFFE)), new HatEntry("cowboyrgb", class_1814.field_8904, 5, 0), new HatEntry("crabonhead", class_1814.field_8904, 5, 0), new HatEntry("crown", class_1814.field_8906, 5, 0), new HatEntry("cuphead", class_1814.field_8907, 5, 0), new HatEntry("cyclopseye", class_1814.field_8906, 5, 0), new HatEntry("dairyqueen", class_1814.field_8906, 5, 0), new HatEntry("dangereqsue", class_1814.field_8906, 5, 0), new HatEntry("dangeresquejuly", class_1814.field_8907, 5, 0, HatEntry.HatSeason.SUMMER), new HatEntry("demoneyes", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:crimson_spore", 0.05f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("demonhorns", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:lava", 0.03f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FEET)), new HatEntry("digger", class_1814.field_8903, 5, 0), new HatEntry("dimmahat", class_1814.field_8907, 5, 0), new HatEntry("discoball", class_1814.field_8904, 5, 0), new HatEntry("disguise", class_1814.field_8907, 5, 0), new HatEntry("doctorhat", class_1814.field_8907, 5, 0), new HatEntry("dorkglassesandteeth", class_1814.field_8907, 5, 0), new HatEntry("doubletake", class_1814.field_8906, 5, 0), new HatEntry("dragonhead", class_1814.field_8907, 5, 0, new HatEntry.HatDyeSettings(true, 0xF9FFFE), new HatEntry.HatParticleSettings(true, "minecraft:small_flame", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FEET)), new HatEntry("dragonskull", class_1814.field_8907, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:ash", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("dragonskullender", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:dragon_breath", 0.05f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FULL)), new HatEntry("drinkinhat", class_1814.field_8907, 5, 0, new HatEntry.HatDyeSettings(true, 0xF9FFFE)), new HatEntry("dumhat", class_1814.field_8907, 5, 0), new HatEntry("dwarfminerbeard", class_1814.field_8907, 5, 2), new HatEntry("easterhead", class_1814.field_8907, 5, 0), new HatEntry("egghead", class_1814.field_8904, 5, 1, new HatEntry.HatDyeSettings(true, 0xF9FFFE), HatEntry.HatSeason.EASTER), new HatEntry("eggonhead", class_1814.field_8903, 5, 1, HatEntry.HatSeason.EASTER), new HatEntry("elfhat", class_1814.field_8906, 5, 0), new HatEntry("explorerhat", class_1814.field_8906, 5, 0), new HatEntry("eyepatch", class_1814.field_8906, 5, 0), new HatEntry("fakeblight", class_1814.field_8904, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:entity_effect", 0.05f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FULL)), new HatEntry("fakefire", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:flame", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FULL)), new HatEntry("farmerbrim", class_1814.field_8907, 5, 0, new HatEntry.HatDyeSettings(true, 0x787878), HatEntry.HatSeason.EASTER), new HatEntry("festiveantlers", class_1814.field_8904, 5, 0, HatEntry.HatSeason.FESTIVE), new HatEntry("festiveribbon", class_1814.field_8903, 5, 0, new HatEntry.HatDyeSettings(true, 0xF9FFFE), HatEntry.HatSeason.FESTIVE), new HatEntry("finnhood", class_1814.field_8907, 5, 0), new HatEntry("fireworks", class_1814.field_8904, 5, 0, new HatEntry.HatDyeSettings(true, 0xF9FFFE), new HatEntry.HatParticleSettings(true, "minecraft:firework", 0.02f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD), HatEntry.HatSeason.SUMMER), new HatEntry("fishonhead", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:splash", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("flagjuly", class_1814.field_8903, 5, 0, HatEntry.HatSeason.SUMMER), new HatEntry("flies", class_1814.field_8907, 5, 0), new HatEntry("floatinghearts", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:heart", 0.02f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("floatingstar", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:electric_spark", 0.03f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("flowercrown", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:spore_blossom_air", 0.02f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("floweronhead", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:spore_blossom_air", 0.02f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("foxhat", class_1814.field_8903, 5, 1, new HatEntry.HatDyeSettings(true, 0xF9FFFE)), new HatEntry("fro", class_1814.field_8906, 5, 0, new HatEntry.HatDyeSettings(true, 0xF9FFFE)), new HatEntry("frozenhead", class_1814.field_8907, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:snowflake", 0.05f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FULL)), new HatEntry("fullironhelm", class_1814.field_8907, 5, 3), new HatEntry("ghostmask", class_1814.field_8904, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:soul", 0.05f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD), HatEntry.HatSeason.HALLOWEEN), new HatEntry("goggles", class_1814.field_8906, 5, 0), new HatEntry("grandmadisguise", class_1814.field_8906, 5, 0), new HatEntry("greenbirb", class_1814.field_8904, 5, 0), new HatEntry("grinchhat", class_1814.field_8907, 5, 0, HatEntry.HatSeason.FESTIVE), new HatEntry("halo", class_1814.field_8906, 5, 0), new HatEntry("headbolts", class_1814.field_8907, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:electric_spark", 0.03f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD), HatEntry.HatSeason.HALLOWEEN), new HatEntry("headphonesblue", class_1814.field_8904, 5, 3, new HatEntry.HatParticleSettings(true, "minecraft:note", 0.01f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("headshot", class_1814.field_8906, 5, 0), new HatEntry("hockeymask", class_1814.field_8903, 5, 0, HatEntry.HatSeason.HALLOWEEN), new HatEntry("holyhead", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:glow", 0.02f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("horsemask", class_1814.field_8906, 5, 0), new HatEntry("hosthat", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:crimson_spore", 0.02f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FULL)), new HatEntry("icedragonskull", class_1814.field_8907, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:snowflake", 0.04f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("jackohat", class_1814.field_8904, 5, 0, HatEntry.HatSeason.HALLOWEEN), new HatEntry("jesterhat", class_1814.field_8907, 5, 0), new HatEntry("julydouble", class_1814.field_8903, 5, 2, HatEntry.HatSeason.SUMMER), new HatEntry("kirbymouthful", class_1814.field_8904, 5, 0), new HatEntry("largehorns", class_1814.field_8906, 5, 1), new HatEntry("lilbow", class_1814.field_8906, 5, 0, new HatEntry.HatDyeSettings(true, 0xF9FFFE)), new HatEntry("madscientist", class_1814.field_8903, 5, 0), new HatEntry("magikarp", class_1814.field_8904, 5, 1), new HatEntry("megamanhat", class_1814.field_8907, 5, 0), new HatEntry("mistletoe", class_1814.field_8903, 5, 0, HatEntry.HatSeason.FESTIVE), new HatEntry("mohawk", class_1814.field_8906, 5, 0), new HatEntry("monkeyking", class_1814.field_8907, 5, 0), new HatEntry("monocle", class_1814.field_8907, 5, 0), new HatEntry("moreeyes", class_1814.field_8907, 5, 0), new HatEntry("murdered", class_1814.field_8903, 5, 0, HatEntry.HatSeason.HALLOWEEN), new HatEntry("nekoears", class_1814.field_8906, 5, 0), new HatEntry("palmtree", class_1814.field_8904, 5, 0, HatEntry.HatSeason.SUMMER), new HatEntry("paperbag", class_1814.field_8906, 5, 0), new HatEntry("partyhat", class_1814.field_8906, 5, 0, new HatEntry.HatDyeSettings(true, 0xF9FFFE)), new HatEntry("paypay", class_1814.field_8903, 5, 1), new HatEntry("penguinbaby", class_1814.field_8903, 5, 0), new HatEntry("penguinhat", class_1814.field_8907, 5, 0), new HatEntry("pighead", class_1814.field_8906, 5, 0), new HatEntry("pinhead", class_1814.field_8903, 5, 0, HatEntry.HatSeason.HALLOWEEN), new HatEntry("plaguedoctor", class_1814.field_8907, 5, 0, new HatEntry.HatDyeSettings(true, 0xF9FFFE), HatEntry.HatSeason.HALLOWEEN), new HatEntry("pog", class_1814.field_8906, 5, 0), new HatEntry("pohatoe", class_1814.field_8904, 5, 0), new HatEntry("policebucket", class_1814.field_8906, 5, 0), new HatEntry("policesiren", class_1814.field_8903, 5, 0), new HatEntry("poofballhat", class_1814.field_8906, 5, 0, new HatEntry.HatDyeSettings(true, 0xF9FFFE)), new HatEntry("poofballrgb", class_1814.field_8904, 5, 0), new HatEntry("popehat", class_1814.field_8906, 5, 0), new HatEntry("potionhead", class_1814.field_8904, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:entity_effect", 0.05f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FULL)), new HatEntry("presentsstack", class_1814.field_8904, 5, 0, HatEntry.HatSeason.FESTIVE), new HatEntry("propelhat", class_1814.field_8903, 5, 0), new HatEntry("questbook", class_1814.field_8907, 5, 0), new HatEntry("rabbitears", class_1814.field_8903, 5, 0, HatEntry.HatSeason.EASTER), new HatEntry("rabbitonhead", class_1814.field_8903, 5, 0), new HatEntry("rainboworbiters", class_1814.field_8904, 5, 0), new HatEntry("ranahat", class_1814.field_8906, 5, 0), new HatEntry("redeyes", class_1814.field_8903, 5, 0), new HatEntry("rednose", class_1814.field_8907, 5, 0, HatEntry.HatSeason.FESTIVE), new HatEntry("redstache", class_1814.field_8907, 5, 1), new HatEntry("rgbbigribbon", class_1814.field_8904, 5, 0), new HatEntry("rgbbowler", class_1814.field_8904, 5, 0), new HatEntry("rgbdragonskull", class_1814.field_8904, 5, 0), new HatEntry("rgbdrinkinhat", class_1814.field_8904, 5, 0, new HatEntry.HatDyeSettings(true, 0xF9FFFE)), new HatEntry("rgbeasterhead", class_1814.field_8904, 5, 0), new HatEntry("rgbfullhelm", class_1814.field_8904, 5, 0), new HatEntry("rgbpartyhat", class_1814.field_8904, 5, 0), new HatEntry("rgbsmallbowler", class_1814.field_8904, 5, 0), new HatEntry("rgbsunglasses", class_1814.field_8904, 5, 0), new HatEntry("rgbtoptophathat", class_1814.field_8904, 5, 0), new HatEntry("rgbushanka", class_1814.field_8904, 5, 0), new HatEntry("rock", class_1814.field_8907, 5, 0), new HatEntry("rubbernipple", class_1814.field_8906, 5, 0), new HatEntry("sandcastle", class_1814.field_8904, 5, 0, HatEntry.HatSeason.SUMMER), new HatEntry("santaclaus", class_1814.field_8903, 5, 1, HatEntry.HatSeason.FESTIVE), new HatEntry("sausage", class_1814.field_8906, 5, 0), new HatEntry("seaweedhat", class_1814.field_8903, 5, 0, HatEntry.HatSeason.SUMMER), new HatEntry("shakehat", class_1814.field_8907, 5, 0), new HatEntry("sheep", class_1814.field_8906, 5, 0), new HatEntry("shrekears", class_1814.field_8907, 5, 0), new HatEntry("shroomcap", class_1814.field_8907, 5, 1, new HatEntry.HatParticleSettings(true, "minecraft:mycelium", 0.08f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FULL)), new HatEntry("simsgem", class_1814.field_8903, 5, 0), new HatEntry("smokingpipe", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:smoke", 0.02f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("snowmanbaby", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:snowflake", 0.04f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("sombrero", class_1814.field_8906, 5, 0, new HatEntry.HatDyeSettings(true, 0xF9FFFE)), new HatEntry("sonichood", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:electric_spark", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FEET)), new HatEntry("spadesoldier", class_1814.field_8903, 5, 0), new HatEntry("spiderweb", class_1814.field_8907, 5, 0, HatEntry.HatSeason.HALLOWEEN), new HatEntry("springer", class_1814.field_8907, 5, 0), new HatEntry("sprout", class_1814.field_8906, 5, 0), new HatEntry("spyzombie", class_1814.field_8907, 5, 0), new HatEntry("stackofeggs", class_1814.field_8904, 5, 0, HatEntry.HatSeason.EASTER), new HatEntry("stress", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:warped_spore", 0.02f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("summerhat", class_1814.field_8906, 5, 0, new HatEntry.HatDyeSettings(true, 11330558)), new HatEntry("sunglasses", class_1814.field_8903, 5, 0), new HatEntry("sunglassesbig", class_1814.field_8903, 5, 1), new HatEntry("supersandhat", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:electric_spark", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FULL)), new HatEntry("swimmer", class_1814.field_8906, 5, 0), new HatEntry("tinkerhat", class_1814.field_8907, 5, 0), new HatEntry("topcathat", class_1814.field_8903, 5, 0), new HatEntry("tophat", class_1814.field_8906, 5, 0, new HatEntry.HatDyeSettings(true, 0xF9FFFE)), new HatEntry("toptophathat", class_1814.field_8907, 5, 0, new HatEntry.HatDyeSettings(true, 0xF9FFFE)), new HatEntry("triangleshades", class_1814.field_8906, 5, 0), new HatEntry("tricorne", class_1814.field_8906, 5, 0), new HatEntry("tvhead", class_1814.field_8904, 5, 2), new HatEntry("unicornhorn", class_1814.field_8907, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:glow", 0.02f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("ushanka", class_1814.field_8906, 5, 0), new HatEntry("vikinghatbeard", class_1814.field_8903, 5, 2), new HatEntry("villagernose", class_1814.field_8906, 5, 0), new HatEntry("winghat", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:cloud", 0.03f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("zigzagwitchhat", class_1814.field_8903, 5, 0, new HatEntry.HatDyeSettings(true, 0xF9FFFE), new HatEntry.HatParticleSettings(true, "minecraft:witch", 0.04f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FULL), HatEntry.HatSeason.HALLOWEEN), new HatEntry("acornhat", class_1814.field_8906, 5, 0), new HatEntry("aegishat", class_1814.field_8903, 5, 0), new HatEntry("alienphil", class_1814.field_8903, 5, 0), new HatEntry("amalgalichhat", class_1814.field_8904, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:portal", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FULL)), new HatEntry("angrymask", class_1814.field_8907, 5, 0), new HatEntry("antlers", class_1814.field_8907, 5, 0), new HatEntry("apple", class_1814.field_8907, 5, 0), new HatEntry("artsy", class_1814.field_8904, 5, 0), new HatEntry("babydolphin", class_1814.field_8904, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:dolphin", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("artsy_doll", class_1814.field_8904, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:glow", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FULL)), new HatEntry("azumanga_hat", class_1814.field_8903, 5, 0), new HatEntry("beret_ribbon", class_1814.field_8907, 5, 0), new HatEntry("bucket", class_1814.field_8906, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:falling_water", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("burning_m_bison", class_1814.field_8904, 5, 0), new HatEntry("chalk_stick", class_1814.field_8906, 5, 0), new HatEntry("chi_ears", class_1814.field_8907, 5, 0), new HatEntry("circular_glasses", class_1814.field_8906, 5, 0, new HatEntry.HatDyeSettings(true, 12763584)), new HatEntry("cucumbereyemask", class_1814.field_8906, 5, 0), new HatEntry("dejiko", class_1814.field_8903, 5, 0), new HatEntry("fez", class_1814.field_8906, 5, 0), new HatEntry("fishing_hat", class_1814.field_8904, 5, 0), new HatEntry("lightning_eyes", class_1814.field_8903, 5, 0, new HatEntry.HatDyeSettings(true, 0xFFFFFF)), new HatEntry("longfoxears", class_1814.field_8907, 5, 0, new HatEntry.HatDyeSettings(true, 12763584)), new HatEntry("milady_doll", class_1814.field_8903, 5, 0), new HatEntry("nyan_doll", class_1814.field_8904, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:entity_effect", 0.2f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FULL)), new HatEntry("orange_hat", class_1814.field_8907, 5, 0), new HatEntry("peppino", class_1814.field_8903, 5, 0, new HatEntry.HatDyeSettings(true, 0xFFFFFF)), new HatEntry("pom_moog", class_1814.field_8906, 5, 0), new HatEntry("puchiko", class_1814.field_8903, 5, 0), new HatEntry("rabi_en_rose", class_1814.field_8903, 5, 1), new HatEntry("raincloud", class_1814.field_8904, 5, 0), new HatEntry("scouter", class_1814.field_8906, 5, 0, new HatEntry.HatDyeSettings(true, 12763584)), new HatEntry("sleepeyemask", class_1814.field_8906, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:heart", 0.01f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("sport_sunglasses", class_1814.field_8907, 5, 0), new HatEntry("strawberry_hat", class_1814.field_8907, 5, 0), new HatEntry("teddy_bear", class_1814.field_8904, 5, 6), new HatEntry("the_noise", class_1814.field_8903, 5, 0), new HatEntry("toy_story_alien", class_1814.field_8907, 5, 0), new HatEntry("twilight_doll", class_1814.field_8904, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:enchant", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("worms_mine", class_1814.field_8907, 5, 0), new HatEntry("alien_antennae", class_1814.field_8906, 5, 0, new HatEntry.HatDyeSettings(true, 0x50FF50)), new HatEntry("angel_and_devil", class_1814.field_8904, 5, 0), new HatEntry("astronaut", class_1814.field_8906, 5, 0), new HatEntry("axolotl_on_head", class_1814.field_8904, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:dolphin", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("baby_crewmate", class_1814.field_8903, 5, 0, new HatEntry.HatDyeSettings(true, 16719360)), new HatEntry("bee_on_head", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:falling_honey", 0.02f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("beetle_on_head", class_1814.field_8907, 5, 0), new HatEntry("binky", class_1814.field_8906, 5, 0, new HatEntry.HatDyeSettings(true, 36095)), new HatEntry("cardboard_box", class_1814.field_8906, 5, 0), new HatEntry("cat_hat", class_1814.field_8907, 5, 0, new HatEntry.HatDyeSettings(true, 0xFFA000)), new HatEntry("cat_on_head", class_1814.field_8903, 5, 0, new HatEntry.HatDyeSettings(true, 16743680)), new HatEntry("caterpillar_on_head", class_1814.field_8903, 5, 0), new HatEntry("chocolate_sauced", class_1814.field_8903, 5, 0), new HatEntry("crystal_horns", class_1814.field_8904, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:glow", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("dipper", class_1814.field_8907, 5, 0), new HatEntry("druid_antlers", class_1814.field_8907, 5, 0, new HatEntry.HatDyeSettings(true, 5299200)), new HatEntry("druid_antlers_rare", class_1814.field_8904, 5, 0, new HatEntry.HatDyeSettings(true, 5299200), new HatEntry.HatParticleSettings(true, "minecraft:spore_blossom_air", 0.05f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("eevee_ears", class_1814.field_8907, 5, 0), new HatEntry("eyeholder_beeholder", class_1814.field_8904, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:falling_honey", 0.04f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("eyeholder_dark", class_1814.field_8907, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:soul_fire_flame", 0.05f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("eyeholder_evil", class_1814.field_8907, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:portal", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("eyeholder_warm", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:lava", 0.03f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("eyeholder_xanath", class_1814.field_8904, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:enchant", 0.2f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("gnome", class_1814.field_8906, 5, 0, new HatEntry.HatDyeSettings(true, 65280)), new HatEntry("gnome_clover_wig", class_1814.field_8907, 5, 1), new HatEntry("greaser", class_1814.field_8907, 5, 0), new HatEntry("hat_of_discipline", class_1814.field_8903, 5, 0), new HatEntry("ladybug_on_head", class_1814.field_8907, 5, 0), new HatEntry("lil_bows", class_1814.field_8903, 5, 0), new HatEntry("lil_termagant", class_1814.field_8904, 5, 0), new HatEntry("medusa", class_1814.field_8903, 5, 0), new HatEntry("mimic_head", class_1814.field_8907, 5, 0), new HatEntry("mimic_head_dark", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:soul", 0.05f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("mimic_head_gold", class_1814.field_8904, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:electric_spark", 0.05f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("mindflayer", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:glow", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FULL)), new HatEntry("mindflayer_alhoon", class_1814.field_8904, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:enchant", 0.2f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FULL)), new HatEntry("octodad", class_1814.field_8904, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:splash", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FULL)), new HatEntry("pika_ears", class_1814.field_8907, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:electric_spark", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_FULL)), new HatEntry("right_hand_hat", class_1814.field_8906, 5, 1), new HatEntry("round_purple_wig", class_1814.field_8906, 5, 1), new HatEntry("round_red_wig", class_1814.field_8906, 5, 1), new HatEntry("slime_cube_dnd", class_1814.field_8904, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:soul", 0.05f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("slime_head", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:spore_blossom_air", 0.04f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("stinkycheeseman", class_1814.field_8904, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:mycelium", 0.12f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("stuck_lollipop", class_1814.field_8906, 5, 0), new HatEntry("tanuki_leaf", class_1814.field_8907, 5, 0), new HatEntry("the_noisier", class_1814.field_8904, 5, 0), new HatEntry("thumbnail", class_1814.field_8904, 5, 0), new HatEntry("tick_on_head", class_1814.field_8906, 5, 0), new HatEntry("toast", class_1814.field_8906, 5, 0), new HatEntry("toilet", class_1814.field_8903, 5, 0, new HatEntry.HatParticleSettings(true, "minecraft:splash", 0.1f, HatEntry.HatParticleSettings.HatParticleMovement.TRAILING_HEAD)), new HatEntry("tomato_splats", class_1814.field_8904, 5, 0), new HatEntry("traffic_cone", class_1814.field_8903, 5, 0), new HatEntry("udder_hat", class_1814.field_8906, 5, 0), new HatEntry("worm_hat", class_1814.field_8906, 5, 0));

    public static List<HatEntry> getHatList() {
        return hatList;
    }

    public static void registerHatJson() {
        try {
            File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "simplehats.json");
            if (!file.exists()) {
                SimpleHats.logger.log(Level.INFO, "SimpleHats simplehats.json not found, generating default file.");
                file.createNewFile();
                file.setWritable(true);
                JsonObject dataJson = new JsonObject();
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                for (HatEntry entry : defaultHats) {
                    JsonElement element = gson.toJsonTree((Object)entry);
                    dataJson.add(entry.getHatName(), element);
                }
                String dataString = gson.toJson((JsonElement)dataJson);
                PrintWriter writer = new PrintWriter(file);
                writer.write(dataString);
                writer.flush();
                writer.close();
                hatList = defaultHats;
                SimpleHats.logger.log(Level.INFO, "Loaded " + hatList.size() + " hat entries from default file.");
            } else {
                file.setWritable(true);
                String fileString = Files.asCharSource((File)file, (Charset)Charset.defaultCharset()).read();
                JsonObject json = JsonParser.parseString((String)fileString).getAsJsonObject();
                Gson gson = new Gson();
                block3: for (Map.Entry entry : json.entrySet()) {
                    JsonElement dataElement = (JsonElement)entry.getValue();
                    HatEntry hatEntry = (HatEntry)gson.fromJson(dataElement, HatEntry.class);
                    if (hatEntry.getHatName().isEmpty()) {
                        SimpleHats.logger.log(Level.WARN, "Attempted to load empty hat name, skipping.");
                        continue;
                    }
                    if (!HatJson.validateName(hatEntry.getHatName())) {
                        SimpleHats.logger.log(Level.WARN, "Attempted to load invalid hat name \"" + hatEntry.getHatName() + "\", skipping.");
                        continue;
                    }
                    for (HatEntry temp : hatList) {
                        if (!temp.getHatName().equalsIgnoreCase(hatEntry.getHatName()) && !hatEntry.getHatName().equalsIgnoreCase("special")) continue;
                        SimpleHats.logger.log(Level.WARN, "Attempted to load duplicate hat name \"" + hatEntry.getHatName() + "\", skipping.");
                        continue block3;
                    }
                    hatEntry.validateDeserializedEntry();
                    hatList.add(hatEntry);
                }
                SimpleHats.logger.log(Level.INFO, "Loaded " + hatList.size() + " hat entries from simplehats.json");
            }
        }
        catch (Exception ex) {
            SimpleHats.logger.log(Level.ERROR, "Loading simplehats.json failed: " + String.valueOf(ex));
        }
    }

    private static boolean validateName(String name) {
        for (char c : name.toCharArray()) {
            if (class_2960.method_12831((char)c)) continue;
            return false;
        }
        return true;
    }
}

