/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.client.render.PrintoutRenderer;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.media.PrintoutMenu;
import dan200.computercraft.shared.media.items.PrintoutItem;
import java.util.Arrays;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_465;
import net.minecraft.class_636;

@Environment(value=EnvType.CLIENT)
public final class PrintoutScreen
extends class_465<PrintoutMenu>
implements class_1712 {
    private PrintoutInfo printout = PrintoutInfo.DEFAULT;
    private int page = 0;

    public PrintoutScreen(PrintoutMenu container, class_1661 player, class_2561 title) {
        super((class_1703)container, player, title);
        this.field_2779 = 209;
    }

    private void setPrintout(class_1799 stack) {
        String[] text = PrintoutItem.getText(stack);
        TextBuffer[] textBuffers = new TextBuffer[text.length];
        for (int i = 0; i < textBuffers.length; ++i) {
            textBuffers[i] = new TextBuffer(text[i]);
        }
        String[] colours = PrintoutItem.getColours(stack);
        TextBuffer[] colourBuffers = new TextBuffer[colours.length];
        for (int i = 0; i < colours.length; ++i) {
            colourBuffers[i] = new TextBuffer(colours[i]);
        }
        int pages = Math.max(text.length / 21, 1);
        boolean book = stack.method_31574((class_1792)ModRegistry.Items.PRINTED_BOOK.get());
        this.printout = new PrintoutInfo(pages, book, textBuffers, colourBuffers);
    }

    protected void method_25426() {
        super.method_25426();
        ((PrintoutMenu)this.field_2797).method_7596(this);
    }

    public void method_25432() {
        ((PrintoutMenu)this.field_2797).method_7603(this);
    }

    public void method_7635(class_1703 menu, int slot, class_1799 stack) {
        if (slot == 0) {
            this.setPrintout(stack);
        }
    }

    public void method_7633(class_1703 menu, int slot, int data) {
        if (slot == 0) {
            this.page = data;
        }
    }

    private void setPage(int page) {
        this.page = page;
        class_636 gameMode = Objects.requireNonNull(Objects.requireNonNull(this.field_22787).field_1761);
        gameMode.method_2900(((PrintoutMenu)this.field_2797).field_7763, 100 + page);
    }

    private void previousPage() {
        if (this.page > 0) {
            this.setPage(this.page - 1);
        }
    }

    private void nextPage() {
        if (this.page < this.printout.pages() - 1) {
            this.setPage(this.page + 1);
        }
    }

    public boolean method_25404(int key, int scancode, int modifiers) {
        if (key == 262) {
            this.nextPage();
            return true;
        }
        if (key == 263) {
            this.previousPage();
            return true;
        }
        return super.method_25404(key, scancode, modifiers);
    }

    public boolean method_25401(double x, double y, double delta) {
        if (super.method_25401(x, y, delta)) {
            return true;
        }
        if (delta < 0.0) {
            this.nextPage();
            return true;
        }
        if (delta > 0.0) {
            this.previousPage();
            return true;
        }
        return false;
    }

    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        class_4597.class_4598 renderer = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        PrintoutRenderer.drawBorder(graphics.method_51448(), (class_4597)renderer, this.field_2776, this.field_2800, 0.0f, this.page, this.printout.pages(), this.printout.book(), 0xF000F0);
        PrintoutRenderer.drawText(graphics.method_51448(), (class_4597)renderer, this.field_2776 + 13, this.field_2800 + 11, 21 * this.page, 0xF000F0, this.printout.text(), this.printout.colour());
        renderer.method_22993();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416(0.0f, 0.0f, -1.0f);
        this.method_25420(graphics);
        graphics.method_51448().method_22909();
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
    }

    @Environment(value=EnvType.CLIENT)
    record PrintoutInfo(int pages, boolean book, TextBuffer[] text, TextBuffer[] colour) {
        public static final PrintoutInfo DEFAULT;

        static {
            Object[] textLines = new TextBuffer[21];
            Arrays.fill(textLines, new TextBuffer(" ".repeat(25)));
            Object[] colourLines = new TextBuffer[21];
            Arrays.fill(colourLines, new TextBuffer("f".repeat(25)));
            DEFAULT = new PrintoutInfo(1, false, (TextBuffer[])textLines, (TextBuffer[])colourLines);
        }
    }
}

