/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic.methods;

import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.util.ArgumentHelpers;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheral;
import dan200.computercraft.shared.peripheral.generic.methods.AbstractInventoryMethods;
import dan200.computercraft.shared.platform.ContainerTransfer;
import dan200.computercraft.shared.platform.FabricContainerTransfer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedSlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jspecify.annotations.Nullable;

public final class InventoryMethods
extends AbstractInventoryMethods<StorageWrapper> {
    @Override
    @LuaFunction(mainThread=true)
    public int size(StorageWrapper inventory) {
        return inventory.storage().getSlots().size();
    }

    @Override
    @LuaFunction(mainThread=true)
    public Map<Integer, Map<String, ?>> list(StorageWrapper inventory) {
        HashMap result = new HashMap();
        List slots = inventory.storage().getSlots();
        int size = slots.size();
        for (int i = 0; i < size; ++i) {
            class_1799 stack = InventoryMethods.toStack((SingleSlotStorage<ItemVariant>)((SingleSlotStorage)slots.get(i)));
            if (stack.method_7960()) continue;
            result.put(i + 1, VanillaDetailRegistries.ITEM_STACK.getBasicDetails(stack));
        }
        return result;
    }

    @Override
    @LuaFunction(mainThread=true)
    public @Nullable Map<String, ?> getItemDetail(StorageWrapper inventory, int slot) throws LuaException {
        ArgumentHelpers.assertBetween(slot, 1, inventory.storage().getSlotCount(), "Slot out of range (%s)");
        class_1799 stack = InventoryMethods.toStack((SingleSlotStorage<ItemVariant>)inventory.storage().getSlot(slot - 1));
        return stack.method_7960() ? null : VanillaDetailRegistries.ITEM_STACK.getDetails(stack);
    }

    @Override
    @LuaFunction(mainThread=true)
    public long getItemLimit(StorageWrapper inventory, int slot) throws LuaException {
        ArgumentHelpers.assertBetween(slot, 1, inventory.storage().getSlotCount(), "Slot out of range (%s)");
        return inventory.storage().getSlot(slot - 1).getCapacity();
    }

    @Override
    @LuaFunction(mainThread=true)
    public int pushItems(StorageWrapper from, IComputerAccess computer, String toName, int fromSlot, Optional<Integer> limit, Optional<Integer> toSlot) throws LuaException {
        IPeripheral location = computer.getAvailablePeripheral(toName);
        if (location == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        SlottedStorage<ItemVariant> to = InventoryMethods.extractHandler(location);
        if (to == null) {
            throw new LuaException("Target '" + toName + "' is not an inventory");
        }
        SlottedStorage<ItemVariant> fromStorage = from.storage();
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        ArgumentHelpers.assertBetween(fromSlot, 1, fromStorage.getSlotCount(), "From slot out of range (%s)");
        if (toSlot.isPresent()) {
            ArgumentHelpers.assertBetween(toSlot.get(), 1, to.getSlots().size(), "To slot out of range (%s)");
        }
        if (actualLimit <= 0) {
            return 0;
        }
        return InventoryMethods.moveItem(fromStorage, fromSlot - 1, to, toSlot.orElse(0) - 1, actualLimit);
    }

    @Override
    @LuaFunction(mainThread=true)
    public int pullItems(StorageWrapper to, IComputerAccess computer, String fromName, int fromSlot, Optional<Integer> limit, Optional<Integer> toSlot) throws LuaException {
        IPeripheral location = computer.getAvailablePeripheral(fromName);
        if (location == null) {
            throw new LuaException("Source '" + fromName + "' does not exist");
        }
        SlottedStorage<ItemVariant> toStorage = to.storage();
        SlottedStorage<ItemVariant> from = InventoryMethods.extractHandler(location);
        if (from == null) {
            throw new LuaException("Source '" + fromName + "' is not an inventory");
        }
        int actualLimit = limit.orElse(Integer.MAX_VALUE);
        ArgumentHelpers.assertBetween(fromSlot, 1, from.getSlots().size(), "From slot out of range (%s)");
        if (toSlot.isPresent()) {
            ArgumentHelpers.assertBetween(toSlot.get(), 1, toStorage.getSlotCount(), "To slot out of range (%s)");
        }
        if (actualLimit <= 0) {
            return 0;
        }
        return InventoryMethods.moveItem(from, fromSlot - 1, toStorage, toSlot.orElse(0) - 1, actualLimit);
    }

    public static @Nullable StorageWrapper extractContainer(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, @Nullable class_2350 direction) {
        SlottedStorage<ItemVariant> storage = InventoryMethods.extractContainerImpl(level, pos, state, blockEntity, direction);
        return storage == null ? null : new StorageWrapper(storage);
    }

    private static @Nullable SlottedStorage<ItemVariant> extractContainerImpl(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, @Nullable class_2350 direction) {
        Storage external;
        Storage internal = (Storage)ItemStorage.SIDED.find(level, pos, state, blockEntity, null);
        if (internal instanceof SlottedStorage) {
            SlottedStorage storage = (SlottedStorage)internal;
            return storage;
        }
        if (direction != null && (external = (Storage)ItemStorage.SIDED.find(level, pos, state, blockEntity, (Object)direction)) instanceof SlottedStorage) {
            SlottedStorage storage = (SlottedStorage)external;
            return storage;
        }
        return null;
    }

    private static @Nullable SlottedStorage<ItemVariant> extractHandler(IPeripheral peripheral) {
        class_2350 direction;
        Object object = peripheral.getTarget();
        if (peripheral instanceof GenericPeripheral) {
            GenericPeripheral sided = (GenericPeripheral)peripheral;
            v0 = sided.side();
        } else {
            v0 = direction = null;
        }
        if (object instanceof class_2586) {
            class_2586 blockEntity = (class_2586)object;
            if (blockEntity.method_11015()) {
                return null;
            }
            SlottedStorage<ItemVariant> found = InventoryMethods.extractContainerImpl(blockEntity.method_10997(), blockEntity.method_11016(), blockEntity.method_11010(), blockEntity, direction);
            if (found != null) {
                return found;
            }
        }
        return null;
    }

    private static int moveItem(SlottedStorage<ItemVariant> from, int fromSlot, SlottedStorage<ItemVariant> to, int toSlot, int limit) {
        ContainerTransfer fromWrapper = FabricContainerTransfer.of(from).singleSlot(fromSlot);
        ContainerTransfer.Slotted toWrapper = FabricContainerTransfer.of(to);
        return Math.max(0, fromWrapper.moveTo(toSlot >= 0 ? toWrapper.singleSlot(toSlot) : toWrapper, limit));
    }

    private static class_1799 toStack(SingleSlotStorage<ItemVariant> variant) {
        if (variant.isResourceBlank() || variant.getAmount() <= 0L) {
            return class_1799.field_8037;
        }
        return InventoryMethods.toStack((ItemVariant)variant.getResource(), variant.getAmount());
    }

    private static class_1799 toStack(ItemVariant variant, long amount) {
        return variant.toStack(amount >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)amount);
    }

    public record StorageWrapper(SlottedStorage<ItemVariant> storage) {
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StorageWrapper)) {
                return false;
            }
            StorageWrapper other = (StorageWrapper)obj;
            SlottedStorage<ItemVariant> otherStorage = other.storage;
            SlottedStorage<ItemVariant> slottedStorage = this.storage;
            if (slottedStorage instanceof CombinedSlottedStorage) {
                CombinedSlottedStorage cs = (CombinedSlottedStorage)slottedStorage;
                if (this.storage.getClass() == otherStorage.getClass() && cs.parts.equals(((CombinedStorage)otherStorage).parts)) {
                    return true;
                }
            }
            return this.storage.equals(otherStorage);
        }

        @Override
        public int hashCode() {
            int n;
            SlottedStorage<ItemVariant> slottedStorage = this.storage;
            if (slottedStorage instanceof CombinedSlottedStorage) {
                CombinedSlottedStorage cs = (CombinedSlottedStorage)slottedStorage;
                n = cs.parts.hashCode();
            } else {
                n = this.storage.hashCode();
            }
            return n;
        }
    }
}

