/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.hamsters.block;

import com.starfish_studios.hamsters.entity.Hamster;
import com.starfish_studios.hamsters.entity.SeatEntity;
import com.starfish_studios.hamsters.registry.HamstersBlockEntities;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class HamsterWheelBlock
extends class_2237
implements class_2343 {
    public static final class_2753 FACING = class_2741.field_12525;
    protected static final class_265 NORTH = class_2248.method_9541((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)16.0, (double)16.0);
    protected static final class_265 SOUTH = class_2248.method_9541((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)13.0);
    protected static final class_265 EAST = class_2248.method_9541((double)0.0, (double)0.0, (double)1.0, (double)13.0, (double)16.0, (double)15.0);
    protected static final class_265 WEST = class_2248.method_9541((double)3.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0);

    public HamsterWheelBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    public boolean isMountable(class_2680 state) {
        return true;
    }

    public class_2338 primaryDismountLocation(class_1937 level, class_2680 state, class_2338 pos) {
        return pos;
    }

    public float setRiderRotation(class_2680 state, class_1297 entity) {
        return entity.method_36454();
    }

    public static boolean isOccupied(class_1937 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        return !level.method_18467(SeatEntity.class, new class_238(pos)).isEmpty();
    }

    public float seatHeight(class_2680 state) {
        return 0.0f;
    }

    public static Optional<class_1297> getLeashed(class_1657 player) {
        List entities = player.method_37908().method_8333((class_1297)null, player.method_5829().method_1014(10.0), e -> true);
        for (class_1297 e2 : entities) {
            class_1308 mob;
            if (!(e2 instanceof class_1308) || (mob = (class_1308)e2).method_5933() != player || !HamsterWheelBlock.canBePickedUp(e2)) continue;
            return Optional.of(mob);
        }
        return Optional.empty();
    }

    public static boolean ejectSeatedExceptPlayer(class_1937 level, SeatEntity seatEntity) {
        List passengers = seatEntity.method_5685();
        if (passengers.isEmpty()) {
            return false;
        }
        if (!level.field_9236) {
            seatEntity.method_5772();
        }
        return true;
    }

    public static boolean canBePickedUp(class_1297 passenger) {
        if (passenger instanceof class_1657) {
            return false;
        }
        return passenger instanceof class_1309;
    }

    public static void sitDown(class_1937 level, class_2338 pos, class_1297 entity) {
        if (level.field_9236) {
            return;
        }
        if (entity == null) {
            return;
        }
        SeatEntity seat = new SeatEntity(level, pos);
        level.method_8649((class_1297)seat);
        entity.method_5804((class_1297)seat);
        level.method_8455(pos, level.method_8320(pos).method_26204());
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        return HamsterWheelBlock.isOccupied(level, pos) ? 15 : 0;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153());
    }

    @Nullable
    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return HamstersBlockEntities.HAMSTER_WHEEL.method_11032(blockPos, blockState);
    }

    public class_1269 method_9534(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        if (player.method_5998(interactionHand).method_7960() || !player.method_5998(interactionHand).method_7960() && !player.method_5715()) {
            class_1297 class_12972;
            if (!level.method_8505(player, blockPos)) {
                return class_1269.field_5811;
            }
            if (!this.isMountable(blockState) || player.method_5765() || player.method_18276()) {
                return class_1269.field_5811;
            }
            if (HamsterWheelBlock.isOccupied(level, blockPos)) {
                List seats = level.method_18467(SeatEntity.class, new class_238(blockPos));
                class_1297 class_12973 = ((SeatEntity)((Object)seats.get(0))).method_31483();
                if (class_12973 instanceof Hamster) {
                    Hamster hamster = (Hamster)class_12973;
                    hamster.setWaitTimeWhenRunningTicks(0);
                    hamster.setWaitTimeBeforeRunTicks(hamster.method_6051().method_43048(200) + 600);
                }
                if (HamsterWheelBlock.ejectSeatedExceptPlayer(level, (SeatEntity)((Object)seats.get(0)))) {
                    return class_1269.field_5812;
                }
                return class_1269.field_5811;
            }
            if (HamsterWheelBlock.getLeashed(player).isPresent() && (class_12972 = HamsterWheelBlock.getLeashed(player).get()) instanceof Hamster) {
                Hamster hamster = (Hamster)class_12972;
                hamster.setWaitTimeBeforeRunTicks(0);
                HamsterWheelBlock.sitDown(level, blockPos, (class_1297)hamster);
            }
            return class_1269.field_5812;
        }
        return super.method_9534(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch ((class_2350)state.method_11654((class_2769)FACING)) {
            case class_2350.field_11035 -> SOUTH;
            case class_2350.field_11034 -> EAST;
            case class_2350.field_11039 -> WEST;
            default -> NORTH;
        };
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return world.method_8320(pos.method_10074()).method_26206((class_1922)world, pos.method_10074(), class_2350.field_11036);
    }
}

