/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.capability.v2.data;

import fuzs.puzzleslib.api.capability.v2.data.CapabilityComponent;
import fuzs.puzzleslib.api.capability.v2.data.CapabilityKey;
import fuzs.puzzleslib.api.capability.v2.data.SyncStrategy;
import fuzs.puzzleslib.api.capability.v2.data.SyncedCapabilityComponent;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.capability.v2.ClientboundSyncCapabilityMessage;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public interface PlayerCapabilityKey<C extends CapabilityComponent>
extends CapabilityKey<C> {
    public void syncToRemote(class_3222 var1);

    public static <C extends CapabilityComponent> void syncCapabilityToRemote(class_1297 holder, class_3222 receiver, SyncStrategy syncStrategy, C capability, class_2960 id, boolean force) {
        if (syncStrategy != SyncStrategy.MANUAL) {
            if (!(capability instanceof SyncedCapabilityComponent)) {
                if (!force) {
                    throw new IllegalStateException("Unable to sync capability component that is not of type %s".formatted(SyncedCapabilityComponent.class));
                }
                return;
            }
            SyncedCapabilityComponent syncedCapability = (SyncedCapabilityComponent)capability;
            if (force || syncedCapability.isDirty()) {
                syncStrategy.sendTo(new ClientboundSyncCapabilityMessage(id, holder, capability.toCompoundTag()), receiver);
                syncedCapability.markClean();
            }
        } else if (!force) {
            PuzzlesLib.LOGGER.warn("Attempting to sync capability {} that is set to manual syncing", (Object)id);
        }
    }
}

