/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.capability.v3;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import dev.onyxstudios.cca.api.v3.component.ComponentAccess;
import fuzs.puzzleslib.api.capability.v3.CapabilityController;
import fuzs.puzzleslib.api.capability.v3.data.BlockEntityCapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import fuzs.puzzleslib.api.capability.v3.data.CapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.EntityCapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.LevelCapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.LevelChunkCapabilityKey;
import fuzs.puzzleslib.api.core.v1.utility.NbtSerializable;
import fuzs.puzzleslib.impl.capability.v3.GlobalCapabilityRegister;
import fuzs.puzzleslib.impl.capability.v3.data.FabricBlockEntityCapabilityKey;
import fuzs.puzzleslib.impl.capability.v3.data.FabricCapabilityKey;
import fuzs.puzzleslib.impl.capability.v3.data.FabricEntityCapabilityKey;
import fuzs.puzzleslib.impl.capability.v3.data.FabricLevelCapabilityKey;
import fuzs.puzzleslib.impl.capability.v3.data.FabricLevelChunkCapabilityKey;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2586;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7225;

public final class FabricCapabilityController
implements CapabilityController {
    private final String modId;

    public FabricCapabilityController(String modId) {
        this.modId = modId;
    }

    @Override
    public <T extends class_1297, C extends CapabilityComponent<T>> EntityCapabilityKey.Mutable<T, C> registerEntityCapability(String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory, Class<T> entityType) {
        return this.registerCapability(class_1297.class, identifier, capabilityFactory, entityType::isInstance, FabricEntityCapabilityKey::new);
    }

    @Override
    public <T extends class_2586, C extends CapabilityComponent<T>> BlockEntityCapabilityKey<T, C> registerBlockEntityCapability(String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory, Class<T> blockEntityType) {
        return this.registerCapability(class_2586.class, identifier, capabilityFactory, blockEntityType::isInstance, FabricBlockEntityCapabilityKey::new);
    }

    @Override
    public <C extends CapabilityComponent<class_2818>> LevelChunkCapabilityKey<C> registerLevelChunkCapability(String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory) {
        return this.registerCapability(class_2818.class, identifier, capabilityFactory, FabricLevelChunkCapabilityKey::new);
    }

    @Override
    public <C extends CapabilityComponent<class_1937>> LevelCapabilityKey<C> registerLevelCapability(String identifier, Class<C> capabilityType, Supplier<C> capabilityFactory) {
        return this.registerCapability(class_1937.class, identifier, capabilityFactory, FabricLevelCapabilityKey::new);
    }

    private <T, C extends CapabilityComponent<T>, K extends CapabilityKey<T, C>> K registerCapability(Class<? extends ComponentAccess> holderType, String identifier, Supplier<C> capabilityFactory, FabricCapabilityKey.Factory<T, C, K> capabilityKeyFactory) {
        return this.registerCapability(holderType, identifier, capabilityFactory, holderType::isInstance, capabilityKeyFactory);
    }

    private <T, C extends CapabilityComponent<T>, K extends CapabilityKey<T, C>> K registerCapability(Class<? extends ComponentAccess> holderType, String identifier, Supplier<C> capabilityFactory, Predicate<Object> filter, FabricCapabilityKey.Factory<T, C, K> capabilityKeyFactory) {
        GlobalCapabilityRegister.testHolderType(holderType);
        class_2960 capabilityName = new class_2960(this.modId, identifier);
        Codec codec = Codec.STRING.comapFlatMap(string -> {
            try {
                return DataResult.success((Object)class_2522.method_10718((String)string), (Lifecycle)Lifecycle.stable());
            }
            catch (CommandSyntaxException exception) {
                return DataResult.error(() -> ((CommandSyntaxException)exception).getMessage());
            }
        }, class_2487::toString).xmap(NbtSerializable.fromCompoundTag(capabilityFactory, (class_7225.class_7874)class_5455.field_40585), capabilityComponent -> capabilityComponent.toCompoundTag((class_7225.class_7874)class_5455.field_40585));
        AttachmentType attachmentType = AttachmentRegistry.builder().persistent(codec).buildAndRegister(capabilityName);
        return capabilityKeyFactory.apply(attachmentType, filter, capabilityFactory);
    }
}

