/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketComponent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class TrinketInventory
implements class_1263 {
    private final SlotType slotType;
    private final int baseSize;
    private final TrinketComponent component;
    private final Map<UUID, class_1322> modifiers = new HashMap<UUID, class_1322>();
    private final Set<class_1322> persistentModifiers = new HashSet<class_1322>();
    private final Set<class_1322> cachedModifiers = new HashSet<class_1322>();
    private final Multimap<class_1322.class_1323, class_1322> modifiersByOperation = HashMultimap.create();
    private final Consumer<TrinketInventory> updateCallback;
    private class_2371<class_1799> stacks;
    private boolean update = false;

    public TrinketInventory(SlotType slotType, TrinketComponent comp, Consumer<TrinketInventory> updateCallback) {
        this.component = comp;
        this.slotType = slotType;
        this.baseSize = slotType.getAmount();
        this.stacks = class_2371.method_10213((int)this.baseSize, (Object)class_1799.field_8037);
        this.updateCallback = updateCallback;
    }

    public SlotType getSlotType() {
        return this.slotType;
    }

    public TrinketComponent getComponent() {
        return this.component;
    }

    public void method_5448() {
        for (int i = 0; i < this.method_5439(); ++i) {
            this.stacks.set(i, (Object)class_1799.field_8037);
        }
    }

    public int method_5439() {
        this.update();
        return this.stacks.size();
    }

    public boolean method_5442() {
        for (int i = 0; i < this.method_5439(); ++i) {
            if (((class_1799)this.stacks.get(i)).method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        this.update();
        return (class_1799)this.stacks.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.stacks, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.stacks, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.update();
        this.stacks.set(slot, (Object)stack);
    }

    public void method_5431() {
    }

    public void markUpdate() {
        this.update = true;
        this.updateCallback.accept(this);
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public Map<UUID, class_1322> getModifiers() {
        return this.modifiers;
    }

    public Collection<class_1322> getModifiersByOperation(class_1322.class_1323 operation) {
        return this.modifiersByOperation.get((Object)operation);
    }

    public void addModifier(class_1322 modifier) {
        this.modifiers.put(modifier.method_6189(), modifier);
        this.getModifiersByOperation(modifier.method_6182()).add(modifier);
        this.markUpdate();
    }

    public void addPersistentModifier(class_1322 modifier) {
        this.addModifier(modifier);
        this.persistentModifiers.add(modifier);
    }

    public void removeModifier(UUID uuid) {
        class_1322 modifier = this.modifiers.remove(uuid);
        if (modifier != null) {
            this.persistentModifiers.remove(modifier);
            this.getModifiersByOperation(modifier.method_6182()).remove(modifier);
            this.markUpdate();
        }
    }

    public void clearModifiers() {
        Iterator<UUID> iter = this.getModifiers().keySet().iterator();
        while (iter.hasNext()) {
            this.removeModifier(iter.next());
        }
    }

    public void removeCachedModifier(class_1322 attributeModifier) {
        this.cachedModifiers.remove(attributeModifier);
    }

    public void clearCachedModifiers() {
        for (class_1322 cachedModifier : this.cachedModifiers) {
            this.removeModifier(cachedModifier.method_6189());
        }
        this.cachedModifiers.clear();
    }

    public void update() {
        if (this.update) {
            this.update = false;
            double baseSize = this.baseSize;
            for (class_1322 mod : this.getModifiersByOperation(class_1322.class_1323.field_6328)) {
                baseSize += mod.method_6186();
            }
            double size = baseSize;
            for (class_1322 mod : this.getModifiersByOperation(class_1322.class_1323.field_6330)) {
                size += (double)this.baseSize * mod.method_6186();
            }
            for (class_1322 mod : this.getModifiersByOperation(class_1322.class_1323.field_6331)) {
                size *= mod.method_6186();
            }
            class_1309 entity = this.component.getEntity();
            if (size != (double)this.method_5439()) {
                class_2371 newStacks = class_2371.method_10213((int)((int)size), (Object)class_1799.field_8037);
                for (int i = 0; i < this.stacks.size(); ++i) {
                    class_1799 stack = (class_1799)this.stacks.get(i);
                    if (i < newStacks.size()) {
                        newStacks.set(i, (Object)stack);
                        continue;
                    }
                    entity.method_5775(stack);
                }
                this.stacks = newStacks;
            }
        }
    }

    public void copyFrom(TrinketInventory other) {
        this.modifiers.clear();
        this.modifiersByOperation.clear();
        this.persistentModifiers.clear();
        other.modifiers.forEach((uuid, modifier) -> this.addModifier((class_1322)modifier));
        for (class_1322 persistentModifier : other.persistentModifiers) {
            this.addPersistentModifier(persistentModifier);
        }
        this.update();
    }

    public static void copyFrom(class_1309 previous, class_1309 current) {
        throw new IllegalStateException("API SHOULD NOT BE CALLED! [copyFrom]");
    }

    public class_2487 toTag() {
        class_2499 ListTag;
        class_2487 CompoundTag = new class_2487();
        if (!this.persistentModifiers.isEmpty()) {
            ListTag = new class_2499();
            for (class_1322 entityAttributeModifier : this.persistentModifiers) {
                ListTag.add((Object)entityAttributeModifier.method_26860());
            }
            CompoundTag.method_10566("PersistentModifiers", (class_2520)ListTag);
        }
        if (!this.modifiers.isEmpty()) {
            ListTag = new class_2499();
            this.modifiers.forEach((uuid, modifier) -> {
                if (!this.persistentModifiers.contains(modifier)) {
                    ListTag.add((Object)modifier.method_26860());
                }
            });
            CompoundTag.method_10566("CachedModifiers", (class_2520)ListTag);
        }
        return CompoundTag;
    }

    public void fromTag(class_2487 tag) {
        class_1322 entityAttributeModifier;
        int i;
        class_2499 ListTag;
        if (tag.method_10573("PersistentModifiers", 9)) {
            ListTag = tag.method_10554("PersistentModifiers", 10);
            for (i = 0; i < ListTag.size(); ++i) {
                entityAttributeModifier = class_1322.method_26859((class_2487)ListTag.method_10602(i));
                if (entityAttributeModifier == null) continue;
                this.addPersistentModifier(entityAttributeModifier);
            }
        }
        if (tag.method_10573("CachedModifiers", 9)) {
            ListTag = tag.method_10554("CachedModifiers", 10);
            for (i = 0; i < ListTag.size(); ++i) {
                entityAttributeModifier = class_1322.method_26859((class_2487)ListTag.method_10602(i));
                if (entityAttributeModifier == null) continue;
                this.cachedModifiers.add(entityAttributeModifier);
                this.addModifier(entityAttributeModifier);
            }
            this.update();
        }
    }

    public class_2487 getSyncTag() {
        class_2487 CompoundTag = new class_2487();
        if (!this.modifiers.isEmpty()) {
            class_2499 ListTag = new class_2499();
            for (Map.Entry<UUID, class_1322> modifier : this.modifiers.entrySet()) {
                ListTag.add((Object)modifier.getValue().method_26860());
            }
            CompoundTag.method_10566("Modifiers", (class_2520)ListTag);
        }
        return CompoundTag;
    }

    public void applySyncTag(class_2487 tag) {
        this.modifiers.clear();
        this.persistentModifiers.clear();
        this.modifiersByOperation.clear();
        if (tag.method_10573("Modifiers", 9)) {
            class_2499 ListTag = tag.method_10554("Modifiers", 10);
            for (int i = 0; i < ListTag.size(); ++i) {
                class_1322 entityAttributeModifier = class_1322.method_26859((class_2487)ListTag.method_10602(i));
                if (entityAttributeModifier == null) continue;
                this.addModifier(entityAttributeModifier);
            }
        }
        this.markUpdate();
        this.update();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrinketInventory that = (TrinketInventory)o;
        return this.slotType.equals(that.slotType);
    }

    public int hashCode() {
        return Objects.hash(this.slotType);
    }
}

