/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.MajruszsAccessories;
import com.majruszsaccessories.accessories.components.AccessoryIncompatibility;
import com.majruszsaccessories.accessories.components.MoreChestLoot;
import com.majruszsaccessories.common.AccessoryHandler;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.common.components.TradeOffer;
import com.majruszsaccessories.events.base.CustomConditions;
import com.majruszsaccessories.items.AccessoryItem;

@AutoInstance
public class AdventurerKit
extends AccessoryHandler {
    public AdventurerKit() {
        super(MajruszsAccessories.ADVENTURER_KIT, AdventurerKit.class);
        this.add(MoreChestLoot.create(1.2f)).add(AnyChestDropChance.create()).add(TradeOffer.create()).add(AccessoryIncompatibility.create(MajruszsAccessories.ADVENTURER_RUNE)).add(AccessoryIncompatibility.create(MajruszsAccessories.SOUL_OF_MINECRAFT));
    }

    static class AnyChestDropChance
    extends BonusComponent<AccessoryItem> {
        float chance = 0.025f;

        public static BonusComponent.ISupplier<AccessoryItem> create() {
            return AnyChestDropChance::new;
        }

        protected AnyChestDropChance(BonusHandler<AccessoryItem> handler) {
            super(handler);
            MoreChestLoot.OnChestOpened.listen(x$0 -> this.addToGeneratedLoot((OnLootGenerated)x$0)).addCondition(CustomConditions.dropChance(() -> Float.valueOf(this.chance), data -> MoreChestLoot.OnChestOpened.findPlayer(data).orElse(null)));
            handler.getConfig().define("any_chest_spawn_chance", Reader.number(), s -> Float.valueOf(this.chance), (s, v) -> {
                this.chance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
            });
        }
    }
}

