/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.events.OnItemFished;
import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.registry.Registries;
import com.majruszsaccessories.MajruszsAccessories;
import com.majruszsaccessories.accessories.components.AccessoryIncompatibility;
import com.majruszsaccessories.accessories.components.FishingLuckBonus;
import com.majruszsaccessories.common.AccessoryHandler;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.common.components.TradeOffer;
import com.majruszsaccessories.events.base.CustomConditions;
import com.majruszsaccessories.items.AccessoryItem;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_2960;

@AutoInstance
public class AnglerTrophy
extends AccessoryHandler {
    public AnglerTrophy() {
        super(MajruszsAccessories.ANGLER_TROPHY, AnglerTrophy.class);
        this.add(FishingLuckBonus.create(2.5f)).add(FishingDropChance.create(0.01f)).add(TradeOffer.create()).add(AccessoryIncompatibility.create(MajruszsAccessories.ANGLER_RUNE)).add(AccessoryIncompatibility.create(MajruszsAccessories.SOUL_OF_MINECRAFT));
    }

    public static class FishingDropChance
    extends BonusComponent<AccessoryItem> {
        float fishingChance = 0.005f;

        public static BonusComponent.ISupplier<AccessoryItem> create(float chance) {
            return handler -> new FishingDropChance(handler, chance);
        }

        protected FishingDropChance(BonusHandler<AccessoryItem> handler, float chance) {
            super(handler);
            this.fishingChance = chance;
            OnItemFished.listen(this::onFished).addCondition(CustomConditions.dropChance(s -> Float.valueOf(this.fishingChance), data -> data.player));
            handler.getConfig().define("fishing_drop_chance", Reader.number(), s -> Float.valueOf(this.fishingChance), (s, v) -> {
                this.fishingChance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
            });
        }

        private void onFished(OnItemFished data) {
            this.spawnFlyingItem(data.getLevel(), data.hook.method_19538(), data.player.method_19538());
        }
    }

    public static class FishDropChance
    extends BonusComponent<AccessoryItem> {
        float fishChance;
        List<class_2960> lootIds = Stream.of("minecraft:cod", "minecraft:pufferfish", "minecraft:salmon", "minecraft:tropical_fish").map(class_2960::new).toList();

        public static BonusComponent.ISupplier<AccessoryItem> create(float chance) {
            return handler -> new FishDropChance(handler, chance);
        }

        protected FishDropChance(BonusHandler<AccessoryItem> handler, float chance) {
            super(handler);
            this.fishChance = chance;
            OnLootGenerated.listen(x$0 -> this.addToGeneratedLoot((OnLootGenerated)x$0)).addCondition(data -> data.entity != null).addCondition(data -> this.lootIds.contains(Registries.ENTITY_TYPES.getId((Object)data.entity.method_5864()))).addCondition(CustomConditions.dropChance(s -> Float.valueOf(this.fishChance), data -> data.killer));
            handler.getConfig().define("fish_drop_chance", Reader.number(), s -> Float.valueOf(this.fishChance), (s, v) -> {
                this.fishChance = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
            }).define("fish_ids", Reader.list((IReader)Reader.location()), s -> this.lootIds, (s, v) -> {
                this.lootIds = v;
            });
        }
    }
}

