/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszlibrary.events.OnItemBrushed;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;

public class BrushingExtraItem
extends BonusComponent<AccessoryItem> {
    RangedFloat chance = new RangedFloat().id("chance").maxRange((Range<Float>)Range.CHANCE);

    public static BonusComponent.ISupplier<AccessoryItem> create(float chance) {
        return handler -> new BrushingExtraItem(handler, chance);
    }

    protected BrushingExtraItem(BonusHandler<AccessoryItem> handler, float chance) {
        super(handler);
        this.chance.set(chance, (Range<Float>)Range.CHANCE);
        OnItemBrushed.listen(this::addExtraLoot);
        this.addTooltip("majruszsaccessories.bonuses.extra_archaeology_item", TooltipHelper.asPercent(this.chance));
        handler.getConfig().define("extra_archaeology_item", this.chance::define);
    }

    private void addExtraLoot(OnItemBrushed data) {
        AccessoryHolder holder = AccessoryHolders.get((class_1309)data.player).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        if (!holder.isValid() || holder.isBonusDisabled() || !Random.check((float)holder.apply(this.chance))) {
            return;
        }
        float width = class_1299.field_6052.method_17685();
        float height = class_1299.field_6052.method_17686();
        class_243 itemOffset = AnyPos.from((class_2350)data.direction).mul((Number)Float.valueOf(width), (Number)Float.valueOf(height), (Number)Float.valueOf(width)).mul((Number)Float.valueOf(0.5f)).vec3();
        class_243 start = AnyPos.from((class_2338)data.blockEntity.method_11016()).center().add(data.direction).add(itemOffset).vec3();
        class_243 end = AnyPos.from((class_2338)data.blockEntity.method_11016()).center().add(AnyPos.from((class_2350)data.direction).mul((Number)1.5)).vec3();
        ObjectArrayList extraItems = LootHelper.getLootTable((class_2960)data.location).method_51878(LootHelper.toGiftParams((class_1297)data.player));
        for (class_1799 itemStack : extraItems) {
            LevelHelper.spawnItemEntityFlyingTowardsDirection((class_1799)itemStack, (class_1937)data.getLevel(), (class_243)start, (class_243)end);
        }
        this.spawnEffects(data, holder);
    }

    private void spawnEffects(OnItemBrushed data, AccessoryHolder holder) {
        holder.getParticleEmitter().count(8).position(AnyPos.from((class_2338)data.blockEntity.method_11016()).center().add(data.direction).vec3()).emit((class_1937)data.getServerLevel());
    }
}

