/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.events.OnFishingExtraItemsGet;
import com.majruszlibrary.item.LootHelper;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_39;

public class FishingExtraTreasure
extends BonusComponent<AccessoryItem> {
    RangedFloat chance = new RangedFloat().id("chance").maxRange((Range<Float>)Range.CHANCE);

    public static BonusComponent.ISupplier<AccessoryItem> create(float chance) {
        return handler -> new FishingExtraTreasure(handler, chance);
    }

    protected FishingExtraTreasure(BonusHandler<AccessoryItem> handler, float chance) {
        super(handler);
        this.chance.set(chance, (Range<Float>)Range.CHANCE);
        OnFishingExtraItemsGet.listen(this::addExtraTreasure);
        this.addTooltip("majruszsaccessories.bonuses.extra_fishing_treasure", TooltipHelper.asPercent(this.chance));
        handler.getConfig().define("extra_fishing_treasure", this.chance::define);
    }

    private void addExtraTreasure(OnFishingExtraItemsGet data) {
        AccessoryHolder holder = AccessoryHolders.get((class_1309)data.player).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        if (!holder.isValid() || holder.isBonusDisabled() || !Random.check((float)holder.apply(this.chance))) {
            return;
        }
        data.extraItems.addAll(LootHelper.getLootTable((class_2960)class_39.field_854).method_51878(LootHelper.toGiftParams((class_1297)data.player)));
        this.spawnEffects(data, holder);
    }

    private void spawnEffects(OnFishingExtraItemsGet data, AccessoryHolder holder) {
        class_2338 position = LevelHelper.getPositionOverFluid((class_1937)data.getLevel(), (class_2338)data.hook.method_24515());
        holder.getParticleEmitter().count(4).offset(ParticleEmitter.offset((float)0.125f)).position(AnyPos.from((Number)data.hook.method_23317(), (Number)((double)position.method_10264() + 0.25), (Number)data.hook.method_23321()).vec3()).emit((class_1937)data.getServerLevel());
    }
}

