/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.entity.AttributeHandler;
import com.majruszlibrary.events.OnItemFished;
import com.majruszlibrary.events.OnPlayerTicked;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5134;

public class FishingLuckBonus
extends BonusComponent<AccessoryItem> {
    final AttributeHandler attribute;
    RangedFloat luck = new RangedFloat().id("bonus").maxRange((Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(100.0f)));

    public static BonusComponent.ISupplier<AccessoryItem> create(float luck) {
        return handler -> new FishingLuckBonus(handler, luck);
    }

    protected FishingLuckBonus(BonusHandler<AccessoryItem> handler, float luck) {
        super(handler);
        this.attribute = new AttributeHandler("%s_fishing_luck_bonus".formatted(handler.getId()), () -> class_5134.field_23726, class_1322.class_1323.field_6328);
        this.luck.set(luck, (Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(10.0f)));
        OnPlayerTicked.listen(this::updateLuck).addCondition(Condition.isLogicalServer()).addCondition(Condition.cooldown((float)4.0f));
        OnItemFished.listen(this::spawnEffects).addCondition(Condition.isLogicalServer());
        this.addTooltip("majruszsaccessories.bonuses.fishing_luck", TooltipHelper.asValue(this.luck));
        handler.getConfig().define("fishing_luck", this.luck::define);
    }

    private void updateLuck(OnPlayerTicked data) {
        this.attribute.setValue((double)this.getLuck(data.player)).apply((class_1309)data.player);
    }

    private float getLuck(class_1657 player) {
        if (player.field_7513 == null) {
            return 0.0f;
        }
        AccessoryHolder holder = AccessoryHolders.get((class_1309)player).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        return holder.isValid() && !holder.isBonusDisabled() ? holder.apply(this.luck) : 0.0f;
    }

    private void spawnEffects(OnItemFished data) {
        AccessoryHolder holder = AccessoryHolders.get((class_1309)data.player).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        if (!holder.isValid() || holder.isBonusDisabled()) {
            return;
        }
        class_2338 position = LevelHelper.getPositionOverFluid((class_1937)data.getLevel(), (class_2338)data.hook.method_24515());
        holder.getParticleEmitter().count(4).offset(ParticleEmitter.offset((float)0.125f)).position(AnyPos.from((Number)data.hook.method_23317(), (Number)((double)position.method_10264() + 0.25), (Number)data.hook.method_23321()).vec3()).emit((class_1937)data.getServerLevel());
    }
}

