/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.events.OnPlayerTicked;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.events.base.Event;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.platform.Side;
import com.majruszlibrary.text.TextHelper;
import com.majruszsaccessories.MajruszsAccessories;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.ITooltipProvider;
import com.majruszsaccessories.tooltip.TooltipHelper;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class MoreChestLoot
extends BonusComponent<AccessoryItem> {
    static final int BLOCKS_DISTANCE = 6000;
    RangedFloat sizeMultiplier = new RangedFloat().id("multiplier").maxRange((Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(10.0f)));

    public static BonusComponent.ISupplier<AccessoryItem> create(float sizeMultiplier) {
        return handler -> new MoreChestLoot(handler, sizeMultiplier);
    }

    protected MoreChestLoot(BonusHandler<AccessoryItem> handler, float sizeMultiplier) {
        super(handler);
        this.sizeMultiplier.set(sizeMultiplier, (Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(10.0f)));
        OnChestOpened.listen(this::addExtraLoot);
        this.addTooltip("majruszsaccessories.bonuses.more_chest_loot", this.getPerPercentInfo(), this.getPercentInfo(), this.getCurrentInfo());
        handler.getConfig().define("chest_size_bonus", this.sizeMultiplier::define);
    }

    private void addExtraLoot(OnLootGenerated data) {
        class_3222 player = OnChestOpened.findPlayer(data).orElse(null);
        if (player == null) {
            return;
        }
        AccessoryHolder holder = AccessoryHolders.get((class_1309)player).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        if (!holder.isValid() || holder.isBonusDisabled()) {
            return;
        }
        float sizeMultiplier = 1.0f + holder.apply(this.sizeMultiplier) * MoreChestLoot.getDistanceBonus(player);
        boolean hasIncreasedLoot = false;
        for (class_1799 itemStack : data.generatedLoot) {
            int count = Math.min(Random.round((double)(sizeMultiplier * (float)itemStack.method_7947())), itemStack.method_7914());
            hasIncreasedLoot = hasIncreasedLoot || count > itemStack.method_7947();
            itemStack.method_7939(count);
        }
        if (hasIncreasedLoot) {
            this.spawnEffects(data, holder);
        }
    }

    private void spawnEffects(OnLootGenerated data, AccessoryHolder holder) {
        holder.getParticleEmitter().count(24).offset(ParticleEmitter.offset((float)0.4f)).position(data.origin).emit((class_1937)data.getServerLevel());
    }

    private ITooltipProvider getPerPercentInfo() {
        return TooltipHelper.asPercent(this.sizeMultiplier).valueMultiplier(1.6666666E-4f).scale(4);
    }

    private ITooltipProvider getPercentInfo() {
        return TooltipHelper.asPercent(this.sizeMultiplier).scale(4);
    }

    private ITooltipProvider getCurrentInfo() {
        return holder -> TextHelper.literal((String)TextHelper.percent((float)(holder.apply(this.sizeMultiplier) * BonusInfo.CURRENT_BONUS), (int)4));
    }

    private static float getDistanceBonus(class_3222 player) {
        Optional spawnPoint = LevelHelper.getSpawnPoint((class_3222)player);
        return spawnPoint.map(point -> Float.valueOf((float)class_3532.method_15350((double)((double)Math.round(point.position.method_1022(player.method_19538())) / 6000.0), (double)0.0, (double)1.0))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public static class OnChestOpened {
        public static Event<OnLootGenerated> listen(Consumer<OnLootGenerated> consumer) {
            return OnLootGenerated.listen(consumer).addCondition(Condition.isLogicalServer()).addCondition(data -> data.lootId.toString().contains("chests/"));
        }

        public static Optional<class_3222> findPlayer(OnLootGenerated data) {
            class_1297 class_12972 = data.entity;
            if (class_12972 instanceof class_3222) {
                class_3222 player = (class_3222)class_12972;
                return Optional.of(player);
            }
            if (data.origin != null && (class_12972 = data.level.method_18459(data.origin.field_1352, data.origin.field_1351, data.origin.field_1350, 5.0, true)) instanceof class_3222) {
                class_3222 player = (class_3222)class_12972;
                return Optional.of(player);
            }
            return Optional.empty();
        }
    }

    public static class BonusInfo {
        static float CURRENT_BONUS;
        float bonus;

        public BonusInfo(float bonus) {
            this.bonus = bonus;
        }

        public BonusInfo() {
            this(0.0f);
        }

        @Environment(value=EnvType.CLIENT)
        private static void onClient(BonusInfo data) {
            CURRENT_BONUS = data.bonus;
        }

        static {
            Serializables.get(BonusInfo.class).define("bonus", Reader.number(), s -> Float.valueOf(s.bonus), (s, v) -> {
                s.bonus = v.floatValue();
            });
            Side.runOnClient(() -> () -> MajruszsAccessories.MORE_CHEST_LOOT.addClientCallback(BonusInfo::onClient));
            CURRENT_BONUS = 0.0f;
        }
    }

    @AutoInstance
    public static class Notifier {
        public Notifier() {
            OnPlayerTicked.listen(this::sendUpdatedBonus).addCondition(Condition.isLogicalServer()).addCondition(Condition.cooldown((float)1.0f));
        }

        private void sendUpdatedBonus(OnPlayerTicked data) {
            class_3222 player = (class_3222)data.player;
            MajruszsAccessories.MORE_CHEST_LOOT.sendToClient(player, (Object)new BonusInfo(MoreChestLoot.getDistanceBonus(player)));
        }
    }
}

