/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.accessories.components;

import com.majruszlibrary.entity.AttributeHandler;
import com.majruszlibrary.events.OnAnimalTamed;
import com.majruszlibrary.events.OnBabySpawned;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.math.Range;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.config.RangedFloat;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1498;
import net.minecraft.class_1937;
import net.minecraft.class_5134;

public class TamingStrongerAnimals
extends BonusComponent<AccessoryItem> {
    final AttributeHandler health;
    final AttributeHandler damage;
    final AttributeHandler speed;
    final AttributeHandler jumpHeight;
    RangedFloat bonus = new RangedFloat().id("bonus").maxRange((Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(10.0f)));

    public static BonusComponent.ISupplier<AccessoryItem> create(float bonus) {
        return handler -> new TamingStrongerAnimals(handler, bonus);
    }

    protected TamingStrongerAnimals(BonusHandler<AccessoryItem> handler, float bonus) {
        super(handler);
        this.health = new AttributeHandler("%s_health_multiplier".formatted(handler.getId()), () -> class_5134.field_23716, class_1322.class_1323.field_6330);
        this.damage = new AttributeHandler("%s_damage_multiplier".formatted(handler.getId()), () -> class_5134.field_23721, class_1322.class_1323.field_6330);
        this.speed = new AttributeHandler("%s_speed_multiplier".formatted(handler.getId()), () -> class_5134.field_23719, class_1322.class_1323.field_6330);
        this.jumpHeight = new AttributeHandler("%s_jump_height_multiplier".formatted(handler.getId()), () -> class_5134.field_23728, class_1322.class_1323.field_6330);
        this.bonus.set(bonus, (Range<Float>)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f)));
        OnAnimalTamed.listen(this::applyBonuses).addCondition(Condition.isLogicalServer());
        OnBabySpawned.listen(this::applyBonuses).addCondition(Condition.isLogicalServer()).addCondition(data -> this.hasModifier((class_1309)data.parentA) || this.hasModifier((class_1309)data.parentB));
        this.addTooltip("majruszsaccessories.bonuses.animal_attributes", TooltipHelper.asPercent(this.bonus));
        handler.getConfig().define("animal_bonus", this.bonus::define);
    }

    private void applyBonuses(OnAnimalTamed data) {
        AccessoryHolder holder = AccessoryHolders.get((class_1309)data.tamer).get(() -> (AccessoryItem)((Object)((Object)this.getItem())));
        if (!holder.isValid() || holder.isBonusDisabled()) {
            return;
        }
        this.applyBonuses(holder.apply(this.bonus), (class_1309)data.animal);
        this.spawnEffects(data, holder);
    }

    private void applyBonuses(OnBabySpawned data) {
        this.applyBonuses((float)Math.max(this.getModifierValueSafe((class_1309)data.parentA), this.getModifierValueSafe((class_1309)data.parentB)), (class_1309)data.child);
    }

    private void applyBonuses(float bonus, class_1309 entity) {
        this.health.setValue((double)bonus).apply(entity);
        if (this.damage.hasAttribute(entity)) {
            this.damage.setValue((double)bonus).apply(entity);
        }
        if (entity instanceof class_1498) {
            class_1498 horse = (class_1498)entity;
            this.jumpHeight.setValue((double)bonus).apply((class_1309)horse);
            this.speed.setValue((double)bonus).apply((class_1309)horse);
        }
        entity.method_6033(entity.method_6063());
    }

    private void spawnEffects(OnAnimalTamed data, AccessoryHolder holder) {
        holder.getParticleEmitter().count(4).sizeBased((class_1297)data.animal).emit((class_1937)data.getServerLevel());
    }

    private double getModifierValueSafe(class_1309 entity) {
        return this.hasModifier(entity) ? this.getModifierValue(entity) : 0.0;
    }

    private double getModifierValue(class_1309 entity) {
        return entity.method_6127().method_27307(class_5134.field_23716, this.health.getUUID());
    }

    private boolean hasModifier(class_1309 entity) {
        return entity.method_6127().method_27305(class_5134.field_23716, this.health.getUUID());
    }
}

