/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.common;

import com.majruszlibrary.client.ClientHelper;
import com.majruszlibrary.data.SerializableClass;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.events.OnItemDecorationsRendered;
import com.majruszlibrary.text.TextHelper;
import com.majruszsaccessories.MajruszsAccessories;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.BonusComponent;
import com.majruszsaccessories.events.OnAccessoryTooltip;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.items.BoosterItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;

public class BonusHandler<Type extends class_1792> {
    protected final List<BonusComponent<Type>> components = new ArrayList<BonusComponent<Type>>();
    protected final Supplier<Type> item;
    protected final Class<?> clazz;
    protected final String id;

    public BonusHandler(Supplier<Type> item, Class<?> clazz, String id) {
        this.item = item;
        this.clazz = clazz;
        this.id = id;
    }

    public BonusHandler<Type> add(BonusComponent.ISupplier<Type> supplier) {
        this.components.add(supplier.apply(this));
        return this;
    }

    public List<? extends BonusComponent<Type>> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    public Type getItem() {
        return (Type)((class_1792)this.item.get());
    }

    public SerializableClass<?> getConfig() {
        return Serializables.getStatic(this.clazz);
    }

    public String getId() {
        return this.id;
    }

    protected void addTooltip(OnAccessoryTooltip data) {
        this.components.stream().map(BonusComponent::getTooltipProviders).flatMap(Collection::stream).map(provider -> {
            if (data.holder.hasBonusRangeDefined() && !data.holder.hasBonusDefined()) {
                return provider.getRangeTooltip(data.holder);
            }
            if (ClientHelper.isShiftDown()) {
                return provider.getDetailedTooltip(data.holder);
            }
            return provider.getTooltip(data.holder);
        }).map(component -> {
            if (data.holder.isBonusDisabled() && this.item.get() instanceof AccessoryItem) {
                return TextHelper.literal((String)component.getString()).method_27695(new class_124[]{class_124.field_1063, class_124.field_1055});
            }
            return component.method_27692(class_124.field_1080);
        }).forEach(data.components::add);
    }

    protected void addBoosterIcon(OnItemDecorationsRendered data) {
        class_1799 overlay = BonusHandler.getOverlay(data.itemStack);
        if (!overlay.method_7960()) {
            data.gui.method_51427(overlay, data.x, data.y);
        }
    }

    private static class_1799 getOverlay(class_1799 itemStack) {
        if (itemStack.method_7909() instanceof BoosterItem) {
            return new class_1799((class_1935)MajruszsAccessories.BOOSTER_OVERLAY_SINGLE.get());
        }
        AccessoryHolder holder = AccessoryHolder.getOrCreate(itemStack);
        return switch (holder.getBoosters().size()) {
            case 1 -> new class_1799((class_1935)MajruszsAccessories.BOOSTER_OVERLAY_SINGLE.get());
            case 2 -> new class_1799((class_1935)MajruszsAccessories.BOOSTER_OVERLAY_DOUBLE.get());
            case 3 -> new class_1799((class_1935)MajruszsAccessories.BOOSTER_OVERLAY_TRIPLE.get());
            default -> class_1799.field_8037;
        };
    }
}

